/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.java;

import com.intellij.formatting.Block;
import com.intellij.formatting.FormattingModel;
import com.intellij.formatting.FormattingModelBuilder;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.TokenType;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.JavaCodeStyleSettings;
import com.intellij.psi.formatter.FormatterUtil;
import com.intellij.psi.formatter.FormattingDocumentModelImpl;
import com.intellij.psi.formatter.java.AbstractJavaBlock;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.codeStyle.PsiBasedFormatterModelWithShiftIndentInside;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaFormattingModelBuilder
implements FormattingModelBuilder {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.lang.java.JavaFormattingModelBuilder");

    @NotNull
    public FormattingModel createModel(PsiElement element, CodeStyleSettings settings) {
        FileElement fileElement = TreeUtil.getFileElement((TreeElement)SourceTreeToPsiMap.psiElementToTree(element));
        LOG.assertTrue(fileElement != null, (Object)("File element should not be null for " + element));
        CommonCodeStyleSettings commonSettings = settings.getCommonSettings((Language)JavaLanguage.INSTANCE);
        JavaCodeStyleSettings customJavaSettings = (JavaCodeStyleSettings)settings.getCustomSettings(JavaCodeStyleSettings.class);
        Block block = AbstractJavaBlock.newJavaBlock(fileElement, commonSettings, customJavaSettings);
        FormattingDocumentModelImpl model = FormattingDocumentModelImpl.createOn(element.getContainingFile());
        return new PsiBasedFormatterModelWithShiftIndentInside(element.getContainingFile(), block, model);
    }

    public TextRange getRangeAffectingIndent(PsiFile file2, int offset, ASTNode elementAtOffset) {
        return JavaFormattingModelBuilder.doGetRangeAffectingIndent(elementAtOffset);
    }

    @Nullable
    public static TextRange doGetRangeAffectingIndent(ASTNode elementAtOffset) {
        ASTNode current = elementAtOffset;
        if ((current = JavaFormattingModelBuilder.findNearestExpressionParent(current)) == null) {
            if (elementAtOffset.getElementType() == TokenType.WHITE_SPACE) {
                ASTNode prevElement = elementAtOffset.getTreePrev();
                if (prevElement == null) {
                    return elementAtOffset.getTextRange();
                }
                ASTNode prevExpressionParent = JavaFormattingModelBuilder.findNearestExpressionParent(prevElement);
                if (prevExpressionParent == null) {
                    return elementAtOffset.getTextRange();
                }
                return new TextRange(prevExpressionParent.getTextRange().getStartOffset(), elementAtOffset.getTextRange().getEndOffset());
            }
            return JavaFormattingModelBuilder.combineWithErrorElementIfPossible(elementAtOffset);
        }
        return current.getTextRange();
    }

    @Nullable
    private static TextRange combineWithErrorElementIfPossible(@NotNull ASTNode node) {
        if (node.getElementType() == TokenType.ERROR_ELEMENT) {
            return node.getTextRange();
        }
        ASTNode prevLeaf = FormatterUtil.getPreviousLeaf(node, TokenType.WHITE_SPACE);
        if (prevLeaf == null || prevLeaf.getElementType() != TokenType.ERROR_ELEMENT) {
            return node.getTextRange();
        }
        TextRange range = JavaFormattingModelBuilder.doGetRangeAffectingIndent(prevLeaf);
        if (range == null) {
            return node.getTextRange();
        }
        return new TextRange(range.getStartOffset(), node.getTextRange().getEndOffset());
    }

    @Nullable
    private static ASTNode findNearestExpressionParent(ASTNode current) {
        ASTNode result;
        for (result = current; result != null; result = result.getTreeParent()) {
            PsiElement psi = result.getPsi();
            if (!(psi instanceof PsiExpression) || psi.getParent() instanceof PsiExpression) continue;
            return result;
        }
        return result;
    }
}

