/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.LighterLazyParseableNode;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiBuilderFactory;
import com.intellij.lang.impl.PsiBuilderImpl;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiBuilderFactoryImpl
extends PsiBuilderFactory {
    @NotNull
    public PsiBuilder createBuilder(@NotNull Project project2, @NotNull ASTNode chameleon) {
        return this.createBuilder(project2, chameleon, null, chameleon.getElementType().getLanguage(), chameleon.getChars());
    }

    @NotNull
    public PsiBuilder createBuilder(@NotNull Project project2, @NotNull LighterLazyParseableNode chameleon) {
        Language language = chameleon.getTokenType().getLanguage();
        ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(language);
        return new PsiBuilderImpl(project2, parserDefinition, PsiBuilderFactoryImpl.createLexer(project2, language), chameleon, chameleon.getText());
    }

    @NotNull
    public PsiBuilder createBuilder(@NotNull Project project2, @NotNull ASTNode chameleon, @Nullable Lexer lexer, @NotNull Language lang, @NotNull CharSequence seq) {
        ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(lang);
        return new PsiBuilderImpl(project2, parserDefinition, lexer != null ? lexer : PsiBuilderFactoryImpl.createLexer(project2, lang), chameleon, seq);
    }

    @NotNull
    public PsiBuilder createBuilder(@NotNull Project project2, @NotNull LighterLazyParseableNode chameleon, @Nullable Lexer lexer, @NotNull Language lang, @NotNull CharSequence seq) {
        Language language = chameleon.getTokenType().getLanguage();
        ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(language);
        return new PsiBuilderImpl(project2, parserDefinition, lexer != null ? lexer : PsiBuilderFactoryImpl.createLexer(project2, lang), chameleon, seq);
    }

    private static Lexer createLexer(Project project2, Language lang) {
        ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(lang);
        assert (parserDefinition != null) : "ParserDefinition absent for language: " + lang.getID();
        return parserDefinition.createLexer(project2);
    }

    @NotNull
    public PsiBuilder createBuilder(@NotNull ParserDefinition parserDefinition, @NotNull Lexer lexer, @NotNull CharSequence seq) {
        return new PsiBuilderImpl(null, null, parserDefinition.getWhitespaceTokens(), parserDefinition.getCommentTokens(), lexer, null, seq, null, null);
    }
}

