/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.html.structureView;

import com.intellij.icons.AllIcons;
import com.intellij.ide.util.ActionShortcutProvider;
import com.intellij.ide.util.FileStructureNodeProvider;
import com.intellij.ide.util.treeView.smartTree.ActionPresentation;
import com.intellij.ide.util.treeView.smartTree.ActionPresentationData;
import com.intellij.ide.util.treeView.smartTree.TreeElement;
import com.intellij.lang.html.structureView.Html5SectionTreeElement;
import com.intellij.lang.html.structureView.Html5SectionsProcessor;
import com.intellij.lang.html.structureView.HtmlFileTreeElement;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.util.PropertyOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.filters.XmlTagFilter;
import com.intellij.psi.scope.processor.FilterElementProcessor;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xml.XmlBundle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public class Html5SectionsNodeProvider
implements FileStructureNodeProvider<Html5SectionTreeElement>,
PropertyOwner,
ActionShortcutProvider {
    public static final String ACTION_ID = "HTML5_OUTLINE_MODE";
    public static final String HTML5_OUTLINE_PROVIDER_PROPERTY = "html5.sections.node.provider";

    @NotNull
    public String getName() {
        return ACTION_ID;
    }

    @NotNull
    public ActionPresentation getPresentation() {
        return new ActionPresentationData(XmlBundle.message((String)"html5.outline.mode", (Object[])new Object[0]), null, AllIcons.Xml.Html5);
    }

    @NotNull
    public String getCheckBoxText() {
        return XmlBundle.message((String)"html5.outline.mode", (Object[])new Object[0]);
    }

    @NotNull
    public String getActionIdForShortcut() {
        return "FileStructurePopup";
    }

    @NotNull
    public Shortcut[] getShortcut() {
        throw new IncorrectOperationException("see getActionIdForShortcut()");
    }

    @NotNull
    public String getPropertyName() {
        return HTML5_OUTLINE_PROVIDER_PROPERTY;
    }

    @NotNull
    public Collection<Html5SectionTreeElement> provideNodes(@NotNull TreeElement node) {
        XmlDocument document;
        if (!(node instanceof HtmlFileTreeElement)) {
            return Collections.emptyList();
        }
        XmlFile xmlFile = (XmlFile)((HtmlFileTreeElement)node).getElement();
        XmlDocument xmlDocument = document = xmlFile == null ? null : xmlFile.getDocument();
        if (document == null) {
            return Collections.emptyList();
        }
        ArrayList rootTags = new ArrayList();
        document.processElements((PsiElementProcessor)new FilterElementProcessor((ElementFilter)XmlTagFilter.INSTANCE, rootTags), (PsiElement)document);
        ArrayList<Html5SectionTreeElement> result = new ArrayList<Html5SectionTreeElement>();
        for (XmlTag tag : rootTags) {
            result.addAll(Html5SectionsProcessor.processAndGetRootSections(tag));
        }
        return result;
    }
}

