/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.cacheBuilder;

import com.intellij.lang.cacheBuilder.CacheBuilderEP;
import com.intellij.lang.cacheBuilder.CacheBuilderRegistry;
import com.intellij.lang.cacheBuilder.WordsScanner;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileTypes.FileType;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CacheBuilderRegistryImpl
extends CacheBuilderRegistry {
    private final Map<FileType, WordsScanner> myMap = new HashMap<FileType, WordsScanner>();

    public void registerCacheBuilder(@NotNull FileType fileType, WordsScanner cacheBuilder) {
        this.myMap.put(fileType, cacheBuilder);
    }

    @Nullable
    public WordsScanner getCacheBuilder(@NotNull FileType fileType) {
        WordsScanner scanner = this.myMap.get(fileType);
        if (scanner != null) {
            return scanner;
        }
        for (CacheBuilderEP ep : (CacheBuilderEP[])Extensions.getExtensions((ExtensionPointName)CacheBuilderEP.EP_NAME)) {
            if (!ep.getFileType().equals(fileType.getName())) continue;
            return ep.getWordsScanner();
        }
        return null;
    }
}

