/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.XmlCodeFoldingSettings;
import com.intellij.lang.folding.FoldingBuilder;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.lang.folding.LanguageFolding;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UnfairTextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.html.HtmlFileImpl;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlComment;
import com.intellij.psi.xml.XmlConditionalSection;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlElementType;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlProlog;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.psi.xml.XmlToken;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.util.XmlTagUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class XmlCodeFoldingBuilder
implements FoldingBuilder,
DumbAware {
    private static final TokenSet XML_ATTRIBUTE_SET = TokenSet.create((IElementType[])new IElementType[]{XmlElementType.XML_ATTRIBUTE});
    private static final int MIN_TEXT_RANGE_LENGTH = 3;

    @NotNull
    public FoldingDescriptor[] buildFoldRegions(@NotNull ASTNode node, @NotNull Document document) {
        XmlTag rootTag;
        PsiElement psiElement = node.getPsi();
        XmlDocument xmlDocument = null;
        if (psiElement instanceof XmlFile) {
            XmlFile file2 = (XmlFile)psiElement;
            xmlDocument = file2.getDocument();
        } else if (psiElement instanceof XmlDocument) {
            xmlDocument = (XmlDocument)psiElement;
        }
        XmlTag xmlTag = rootTag = xmlDocument == null ? null : xmlDocument.getRootTag();
        if (rootTag == null) {
            rootTag = xmlDocument;
        }
        ArrayList<FoldingDescriptor> foldings = null;
        if (rootTag != null) {
            foldings = new ArrayList<FoldingDescriptor>();
            this.doAddForChildren((XmlElement)xmlDocument, foldings, document);
        }
        return foldings != null ? foldings.toArray(new FoldingDescriptor[foldings.size()]) : FoldingDescriptor.EMPTY;
    }

    protected void addElementsToFold(List<FoldingDescriptor> foldings, XmlElement tag, Document document) {
        this.addToFold(foldings, (PsiElement)tag, document);
        this.doAddForChildren(tag, foldings, document);
    }

    protected void doAddForChildren(XmlElement tag, List<FoldingDescriptor> foldings, Document document) {
        PsiElement[] children2;
        for (PsiElement child : children2 = tag.getChildren()) {
            FoldingBuilder foldingBuilder;
            ProgressManager.checkCanceled();
            if (child instanceof XmlTag || child instanceof XmlConditionalSection) {
                this.addElementsToFold(foldings, (XmlElement)child, document);
                continue;
            }
            if (child instanceof XmlComment) {
                this.addToFold(foldings, child, document);
                continue;
            }
            if (child instanceof XmlText || child instanceof XmlProlog) {
                PsiElement[] grandChildren;
                for (PsiElement grandChild : grandChildren = child.getChildren()) {
                    ProgressManager.checkCanceled();
                    if (!(grandChild instanceof XmlComment)) continue;
                    this.addToFold(foldings, grandChild, document);
                }
                continue;
            }
            if (child instanceof XmlAttribute && XmlCodeFoldingBuilder.isAttributeShouldBeFolded((XmlAttribute)child)) {
                this.addToFold(foldings, child, document);
                continue;
            }
            Language language = child.getLanguage();
            if (language instanceof XMLLanguage || language == Language.ANY || (foldingBuilder = LanguageFolding.INSTANCE.forLanguage(language)) == null) continue;
            Object[] foldingDescriptors = foldingBuilder.buildFoldRegions(child.getNode(), document);
            ContainerUtil.addAll(foldings, (Object[])foldingDescriptors);
        }
    }

    @Nullable
    public TextRange getRangeToFold(PsiElement element) {
        if (element instanceof XmlTag) {
            ASTNode tagNode = element.getNode();
            XmlToken tagNameElement = XmlTagUtil.getStartTagNameElement((XmlTag)((XmlTag)element));
            if (tagNameElement == null) {
                return null;
            }
            int nameEnd = tagNameElement.getTextRange().getEndOffset();
            int end = tagNode.getLastChildNode().getTextRange().getEndOffset() - 1;
            ASTNode[] attributes = tagNode.getChildren(XML_ATTRIBUTE_SET);
            if (attributes.length > 0) {
                ASTNode lastAttribute = attributes[attributes.length - 1];
                ASTNode lastAttributeBeforeCR = null;
                for (ASTNode child = tagNode.getFirstChildNode(); child != lastAttribute.getTreeNext(); child = child.getTreeNext()) {
                    if (child.getElementType() == XmlElementType.XML_ATTRIBUTE) {
                        lastAttributeBeforeCR = child;
                        continue;
                    }
                    if (child.getPsi() instanceof PsiWhiteSpace && child.textContains('\n')) break;
                }
                if (lastAttributeBeforeCR != null) {
                    int attributeEnd = lastAttributeBeforeCR.getTextRange().getEndOffset();
                    return new UnfairTextRange(attributeEnd, end);
                }
            }
            return new UnfairTextRange(nameEnd, end);
        }
        if (element instanceof XmlComment) {
            XmlComment xmlComment = (XmlComment)element;
            TextRange textRange = element.getTextRange();
            int commentStartOffset = this.getCommentStartOffset(xmlComment);
            int commentEndOffset = this.getCommentStartEnd(xmlComment);
            if (textRange.getEndOffset() - textRange.getStartOffset() > commentStartOffset + commentEndOffset) {
                return new TextRange(textRange.getStartOffset() + commentStartOffset, textRange.getEndOffset() - commentEndOffset);
            }
            return null;
        }
        if (element instanceof XmlConditionalSection) {
            XmlConditionalSection conditionalSection = (XmlConditionalSection)element;
            TextRange textRange = element.getTextRange();
            PsiElement bodyStart = conditionalSection.getBodyStart();
            int startOffset = bodyStart != null ? bodyStart.getStartOffsetInParent() : 3;
            int endOffset = 3;
            if (textRange.getEndOffset() - textRange.getStartOffset() > startOffset + endOffset) {
                return new TextRange(textRange.getStartOffset() + startOffset, textRange.getEndOffset() - endOffset);
            }
            return null;
        }
        if (element instanceof XmlAttribute) {
            XmlAttributeValue valueElement = ((XmlAttribute)element).getValueElement();
            return valueElement != null ? valueElement.getValueTextRange() : null;
        }
        return null;
    }

    protected int getCommentStartOffset(XmlComment element) {
        return 4;
    }

    protected int getCommentStartEnd(XmlComment element) {
        return 3;
    }

    protected boolean addToFold(List<FoldingDescriptor> foldings, PsiElement elementToFold, Document document) {
        int endLine;
        int startLine;
        PsiUtilCore.ensureValid((PsiElement)elementToFold);
        TextRange range = this.getRangeToFold(elementToFold);
        if (range == null) {
            return false;
        }
        if (range.getStartOffset() >= 0 && range.getEndOffset() <= elementToFold.getContainingFile().getTextRange().getEndOffset() && range.getEndOffset() <= document.getTextLength() && ((startLine = document.getLineNumber(range.getStartOffset())) < (endLine = document.getLineNumber(range.getEndOffset() - 1)) || elementToFold instanceof XmlAttribute) && range.getStartOffset() + 3 < range.getEndOffset()) {
            foldings.add(new FoldingDescriptor(elementToFold.getNode(), range));
            return true;
        }
        return false;
    }

    public String getPlaceholderText(@NotNull ASTNode node) {
        PsiElement psi = node.getPsi();
        if (psi instanceof XmlTag || psi instanceof XmlComment || psi instanceof XmlAttribute || psi instanceof XmlConditionalSection) {
            return "...";
        }
        return null;
    }

    public boolean isCollapsedByDefault(@NotNull ASTNode node) {
        PsiElement psi = node.getPsi();
        XmlCodeFoldingSettings foldingSettings = this.getFoldingSettings();
        return psi instanceof XmlTag && foldingSettings.isCollapseXmlTags() || psi instanceof XmlAttribute && foldingSettings.isCollapseHtmlStyleAttribute();
    }

    private static boolean isAttributeShouldBeFolded(XmlAttribute child) {
        return child.getContainingFile() instanceof HtmlFileImpl && "style".equalsIgnoreCase(child.getName());
    }

    protected abstract XmlCodeFoldingSettings getFoldingSettings();
}

