/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.json.psi.impl;

import com.intellij.json.JsonLanguage;
import com.intellij.json.psi.JsonFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.PsiModificationTrackerImpl;
import com.intellij.psi.impl.PsiTreeChangeEventImpl;
import com.intellij.psi.impl.PsiTreeChangePreprocessor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonTreeChangePreprocessor
implements PsiTreeChangePreprocessor {
    @Override
    public void treeChanged(@NotNull PsiTreeChangeEventImpl event) {
        if (!(event.getFile() instanceof JsonFile)) {
            return;
        }
        PsiElement element = event.getParent();
        if (element == null || !(element.getManager() instanceof PsiManagerImpl)) {
            return;
        }
        PsiModificationTrackerImpl modificationTracker = (PsiModificationTrackerImpl)element.getManager().getModificationTracker();
        boolean changedInsideCodeBlock = false;
        switch (event.getCode()) {
            case BEFORE_CHILDREN_CHANGE: {
                if (event.getParent() instanceof PsiFile) {
                    changedInsideCodeBlock = true;
                    break;
                }
            }
            case CHILDREN_CHANGED: {
                if (event.isGenericChange()) {
                    return;
                }
                changedInsideCodeBlock = this.isInsideCodeBlock(event.getParent());
                break;
            }
            case BEFORE_CHILD_ADDITION: 
            case BEFORE_CHILD_REMOVAL: 
            case CHILD_ADDED: 
            case CHILD_REMOVED: {
                changedInsideCodeBlock = this.isInsideCodeBlock(event.getParent());
                break;
            }
            case BEFORE_PROPERTY_CHANGE: 
            case PROPERTY_CHANGED: {
                changedInsideCodeBlock = false;
                break;
            }
            case BEFORE_CHILD_REPLACEMENT: 
            case CHILD_REPLACED: {
                changedInsideCodeBlock = this.isInsideCodeBlock(event.getParent());
                break;
            }
            case BEFORE_CHILD_MOVEMENT: 
            case CHILD_MOVED: {
                boolean bl = changedInsideCodeBlock = this.isInsideCodeBlock(event.getOldParent()) && this.isInsideCodeBlock(event.getNewParent());
            }
        }
        if (!changedInsideCodeBlock) {
            modificationTracker.incOutOfCodeBlockModificationCounter();
        }
    }

    private boolean isInsideCodeBlock(@Nullable PsiElement element) {
        if (element instanceof PsiFileSystemItem) {
            return false;
        }
        if (element == null || element.getParent() == null) {
            return true;
        }
        return !(element.getLanguage() instanceof JsonLanguage);
    }
}

