/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.json.psi.impl;

import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.impl.JsonContainerImpl;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JsonObjectMixin
extends JsonContainerImpl
implements JsonObject {
    private final CachedValueProvider<Map<String, JsonProperty>> myPropertyCache = new CachedValueProvider<Map<String, JsonProperty>>(){

        @Nullable
        public CachedValueProvider.Result<Map<String, JsonProperty>> compute() {
            HashMap<String, JsonProperty> cache = new HashMap<String, JsonProperty>();
            for (JsonProperty property : JsonObjectMixin.this.getPropertyList()) {
                String propertyName = property.getName();
                if (cache.containsKey(propertyName)) continue;
                cache.put(propertyName, property);
            }
            return CachedValueProvider.Result.createSingleDependency(cache, (Object)JsonObjectMixin.this);
        }
    };

    public JsonObjectMixin(@NotNull ASTNode node) {
        super(node);
    }

    @Override
    @Nullable
    public JsonProperty findProperty(@NotNull String name) {
        return (JsonProperty)((Map)CachedValuesManager.getCachedValue((PsiElement)this, this.myPropertyCache)).get(name);
    }
}

