/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.json.psi;

import com.intellij.json.JsonElementTypes;
import com.intellij.json.JsonParserDefinition;
import com.intellij.json.psi.JsonArray;
import com.intellij.json.psi.JsonElementGenerator;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonValue;
import com.intellij.lang.ASTNode;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JsonPsiUtil {
    private JsonPsiUtil() {
    }

    public static boolean isArrayElement(@NotNull PsiElement element) {
        return element instanceof JsonValue && element.getParent() instanceof JsonArray;
    }

    public static boolean isPropertyKey(@NotNull PsiElement element) {
        PsiElement parent = element.getParent();
        return parent instanceof JsonProperty && element == ((JsonProperty)parent).getNameElement();
    }

    public static boolean isPropertyValue(@NotNull PsiElement element) {
        PsiElement parent = element.getParent();
        return parent instanceof JsonProperty && element == ((JsonProperty)parent).getValue();
    }

    @NotNull
    public static PsiElement findFurthestSiblingOfSameType(@NotNull PsiElement anchor, boolean after2) {
        ASTNode node = anchor.getNode();
        IElementType expectedType = node.getElementType();
        ASTNode lastSeen = node;
        while (node != null) {
            IElementType elementType = node.getElementType();
            if (elementType == expectedType) {
                lastSeen = node;
            } else if (elementType != TokenType.WHITE_SPACE ? !JsonParserDefinition.JSON_COMMENTARIES.contains(elementType) || JsonParserDefinition.JSON_COMMENTARIES.contains(expectedType) : expectedType == JsonElementTypes.LINE_COMMENT && node.getText().indexOf(10, 1) != -1) break;
            node = after2 ? node.getTreeNext() : node.getTreePrev();
        }
        return lastSeen.getPsi();
    }

    public static boolean hasElementType(@NotNull ASTNode node, @NotNull TokenSet set) {
        return set.contains(node.getElementType());
    }

    public static boolean hasElementType(@NotNull ASTNode node, IElementType ... types) {
        return JsonPsiUtil.hasElementType(node, TokenSet.create((IElementType[])types));
    }

    public static boolean hasElementType(@NotNull PsiElement element, @NotNull TokenSet set) {
        return element.getNode() != null && JsonPsiUtil.hasElementType(element.getNode(), set);
    }

    public static boolean hasElementType(@NotNull PsiElement element, IElementType ... types) {
        return element.getNode() != null && JsonPsiUtil.hasElementType(element.getNode(), types);
    }

    @NotNull
    public static String getElementTextWithoutHostEscaping(@NotNull PsiElement element) {
        InjectedLanguageManager manager = InjectedLanguageManager.getInstance((Project)element.getProject());
        if (manager.isInjectedFragment(element.getContainingFile())) {
            return manager.getUnescapedText(element);
        }
        return element.getText();
    }

    @NotNull
    public static String stripQuotes(@NotNull String text) {
        if (text.length() > 0) {
            char firstChar = text.charAt(0);
            char lastChar = text.charAt(text.length() - 1);
            if (firstChar == '\'' || firstChar == '\"') {
                if (text.length() > 1 && firstChar == lastChar && !JsonPsiUtil.isEscapedChar(text, text.length() - 1)) {
                    return text.substring(1, text.length() - 1);
                }
                return text.substring(1);
            }
        }
        return text;
    }

    public static boolean isEscapedChar(@NotNull String text, int position) {
        int count = 0;
        for (int i = position - 1; i >= 0 && text.charAt(i) == '\\'; --i) {
            ++count;
        }
        return count % 2 != 0;
    }

    @NotNull
    public static PsiElement addProperty(@NotNull JsonObject object, @NotNull JsonProperty property, boolean first) {
        JsonProperty lastProperty;
        List<JsonProperty> propertyList = object.getPropertyList();
        if (!first && (lastProperty = (JsonProperty)ContainerUtil.getLastItem(propertyList)) != null) {
            PsiElement addedProperty = object.addAfter(property, lastProperty);
            object.addBefore(new JsonElementGenerator(object.getProject()).createComma(), addedProperty);
            return addedProperty;
        }
        PsiElement leftBrace = object.getFirstChild();
        assert (JsonPsiUtil.hasElementType(leftBrace, JsonElementTypes.L_CURLY));
        PsiElement addedProperty = object.addAfter(property, leftBrace);
        if (!propertyList.isEmpty()) {
            object.addAfter(new JsonElementGenerator(object.getProject()).createComma(), addedProperty);
        }
        return addedProperty;
    }
}

