/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.json.psi;

import com.intellij.json.JsonFileType;
import com.intellij.json.psi.JsonArray;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.json.psi.JsonValue;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import org.jetbrains.annotations.NotNull;

public class JsonElementGenerator {
    private final Project myProject;

    public JsonElementGenerator(@NotNull Project project2) {
        this.myProject = project2;
    }

    @NotNull
    public PsiFile createDummyFile(@NotNull String content) {
        PsiFileFactory psiFileFactory = PsiFileFactory.getInstance((Project)this.myProject);
        return psiFileFactory.createFileFromText("dummy." + JsonFileType.INSTANCE.getDefaultExtension(), (FileType)JsonFileType.INSTANCE, (CharSequence)content);
    }

    @NotNull
    public <T extends JsonValue> T createValue(@NotNull String content) {
        PsiFile file2 = this.createDummyFile("{\"foo\": " + content + "}");
        return (T)((JsonObject)file2.getFirstChild()).getPropertyList().get(0).getValue();
    }

    @NotNull
    public JsonObject createObject(@NotNull String content) {
        PsiFile file2 = this.createDummyFile("{" + content + "}");
        return (JsonObject)file2.getFirstChild();
    }

    @NotNull
    public JsonStringLiteral createStringLiteral(@NotNull String unescapedContent) {
        return (JsonStringLiteral)this.createValue('\"' + StringUtil.escapeStringCharacters((String)unescapedContent) + '\"');
    }

    @NotNull
    public JsonProperty createProperty(@NotNull String name, @NotNull String value) {
        PsiFile file2 = this.createDummyFile("{\"" + name + "\": " + value + "}");
        return ((JsonObject)file2.getFirstChild()).getPropertyList().get(0);
    }

    @NotNull
    public PsiElement createComma() {
        JsonArray jsonArray1 = (JsonArray)this.createValue("[1, 2]");
        return jsonArray1.getValueList().get(0).getNextSibling();
    }
}

