/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.json.formatter;

import com.intellij.application.options.CodeStyleAbstractConfigurable;
import com.intellij.application.options.CodeStyleAbstractPanel;
import com.intellij.application.options.TabbedLanguageCodeStylePanel;
import com.intellij.json.JsonLanguage;
import com.intellij.json.formatter.JsonCodeStylePanel;
import com.intellij.json.formatter.JsonCodeStyleSettings;
import com.intellij.openapi.options.Configurable;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsProvider;
import com.intellij.psi.codeStyle.CustomCodeStyleSettings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonCodeStyleSettingsProvider
extends CodeStyleSettingsProvider {
    @NotNull
    public Configurable createSettingsPage(CodeStyleSettings settings, CodeStyleSettings originalSettings) {
        return new CodeStyleAbstractConfigurable(settings, originalSettings, "JSON"){

            @Override
            protected CodeStyleAbstractPanel createPanel(CodeStyleSettings settings) {
                JsonLanguage language = JsonLanguage.INSTANCE;
                CodeStyleSettings currentSettings = this.getCurrentSettings();
                return new TabbedLanguageCodeStylePanel(language, currentSettings, settings){

                    @Override
                    protected void initTabs(CodeStyleSettings settings) {
                        this.addIndentOptionsTab(settings);
                        this.addSpacesTab(settings);
                        this.addBlankLinesTab(settings);
                        this.addWrappingAndBracesTab(settings);
                        this.addTab(new JsonCodeStylePanel(settings));
                    }
                };
            }

            @Nullable
            public String getHelpTopic() {
                return "reference.settingsdialog.codestyle.json";
            }
        };
    }

    @Nullable
    public String getConfigurableDisplayName() {
        return JsonLanguage.INSTANCE.getDisplayName();
    }

    @Nullable
    public CustomCodeStyleSettings createCustomSettings(CodeStyleSettings settings) {
        return new JsonCodeStyleSettings(settings);
    }
}

