/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.json.codeinsight;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.json.JsonBundle;
import com.intellij.json.psi.JsonElementVisitor;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class JsonDuplicatePropertyKeysInspection
extends LocalInspectionTool {
    @Nls
    @NotNull
    public String getDisplayName() {
        return JsonBundle.message("inspection.duplicate.keys.name", new Object[0]);
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        return new JsonElementVisitor(){

            @Override
            public void visitObject(@NotNull JsonObject o) {
                MultiMap keys = new MultiMap();
                for (JsonProperty property : o.getPropertyList()) {
                    keys.putValue((Object)property.getName(), (Object)property.getNameElement());
                }
                for (Map.Entry entry : keys.entrySet()) {
                    Collection sameNamedKeys = (Collection)entry.getValue();
                    if (sameNamedKeys.size() <= 1) continue;
                    for (PsiElement element : sameNamedKeys) {
                        holder.registerProblem(element, JsonBundle.message("inspection.duplicate.keys.msg.duplicate.keys", entry.getKey()), new LocalQuickFix[0]);
                    }
                }
            }
        };
    }
}

