/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javadoc;

import com.intellij.analysis.AnalysisScope;
import com.intellij.execution.CantRunException;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.CommandLineState;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.JavaCommandLineStateUtil;
import com.intellij.execution.configurations.ModuleRunProfile;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.RegexpFilter;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.facet.Facet;
import com.intellij.facet.FacetManager;
import com.intellij.ide.BrowserUtil;
import com.intellij.javadoc.JavadocBundle;
import com.intellij.javadoc.JavadocConfiguration;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.projectRoots.ex.PathUtilEx;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.JavadocOrderRootType;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.ServerPageFile;
import com.intellij.util.PathsList;
import com.intellij.util.containers.HashSet;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;

public class JavadocGeneratorRunProfile
implements ModuleRunProfile {
    private static final Logger LOGGER = Logger.getInstance((String)("#" + JavadocConfiguration.class.getName()));
    private final Project myProject;
    private final AnalysisScope myGenerationScope;
    private final JavadocConfiguration myConfiguration;

    public JavadocGeneratorRunProfile(Project project2, AnalysisScope generationScope, JavadocConfiguration configuration) {
        this.myProject = project2;
        this.myGenerationScope = generationScope;
        this.myConfiguration = configuration;
    }

    public static Sdk getSdk(@NotNull Project project2) {
        return PathUtilEx.getAnyJdk(project2);
    }

    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment env) throws ExecutionException {
        return new MyJavaCommandLineState(this.myConfiguration, this.myProject, this.myGenerationScope, env);
    }

    public String getName() {
        return JavadocBundle.message("javadoc.settings.title", new Object[0]);
    }

    public Icon getIcon() {
        return null;
    }

    @NotNull
    public Module[] getModules() {
        return Module.EMPTY_ARRAY;
    }

    private static class MyContentIterator
    extends PsiRecursiveElementWalkingVisitor {
        private final PsiManager myPsiManager;
        private final Collection<String> myPackages;
        private final Collection<String> mySourceFiles;
        private final Set<Module> myModules;
        private final boolean myUsePackageNotation;

        public MyContentIterator(Project project2, Collection<String> packages, Collection<String> sources, Set<Module> modules, boolean canUsePackageNotation) {
            this.myModules = modules;
            this.myUsePackageNotation = canUsePackageNotation;
            this.myPsiManager = PsiManager.getInstance((Project)project2);
            this.myPackages = packages;
            this.mySourceFiles = sources;
        }

        public void visitFile(PsiFile file2) {
            VirtualFile fileOrDir = file2.getVirtualFile();
            if (fileOrDir == null) {
                return;
            }
            if (!fileOrDir.isInLocalFileSystem()) {
                return;
            }
            Module module2 = ModuleUtilCore.findModuleForFile((VirtualFile)fileOrDir, (Project)this.myPsiManager.getProject());
            if (module2 != null) {
                this.myModules.add(module2);
            }
            if (file2 instanceof PsiJavaFile) {
                PsiJavaFile javaFile = (PsiJavaFile)file2;
                String packageName = javaFile.getPackageName();
                if (MyContentIterator.containsPackagePrefix(module2, packageName) || packageName.length() == 0 && !(javaFile instanceof ServerPageFile) || !this.myUsePackageNotation) {
                    this.mySourceFiles.add(FileUtil.toSystemIndependentName((String)fileOrDir.getPath()));
                } else {
                    this.myPackages.add(packageName);
                }
            }
        }

        private static boolean containsPackagePrefix(Module module2, String packageFQName) {
            if (module2 == null) {
                return false;
            }
            for (ContentEntry contentEntry : ModuleRootManager.getInstance((Module)module2).getContentEntries()) {
                for (SourceFolder sourceFolder : contentEntry.getSourceFolders(JavaModuleSourceRootTypes.SOURCES)) {
                    String packagePrefix = sourceFolder.getPackagePrefix();
                    int prefixLength = packagePrefix.length();
                    if (prefixLength <= 0 || !packageFQName.startsWith(packagePrefix)) continue;
                    return true;
                }
            }
            return false;
        }
    }

    private static class MyJavaCommandLineState
    extends CommandLineState {
        private final AnalysisScope myGenerationOptions;
        private final Project myProject;
        @NonNls
        private static final String INDEX_HTML = "index.html";
        private JavadocConfiguration myConfiguration;

        public MyJavaCommandLineState(JavadocConfiguration configuration, Project project2, AnalysisScope generationOptions, ExecutionEnvironment env) {
            super(env);
            this.myGenerationOptions = generationOptions;
            this.myProject = project2;
            this.addConsoleFilters(new Filter[]{new RegexpFilter(project2, "$FILE_PATH$:$LINE$:[^\\^]+\\^"), new RegexpFilter(project2, "$FILE_PATH$:$LINE$: warning - .+$")});
            this.myConfiguration = configuration;
        }

        protected GeneralCommandLine createCommandLine() throws ExecutionException {
            GeneralCommandLine cmdLine = new GeneralCommandLine();
            Sdk jdk = JavadocGeneratorRunProfile.getSdk(this.myProject);
            this.setupExeParams(jdk, cmdLine);
            this.setupProgramParameters(jdk, cmdLine);
            return cmdLine;
        }

        private void setupExeParams(Sdk jdk, GeneralCommandLine cmdLine) throws ExecutionException {
            String jdkPath;
            String string = jdkPath = jdk != null && jdk.getSdkType() instanceof JavaSdkType ? ((JavaSdkType)jdk.getSdkType()).getBinPath(jdk) : null;
            if (jdkPath == null) {
                throw new CantRunException(JavadocBundle.message("javadoc.generate.no.jdk.path", new Object[0]));
            }
            JavaSdkVersion version = JavaSdk.getInstance().getVersion(jdk);
            if (this.myConfiguration.HEAP_SIZE != null && this.myConfiguration.HEAP_SIZE.trim().length() != 0) {
                if (version == null || version.isAtLeast(JavaSdkVersion.JDK_1_2)) {
                    cmdLine.getParametersList().prepend("-J-Xmx" + this.myConfiguration.HEAP_SIZE + "m");
                } else {
                    cmdLine.getParametersList().prepend("-J-mx" + this.myConfiguration.HEAP_SIZE + "m");
                }
            }
            cmdLine.setWorkDirectory((File)null);
            String javadocExecutableName = File.separator + (SystemInfo.isWindows ? "javadoc.exe" : "javadoc");
            String exePath = jdkPath.replace('/', File.separatorChar) + javadocExecutableName;
            if (new File(exePath).exists()) {
                cmdLine.setExePath(exePath);
            } else {
                File parent;
                exePath = new File(jdkPath).getParent().replace('/', File.separatorChar) + javadocExecutableName;
                if (!new File(exePath).exists() && !new File(exePath = (parent = new File(System.getProperty("java.home")).getParentFile()).getPath() + File.separator + "bin" + javadocExecutableName).exists()) {
                    throw new CantRunException(JavadocBundle.message("javadoc.generate.no.jdk.path", new Object[0]));
                }
                cmdLine.setExePath(exePath);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void setupProgramParameters(Sdk jdk, GeneralCommandLine cmdLine) throws CantRunException {
            ParametersList parameters = cmdLine.getParametersList();
            if (this.myConfiguration.LOCALE != null && this.myConfiguration.LOCALE.length() > 0) {
                parameters.add("-locale");
                parameters.add(this.myConfiguration.LOCALE);
            }
            if (this.myConfiguration.OPTION_SCOPE != null) {
                parameters.add("-" + this.myConfiguration.OPTION_SCOPE);
            }
            if (!this.myConfiguration.OPTION_HIERARCHY) {
                parameters.add("-notree");
            }
            if (!this.myConfiguration.OPTION_NAVIGATOR) {
                parameters.add("-nonavbar");
            }
            if (!this.myConfiguration.OPTION_INDEX) {
                parameters.add("-noindex");
            } else if (this.myConfiguration.OPTION_SEPARATE_INDEX) {
                parameters.add("-splitindex");
            }
            if (this.myConfiguration.OPTION_DOCUMENT_TAG_USE) {
                parameters.add("-use");
            }
            if (this.myConfiguration.OPTION_DOCUMENT_TAG_AUTHOR) {
                parameters.add("-author");
            }
            if (this.myConfiguration.OPTION_DOCUMENT_TAG_VERSION) {
                parameters.add("-version");
            }
            if (!this.myConfiguration.OPTION_DOCUMENT_TAG_DEPRECATED) {
                parameters.add("-nodeprecated");
            } else if (!this.myConfiguration.OPTION_DEPRECATED_LIST) {
                parameters.add("-nodeprecatedlist");
            }
            parameters.addParametersString(this.myConfiguration.OTHER_OPTIONS);
            LinkedHashSet<Module> modules = new LinkedHashSet<Module>();
            try {
                File sourcePathTempFile = FileUtil.createTempFile((String)"javadoc", (String)"args.txt", (boolean)true);
                parameters.add("@" + sourcePathTempFile.getCanonicalPath());
                try (PrintWriter writer = new PrintWriter(new FileWriter(sourcePathTempFile));){
                    HashSet packages = new HashSet();
                    HashSet sources = new HashSet();
                    Runnable findRunnable = new Runnable((Collection)packages, (Collection)sources, modules){
                        final /* synthetic */ Collection val$packages;
                        final /* synthetic */ Collection val$sources;
                        final /* synthetic */ Set val$modules;
                        {
                            this.val$packages = collection;
                            this.val$sources = collection2;
                            this.val$modules = set;
                        }

                        @Override
                        public void run() {
                            int scopeType = myGenerationOptions.getScopeType();
                            boolean usePackageNotation = scopeType == 4 || scopeType == 7 || scopeType == 1 || scopeType == 2;
                            myGenerationOptions.accept((PsiElementVisitor)new MyContentIterator(myProject, this.val$packages, this.val$sources, this.val$modules, usePackageNotation));
                        }
                    };
                    if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(findRunnable, "Search for sources to generate javadoc in...", true, this.myProject)) {
                        return;
                    }
                    if (packages.size() + sources.size() == 0) {
                        throw new CantRunException(JavadocBundle.message("javadoc.generate.no.classes.in.selected.packages.error", new Object[0]));
                    }
                    for (String aPackage : packages) {
                        writer.println(aPackage);
                    }
                    for (String source : sources) {
                        writer.println(StringUtil.wrapWithDoubleQuote((String)source));
                    }
                    writer.println("-sourcepath");
                    OrderEnumerator enumerator = OrderEnumerator.orderEntries((Project)this.myProject);
                    enumerator = !this.myConfiguration.OPTION_INCLUDE_LIBS ? enumerator.withoutSdk().withoutLibraries() : enumerator.withoutSdk();
                    PathsList pathsList = enumerator.getSourcePathsList();
                    List files = pathsList.getRootDirs();
                    ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex();
                    StringBuilder sourcePath = new StringBuilder();
                    boolean start = true;
                    for (VirtualFile file2 : files) {
                        if (!this.myGenerationOptions.isIncludeTestSource() && fileIndex.isInTestSourceContent(file2)) continue;
                        if (start) {
                            start = false;
                        } else {
                            sourcePath.append(File.pathSeparator);
                        }
                        sourcePath.append(file2.getPath());
                    }
                    writer.println(StringUtil.wrapWithDoubleQuote((String)sourcePath.toString()));
                }
            }
            catch (IOException e) {
                LOGGER.error((Throwable)e);
            }
            this.addAndroidParameters(cmdLine, parameters, modules);
            if (this.myConfiguration.OPTION_LINK_TO_JDK_DOCS) {
                VirtualFile[] docUrls = jdk.getRootProvider().getFiles(JavadocOrderRootType.getInstance());
                for (VirtualFile docUrl : docUrls) {
                    parameters.add("-link");
                    parameters.add(VfsUtil.toUri((VirtualFile)docUrl).toString());
                }
            }
            OrderEnumerator orderEnumerator = ProjectRootManager.getInstance((Project)this.myProject).orderEntries(modules);
            PathsList classPath = jdk.getSdkType() instanceof JavaSdk ? orderEnumerator.withoutSdk().withoutModuleSourceEntries().getPathsList() : orderEnumerator.withoutModuleSourceEntries().getPathsList();
            String classPathString = classPath.getPathsString();
            if (classPathString.length() > 0) {
                parameters.add("-classpath");
                parameters.add(classPathString);
            }
            if (this.myConfiguration.OUTPUT_DIRECTORY != null) {
                parameters.add("-d");
                parameters.add(this.myConfiguration.OUTPUT_DIRECTORY.replace('/', File.separatorChar));
            }
        }

        private void addAndroidParameters(GeneralCommandLine cmdLine, ParametersList parameters, Set<Module> modules) {
            boolean haveAndroidModule = false;
            block4: for (Module module2 : modules) {
                Facet[] facetArray = FacetManager.getInstance((Module)module2).getAllFacets();
                int n = facetArray.length;
                for (int i = 0; i < n; ++i) {
                    Facet facet = facetArray[i];
                    if (!"Android".equals(facet.getName())) continue;
                    haveAndroidModule = true;
                    continue block4;
                }
            }
            if (!haveAndroidModule) {
                return;
            }
            Sdk sdk = null;
            for (SdkType type : SdkType.getAllTypes()) {
                if (!"Android SDK".equals(type.getName())) continue;
                int sdkApi = 0;
                Pattern pattern = Pattern.compile("Android API (\\d+) Platform");
                for (Sdk s : ProjectJdkTable.getInstance().getSdksOfType((SdkTypeId)type)) {
                    String name = s.toString();
                    Matcher matcher = pattern.matcher(name);
                    if (!matcher.find()) continue;
                    try {
                        int api = Integer.parseInt(matcher.group(1));
                        if (api <= sdkApi) continue;
                        sdk = s;
                        sdkApi = api;
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
                break;
            }
            if (sdk == null) {
                return;
            }
            SdkAdditionalData sdkAdditionalData = sdk.getSdkAdditionalData();
            if (sdkAdditionalData == null) {
                return;
            }
            String path = sdk.getHomePath();
            if (path == null) {
                return;
            }
            File sdkDir = new File(FileUtil.toSystemDependentName((String)path));
            String buildTarget = null;
            try {
                Field field = sdkAdditionalData.getClass().getDeclaredField("myBuildTarget");
                field.setAccessible(true);
                buildTarget = (String)field.get(sdkAdditionalData);
            }
            catch (Throwable field) {
                // empty catch block
            }
            if (buildTarget == null) {
                return;
            }
            File androidJar = new File(sdkDir, "platforms" + File.separator + buildTarget + File.separator + "android.jar");
            if (androidJar.isFile()) {
                File reference;
                cmdLine.addParameter("-bootclasspath");
                cmdLine.addParameter(androidJar.getPath());
                cmdLine.addParameter("-Xdoclint:none");
                if (this.myConfiguration.OPTION_LINK_TO_JDK_DOCS && (reference = new File(sdkDir, "docs" + File.separator + "reference")).exists()) {
                    parameters.add("-linkoffline");
                    parameters.add("https://developer.android.com/reference");
                    parameters.add(reference.getPath());
                }
            }
        }

        @NotNull
        protected OSProcessHandler startProcess() throws ExecutionException {
            OSProcessHandler handler2 = JavaCommandLineStateUtil.startProcess((GeneralCommandLine)this.createCommandLine());
            ProcessTerminatedListener.attach((ProcessHandler)handler2, (Project)this.myProject, (String)JavadocBundle.message("javadoc.generate.exited", new Object[0]));
            handler2.addProcessListener((ProcessListener)new ProcessAdapter(){

                public void processTerminated(ProcessEvent event) {
                    File url;
                    if (((MyJavaCommandLineState)this).myConfiguration.OPEN_IN_BROWSER && (url = new File(((MyJavaCommandLineState)this).myConfiguration.OUTPUT_DIRECTORY, MyJavaCommandLineState.INDEX_HTML)).exists() && event.getExitCode() == 0) {
                        BrowserUtil.browse((File)url);
                    }
                }
            });
            return handler2;
        }
    }
}

