/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.updater;

import com.intellij.ide.FrameStateListener;
import com.intellij.ide.FrameStateManager;
import com.intellij.internal.statistic.StatisticsUploadAssistant;
import com.intellij.internal.statistic.connect.StatisticsService;
import com.intellij.internal.statistic.updater.StatisticsNotificationManager;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationsConfiguration;
import com.intellij.notification.NotificationsManager;
import com.intellij.notification.impl.NotificationsConfigurationImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ApplicationComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.ui.BalloonLayout;
import com.intellij.ui.BalloonLayoutImpl;
import com.intellij.util.Alarm;
import java.awt.Window;
import org.jetbrains.annotations.NotNull;

public class SendStatisticsComponent
implements ApplicationComponent {
    private static final Logger LOG = Logger.getInstance(SendStatisticsComponent.class);
    private static final int DELAY_IN_MIN = 10;
    private final Alarm myAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)ApplicationManager.getApplication());
    private final FrameStateManager myFrameStateManager;

    public SendStatisticsComponent(@NotNull FrameStateManager frameStateManager) {
        NotificationsManager.getNotificationsManager();
        NotificationsConfigurationImpl.remove("SendUsagesStatistics");
        NotificationsConfiguration.getNotificationsConfiguration().register("IDE Usage Statistics", NotificationDisplayType.STICKY_BALLOON, false);
        this.myFrameStateManager = frameStateManager;
    }

    private static boolean isEmpty(Window window) {
        BalloonLayout layout;
        if (window instanceof IdeFrameImpl && (layout = ((IdeFrameImpl)window).getBalloonLayout()) instanceof BalloonLayoutImpl) {
            return ((BalloonLayoutImpl)layout).isEmpty();
        }
        return false;
    }

    private void runStatisticsService() {
        final StatisticsService statisticsService = StatisticsUploadAssistant.getStatisticsService();
        if (StatisticsUploadAssistant.isShouldShowNotification()) {
            this.myFrameStateManager.addListener((FrameStateListener)new FrameStateListener.Adapter(){

                public void onFrameActivated() {
                    if (SendStatisticsComponent.isEmpty(((WindowManagerEx)WindowManager.getInstance()).getMostRecentFocusedWindow())) {
                        ApplicationManager.getApplication().invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                StatisticsNotificationManager.showNotification(statisticsService);
                            }
                        });
                        SendStatisticsComponent.this.myFrameStateManager.removeListener((FrameStateListener)this);
                    }
                }
            });
        } else if (StatisticsUploadAssistant.isSendAllowed() && StatisticsUploadAssistant.isTimeToSend()) {
            this.runWithDelay(statisticsService);
        }
    }

    private void runWithDelay(final @NotNull StatisticsService statisticsService) {
        this.myAlarm.addRequest(new Runnable(){

            @Override
            public void run() {
                statisticsService.send();
            }
        }, 600000);
    }

    public void initComponent() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        this.runStatisticsService();
    }

    public void disposeComponent() {
    }

    @NotNull
    public String getComponentName() {
        return SendStatisticsComponent.class.getName();
    }
}

