/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.libraryJar;

import com.intellij.internal.statistic.AbstractApplicationUsagesCollector;
import com.intellij.internal.statistic.CollectUsagesException;
import com.intellij.internal.statistic.beans.GroupDescriptor;
import com.intellij.internal.statistic.beans.UsageDescriptor;
import com.intellij.internal.statistic.libraryJar.LibraryJarDescriptor;
import com.intellij.internal.statistic.libraryJar.LibraryJarStatisticsService;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JdkUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.ProjectScope;
import com.intellij.util.containers.hash.HashSet;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LibraryJarUsagesCollector
extends AbstractApplicationUsagesCollector {
    private static final GroupDescriptor GROUP = GroupDescriptor.create("Libraries by jars", -100.0);
    private static final String DIGIT_VERSION_PATTERN_PART = "(\\d+.\\d+|\\d+)";
    private static final Pattern JAR_FILE_NAME_PATTERN = Pattern.compile("[\\w|\\-|\\.]+-((\\d+.\\d+|\\d+)[\\w|\\.]*)jar");
    private static final Pattern DIGIT_VERSION_PATTERN = Pattern.compile("(\\d+.\\d+|\\d+).*");

    @Override
    @NotNull
    public Set<UsageDescriptor> getProjectUsages(final @NotNull Project project2) throws CollectUsagesException {
        final LibraryJarDescriptor[] descriptors = LibraryJarStatisticsService.getInstance().getTechnologyDescriptors();
        HashSet result = new HashSet(descriptors.length);
        ApplicationManager.getApplication().runReadAction(new Runnable((Set)result){
            final /* synthetic */ Set val$result;
            {
                this.val$result = set;
            }

            @Override
            public void run() {
                for (LibraryJarDescriptor descriptor : descriptors) {
                    PsiClass[] psiClasses;
                    String className = descriptor.myClass;
                    if (className == null) continue;
                    for (PsiClass psiClass : psiClasses = JavaPsiFacade.getInstance((Project)project2).findClasses(className, ProjectScope.getLibrariesScope((Project)project2))) {
                        VirtualFile localFile;
                        if (psiClass == null || (localFile = JarFileSystem.getInstance().getLocalVirtualFileFor(psiClass.getContainingFile().getVirtualFile())) == null) continue;
                        String version = LibraryJarUsagesCollector.getVersionByJarManifest(localFile);
                        if (version == null) {
                            version = LibraryJarUsagesCollector.this.getVersionByJarFileName(localFile.getName());
                        }
                        if (version == null) continue;
                        this.val$result.add(new UsageDescriptor(descriptor.myName + "_" + version, 1));
                    }
                }
            }
        });
        return result;
    }

    @Nullable
    private static String getVersionByJarManifest(@NotNull VirtualFile file2) {
        String version = JdkUtil.getJarMainAttribute((VirtualFile)file2, (Attributes.Name)Attributes.Name.IMPLEMENTATION_VERSION);
        if (version == null) {
            return null;
        }
        Matcher versionMatcher = DIGIT_VERSION_PATTERN.matcher(version);
        if (!versionMatcher.matches()) {
            return null;
        }
        return versionMatcher.group(1);
    }

    @Nullable
    public String getVersionByJarFileName(@NotNull String fileName) {
        Matcher fileNameMatcher = JAR_FILE_NAME_PATTERN.matcher(fileName);
        if (!fileNameMatcher.matches()) {
            return null;
        }
        return fileNameMatcher.group(2);
    }

    @Override
    @NotNull
    public GroupDescriptor getGroupId() {
        return GROUP;
    }
}

