/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.libraryJar;

import com.intellij.facet.frameworks.SettingsConnectionService;
import com.intellij.internal.statistic.StatisticsUploadAssistant;
import com.intellij.internal.statistic.libraryJar.LibraryJarDescriptor;
import com.intellij.internal.statistic.libraryJar.LibraryJarDescriptors;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.net.HttpConfigurable;
import com.intellij.util.xmlb.XmlSerializationException;
import com.intellij.util.xmlb.XmlSerializer;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LibraryJarStatisticsService
extends SettingsConnectionService
implements StartupActivity,
DumbAware {
    private static final String FILE_NAME = "statistics/library-jar-statistics.xml";
    private static final String DEFAULT_SETTINGS_URL = "https://www.jetbrains.com/idea/download-assistant.xml";
    private static final String DEFAULT_SERVICE_URL = "http://frameworks.jetbrains.com";
    private static final LibraryJarStatisticsService myInstance = new LibraryJarStatisticsService();
    private LibraryJarDescriptor[] myDescriptors;

    public static LibraryJarStatisticsService getInstance() {
        return myInstance;
    }

    protected LibraryJarStatisticsService() {
        super(DEFAULT_SETTINGS_URL, DEFAULT_SERVICE_URL);
    }

    @NotNull
    public LibraryJarDescriptor[] getTechnologyDescriptors() {
        if (this.myDescriptors == null) {
            if (!StatisticsUploadAssistant.isSendAllowed()) {
                return LibraryJarDescriptor.EMPTY;
            }
            URL url = this.createVersionsUrl();
            if (url == null) {
                return LibraryJarDescriptor.EMPTY;
            }
            LibraryJarDescriptors descriptors = LibraryJarStatisticsService.deserialize(url);
            this.myDescriptors = descriptors == null ? LibraryJarDescriptor.EMPTY : descriptors.getDescriptors();
        }
        return this.myDescriptors;
    }

    @Nullable
    private static LibraryJarDescriptors deserialize(@Nullable URL url) {
        if (url == null) {
            return null;
        }
        LibraryJarDescriptors libraryJarDescriptors = null;
        try {
            libraryJarDescriptors = (LibraryJarDescriptors)XmlSerializer.deserialize((URL)url, LibraryJarDescriptors.class);
        }
        catch (XmlSerializationException xmlSerializationException) {
            // empty catch block
        }
        return libraryJarDescriptors;
    }

    @Nullable
    private URL createVersionsUrl() {
        String serviceUrl = this.getServiceUrl();
        if (StringUtil.isNotEmpty((String)serviceUrl)) {
            try {
                String url = serviceUrl + "/" + FILE_NAME;
                HttpConfigurable.getInstance().prepareURL(url);
                return new URL(url);
            }
            catch (MalformedURLException malformedURLException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    public void runActivity(@NotNull Project project2) {
        Application application = ApplicationManager.getApplication();
        if (application.isUnitTestMode() || application.isHeadlessEnvironment()) {
            return;
        }
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

            @Override
            public void run() {
                LibraryJarStatisticsService.getInstance().getTechnologyDescriptors();
            }
        });
    }
}

