/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.ideSettings;

import com.intellij.internal.statistic.beans.GroupDescriptor;
import com.intellij.internal.statistic.beans.UsageDescriptor;
import com.intellij.internal.statistic.ideSettings.IdeSettingsDescriptor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.hash.HashSet;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IdeSettingsStatisticsUtils {
    public static final GroupDescriptor GROUP = GroupDescriptor.create("IDE Settings", 100.0);

    @Nullable
    public static Object getApplicationProvider(@NotNull String providerName) {
        return IdeSettingsStatisticsUtils.getProviderInstance(IdeSettingsStatisticsUtils.getApplicationComponentByName(providerName));
    }

    public static Set<UsageDescriptor> getUsages(@NotNull IdeSettingsDescriptor descriptor, @NotNull Object componentInstance) {
        HashSet descriptors = new HashSet();
        String providerName = descriptor.myProviderName;
        List<String> propertyNames = descriptor.getPropertyNames();
        if (providerName != null && propertyNames.size() > 0) {
            for (String propertyName : propertyNames) {
                Object propertyValue = IdeSettingsStatisticsUtils.getPropertyValue(componentInstance, propertyName);
                if (propertyValue == null) continue;
                descriptors.add(new UsageDescriptor(IdeSettingsStatisticsUtils.getUsageDescriptorKey(providerName, propertyName, propertyValue.toString()), 1));
            }
        }
        return descriptors;
    }

    @Nullable
    private static Object getPropertyValue(Object componentInstance, String propertyName) {
        Class<?> componentInstanceClass = componentInstance.getClass();
        Object propertyValue = ReflectionUtil.getField(componentInstanceClass, (Object)componentInstance, null, (String)propertyName);
        if (propertyValue == null) {
            Method method = ReflectionUtil.getMethod(componentInstanceClass, (String)("get" + StringUtil.capitalize((String)propertyName)), (Class[])new Class[0]);
            if (method == null) {
                method = ReflectionUtil.getMethod(componentInstanceClass, (String)("is" + StringUtil.capitalize((String)propertyName)), (Class[])new Class[0]);
            }
            if (method != null) {
                try {
                    propertyValue = method.invoke(componentInstance, new Object[0]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return propertyValue;
    }

    private static String getUsageDescriptorKey(@NotNull String providerName, @NotNull String name, @NotNull String value) {
        String shortName = StringUtil.getShortName((String)providerName);
        return shortName + "#" + name + "(" + value + ")";
    }

    @Nullable
    public static Object getProjectProvider(@Nullable Project project2, @NotNull String providerName) {
        return IdeSettingsStatisticsUtils.getProviderInstance(IdeSettingsStatisticsUtils.getProjectComponentByName(project2, providerName));
    }

    @Nullable
    private static Object getProviderInstance(Object componentInstance) {
        if (componentInstance instanceof PersistentStateComponent) {
            return ((PersistentStateComponent)componentInstance).getState();
        }
        return componentInstance;
    }

    @Nullable
    private static Object getApplicationComponentByName(@NotNull String providerName) {
        return ApplicationManager.getApplication().getPicoContainer().getComponentInstance((Object)providerName);
    }

    @Nullable
    private static Object getProjectComponentByName(@Nullable Project project2, String providerName) {
        if (project2 != null) {
            return project2.getPicoContainer().getComponentInstance((Object)providerName);
        }
        return null;
    }
}

