/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.connect;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.internal.statistic.connect.StatServiceException;
import com.intellij.internal.statistic.connect.StatisticsDataSender;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.updateSettings.impl.UpdateChecker;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.net.HttpConfigurable;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.fluent.Form;
import org.apache.http.client.fluent.Request;
import org.apache.http.client.fluent.Response;
import org.jetbrains.annotations.NotNull;

public class StatisticsHttpClientSender
implements StatisticsDataSender {
    @Override
    public void send(@NotNull String url, @NotNull String content) throws StatServiceException {
        try {
            HttpConfigurable.getInstance().prepareURL(url);
            Response response = Request.Post((String)url).bodyForm((Iterable)Form.form().add("content", content).add("uuid", UpdateChecker.getInstallationUID(PropertiesComponent.getInstance())).add("patch", String.valueOf(false)).add("ide", ApplicationNamesInfo.getInstance().getProductName()).build()).execute();
            HttpResponse httpResponse = response.returnResponse();
            if (httpResponse.getStatusLine().getStatusCode() != 200) {
                throw new StatServiceException("Error during data sending... Code: " + httpResponse.getStatusLine().getStatusCode());
            }
            Header errors = httpResponse.getFirstHeader("errors");
            if (errors != null) {
                String value = errors.getValue();
                throw new StatServiceException("Error during updating statistics " + (!StringUtil.isEmptyOrSpaces((String)value) ? " : " + value : ""));
            }
        }
        catch (StatServiceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new StatServiceException("Error during data sending...", e);
        }
    }
}

