/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.connect;

import com.intellij.facet.frameworks.SettingsConnectionService;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StatisticsConnectionService
extends SettingsConnectionService {
    private static final String PERMISSION_ATTR_NAME = "permitted";
    private static final String DISABLED = "disabled";

    public StatisticsConnectionService() {
        this(((ApplicationInfoImpl)ApplicationInfoImpl.getShadowInstance()).getStatisticsSettingsUrl(), ((ApplicationInfoImpl)ApplicationInfoImpl.getShadowInstance()).getStatisticsServiceUrl());
    }

    public StatisticsConnectionService(@NotNull String settingsUrl, @Nullable String defaultServiceUrl) {
        super(settingsUrl, defaultServiceUrl);
    }

    @NotNull
    public String[] getAttributeNames() {
        return (String[])ArrayUtil.append((Object[])super.getAttributeNames(), (Object)PERMISSION_ATTR_NAME);
    }

    public boolean isTransmissionPermitted() {
        String permitted = this.getSettingValue(PERMISSION_ATTR_NAME);
        return permitted == null || Boolean.parseBoolean(permitted);
    }

    @NotNull
    public Set<String> getDisabledGroups() {
        String disabledGroupsString = this.getSettingValue(DISABLED);
        if (disabledGroupsString == null) {
            return Collections.emptySet();
        }
        List disabledGroupsList = StringUtil.split((String)disabledGroupsString, (String)",");
        return ContainerUtil.map2Set((Collection)disabledGroupsList, (Function)new Function<String, String>(){

            public String fun(String s) {
                return s.trim();
            }
        });
    }
}

