/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.analytics;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.intellij.diagnostic.IdeErrorsDialog;
import com.intellij.ide.SystemHealthMonitor;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.internal.statistic.StatisticsUploadAssistant;
import com.intellij.internal.statistic.analytics.LastSeenExceptions;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.updateSettings.impl.ChannelStatus;
import com.intellij.openapi.updateSettings.impl.UpdateChecker;
import com.intellij.openapi.updateSettings.impl.UpdateSettings;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.HttpClientUtils;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnalyticsUploader {
    private static final boolean UNIT_TEST_MODE = ApplicationManager.getApplication() == null;
    private static final boolean DEBUG = !UNIT_TEST_MODE && ApplicationManager.getApplication().isInternal();
    @NonNls
    private static final String ANALYTICS_URL = "https://ssl.google-analytics.com/collect";
    @NonNls
    private static final String ANALYTICS_ID = DEBUG ? "UA-44790371-1" : "UA-19996407-3";
    @NonNls
    private static final String ANALYTICS_APP = "Android Studio";
    private static final String INSTALLATION_ID = UNIT_TEST_MODE ? "unit-test" : UpdateChecker.getInstallationUID(PropertiesComponent.getInstance());
    private static final int MAX_DESCRIPTION_SIZE = 150;
    private static final ImmutableSet<Class<? extends Throwable>> THROWABLE_CLASSES_TO_TRACK_MESSAGES = ImmutableSet.of(ArrayIndexOutOfBoundsException.class, ClassCastException.class, ClassNotFoundException.class);
    private static final String PROTOCOL_VERSION = "v";
    private static final String TRACKING_ID = "tid";
    private static final String APPLICATION_NAME = "an";
    private static final String APPLICATION_VERSION = "av";
    private static final String CLIENT_ID = "cid";
    private static final String HIT_TYPE = "t";
    private static final String HIT_TYPE_EVENT = "event";
    private static final String EVENT_CATEGORY = "ec";
    private static final String EVENT_ACTION = "ea";
    private static final String EVENT_LABEL = "el";
    private static final String EVENT_VALUE = "ev";
    private static final String HIT_TYPE_EXCEPTION = "exception";
    private static final String EXCEPTION_DESCRIPTION = "exd";
    private static final String EXCEPTION_FATAL = "exf";
    private static final String CD_OS_NAME = "cd1";
    private static final String CD_OS_VERSION = "cd2";
    private static final String CD_JAVA_RUNTIME_VERSION = "cd3";
    private static final String CD_UPDATE_CHANNEL = "cd4";
    private static final String CD_LOCALE = "cd5";
    private static final String CM_ACTIVITY_COUNT = "cm1";
    private static final List<BasicNameValuePair> analyticsBaseData = ImmutableList.of((Object)new BasicNameValuePair("v", "1"), (Object)new BasicNameValuePair("tid", ANALYTICS_ID), (Object)new BasicNameValuePair("an", "Android Studio"), (Object)new BasicNameValuePair("av", UNIT_TEST_MODE ? "unit-test" : ApplicationInfo.getInstance().getStrictVersion()), (Object)new BasicNameValuePair("cid", INSTALLATION_ID), (Object)new BasicNameValuePair("cd1", SystemInfo.OS_NAME), (Object)new BasicNameValuePair("cd2", SystemInfo.OS_VERSION), (Object)new BasicNameValuePair("cd3", SystemInfo.JAVA_RUNTIME_VERSION), (Object)new BasicNameValuePair("cd5", AnalyticsUploader.getLanguage()));
    public static final String CATEGORY_STUDIO_EXCEPTION = "excstudio";
    private static final LastSeenExceptions ourLastSeenExceptions = new LastSeenExceptions(3);
    private static AtomicInteger ourRejectedExecutionCount = new AtomicInteger();
    private static final ExecutorService ourExecutor = new ThreadPoolExecutor(1, 5, 1L, TimeUnit.MINUTES, new LinkedBlockingDeque<Runnable>(5), new ThreadFactoryBuilder().setDaemon(true).setNameFormat("google-logs-pool-%d").build(), (r, executor) -> {
        ourRejectedExecutionCount.incrementAndGet();
        if (ourRejectedExecutionCount.compareAndSet(20, 0)) {
            Logger.getInstance(AnalyticsUploader.class).info("Lost 20 analytics events due to full queue.");
        }
    });

    public static String getLanguage() {
        Locale locale = Locale.getDefault();
        return locale == null ? "unknown" : locale.toString();
    }

    public static boolean trackingEnabled() {
        return DEBUG || StatisticsUploadAssistant.isSendAllowed();
    }

    public static void trackEvent(@NotNull String eventCategory, @NotNull String eventAction, @Nullable String eventLabel, @Nullable Integer eventValue) {
        ArrayList postData = Lists.newArrayList(analyticsBaseData);
        postData.add(new BasicNameValuePair(HIT_TYPE, HIT_TYPE_EVENT));
        postData.add(new BasicNameValuePair(EVENT_CATEGORY, eventCategory));
        postData.add(new BasicNameValuePair(EVENT_ACTION, eventAction));
        if (!StringUtil.isEmpty((String)eventLabel)) {
            postData.add(new BasicNameValuePair(EVENT_LABEL, eventLabel));
        }
        if (eventValue != null) {
            if (eventValue < 0 && DEBUG) {
                System.err.println("Attempting to send negative event value to the analytics server");
            } else {
                postData.add(new BasicNameValuePair(EVENT_VALUE, eventValue.toString()));
            }
        }
        AnalyticsUploader.postToAnalytics(postData);
    }

    public static void trackCrashes(@NotNull Iterable<String> descriptions) {
        long crashCount = 0L;
        for (String description : descriptions) {
            AnalyticsUploader.trackCrash(description);
            ++crashCount;
        }
        AnalyticsUploader.trackExceptionsAndActivity(0L, 0L, 0L, 0L, crashCount);
    }

    private static void trackCrash(@NotNull String description) {
        block3: {
            if (!AnalyticsUploader.trackingEnabled()) {
                return;
            }
            try {
                AnalyticsUploader.postToAnalytics((List<BasicNameValuePair>)ImmutableList.of((Object)new BasicNameValuePair(HIT_TYPE, HIT_TYPE_EXCEPTION), (Object)new BasicNameValuePair(EXCEPTION_DESCRIPTION, "StudioCrash: " + description), (Object)new BasicNameValuePair(EXCEPTION_FATAL, "1")));
            }
            catch (Throwable throwable) {
                if (!DEBUG) break block3;
                System.err.println("Unexpected error while reporting a crash: " + throwable);
            }
        }
    }

    public static void trackException(@NotNull Throwable t, boolean fatal) {
        block9: {
            if (!AnalyticsUploader.trackingEnabled()) {
                return;
            }
            try {
                String cls;
                t = AnalyticsUploader.getRootCause(t);
                if (t instanceof Logger.EmptyThrowable) {
                    return;
                }
                if (t instanceof ClassNotFoundException && (cls = t.getMessage()) != null && cls.startsWith("com.sun.jdi.")) {
                    return;
                }
                SystemHealthMonitor.incrementAndSaveExceptionCount();
                PluginId pluginId = IdeErrorsDialog.findPluginId(t);
                if (pluginId != null) {
                    if (PluginManager.getPlugin(pluginId).isBundled()) {
                        SystemHealthMonitor.incrementAndSaveBundledPluginsExceptionCount();
                    } else {
                        SystemHealthMonitor.incrementAndSaveNonBundledPluginsExceptionCount();
                    }
                }
                String description = AnalyticsUploader.getDescription(t);
                AnalyticsUploader.postToAnalytics((List<BasicNameValuePair>)ImmutableList.of((Object)new BasicNameValuePair(HIT_TYPE, HIT_TYPE_EXCEPTION), (Object)new BasicNameValuePair(EXCEPTION_DESCRIPTION, description), (Object)new BasicNameValuePair(EXCEPTION_FATAL, fatal ? "1" : "0")));
                if (THROWABLE_CLASSES_TO_TRACK_MESSAGES.contains(t.getClass())) {
                    AnalyticsUploader.trackEvent("Throwable.detailMessage", t.getClass().getSimpleName(), t.getMessage(), null);
                }
                ourLastSeenExceptions.add(description);
            }
            catch (Throwable throwable) {
                if (!DEBUG) break block9;
                System.err.println("Unexpected error while reporting a crash: " + throwable);
            }
        }
    }

    @NotNull
    public static String getLastExceptionDescription() {
        return ourLastSeenExceptions.getDescriptions();
    }

    public static void trackExceptionsAndActivity(long activityCount, long exceptionCount, long bundledPluginExceptionCount, long nonBundledPluginExceptionCount, long fatalExceptionCount) {
        block4: {
            if (!AnalyticsUploader.trackingEnabled()) {
                return;
            }
            try {
                AnalyticsUploader.postToAnalytics((List<BasicNameValuePair>)ImmutableList.of((Object)new BasicNameValuePair(HIT_TYPE, HIT_TYPE_EVENT), (Object)new BasicNameValuePair(EVENT_CATEGORY, "ActivityTracker"), (Object)new BasicNameValuePair(EVENT_ACTION, "Hit"), (Object)new BasicNameValuePair(EVENT_VALUE, Long.toString(activityCount)), (Object)new BasicNameValuePair(CM_ACTIVITY_COUNT, Long.toString(activityCount))));
            }
            catch (Throwable throwable) {
                if (!DEBUG) break block4;
                System.err.println("Unexpected error while reporting a activity: " + throwable);
            }
        }
        if (!ApplicationManager.getApplication().isInternal()) {
            AnalyticsUploader.postToGoogleLogs(CATEGORY_STUDIO_EXCEPTION, (Map<String, String>)ImmutableMap.of((Object)"activity", (Object)Long.toString(activityCount), (Object)"exc", (Object)Long.toString(exceptionCount), (Object)"exb", (Object)Long.toString(bundledPluginExceptionCount), (Object)"exp", (Object)Long.toString(nonBundledPluginExceptionCount), (Object)EXCEPTION_FATAL, (Object)Long.toString(fatalExceptionCount)));
        }
    }

    public static void postToGoogleLogs(@NotNull String categoryId, @NotNull Map<String, String> parameters) {
        try {
            ourExecutor.submit(() -> {
                block2: {
                    try {
                        URL url = AnalyticsUploader.getPingUrl(categoryId, ApplicationInfo.getInstance().getStrictVersion(), INSTALLATION_ID, parameters);
                        AnalyticsUploader.postToGoogleLogs(url);
                    }
                    catch (Throwable t) {
                        if (!DEBUG) break block2;
                        System.err.println("Unexpected error while uploading exception metrics: " + t);
                    }
                }
            });
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void postToGoogleLogs(@NotNull URL url) throws IOException {
        int responseCode;
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        try {
            responseCode = conn.getResponseCode();
        }
        catch (UnknownHostException e) {
            if (DEBUG) {
                System.err.println("Unexpected exception while sending exception counts: " + e);
            }
            return;
        }
        finally {
            conn.disconnect();
        }
        if (DEBUG && responseCode != 404) {
            System.err.println("Ping did not return a 404");
        }
    }

    private static void postToAnalytics(@NotNull List<BasicNameValuePair> parameters) {
        String channel = UNIT_TEST_MODE ? "unit-test" : ChannelStatus.fromCode(UpdateSettings.getInstance().getUpdateChannelType()).getDisplayName();
        List<BasicNameValuePair> runtimeData = Collections.singletonList(new BasicNameValuePair(CD_UPDATE_CHANNEL, channel));
        try {
            ourExecutor.submit(() -> {
                CloseableHttpClient client = HttpClientBuilder.create().build();
                HttpPost request = new HttpPost(ANALYTICS_URL);
                try {
                    request.setEntity((HttpEntity)new UrlEncodedFormEntity(Iterables.concat(analyticsBaseData, (Iterable)runtimeData, (Iterable)parameters)));
                    CloseableHttpResponse response = client.execute((HttpUriRequest)request);
                    StatusLine status = response.getStatusLine();
                    HttpEntity entity = response.getEntity();
                    if (status.getStatusCode() >= 300 && DEBUG) {
                        System.err.println("Error reporting to Analytics, return code: " + status.getStatusCode());
                    }
                }
                catch (IOException e) {
                    if (DEBUG) {
                        System.err.println("Error reporting to Analytics: " + e.getMessage());
                    }
                }
                finally {
                    HttpClientUtils.closeQuietly((HttpClient)client);
                }
            });
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
    }

    @VisibleForTesting
    @NotNull
    public static String getDescription(@NotNull Throwable t) {
        int i;
        StringBuilder sb = new StringBuilder(150);
        String simpleName = t.getClass().getSimpleName().replace("Exception", "Ex").replace("Error", "Er");
        sb.append(simpleName);
        StackTraceElement[] stackTraceElements = t.getStackTrace();
        if (stackTraceElements.length > 0) {
            sb.append(" @ ");
        }
        boolean androidPlugin = false;
        String lastFileName = "";
        for (i = 0; i < stackTraceElements.length && sb.length() < 150; ++i) {
            StackTraceElement el = stackTraceElements[i];
            String className = el.getClassName();
            if (className != null && (className.startsWith("java.") || className.startsWith("javax."))) {
                sb.append('.');
                continue;
            }
            if (i != 0) {
                sb.append(" < ");
            }
            String fileName = AnalyticsUploader.getBaseName(el.getFileName());
            if (className != null && className.contains(".klint.")) {
                fileName = "Kt:" + fileName;
            }
            if (!StringUtil.equals((CharSequence)fileName, (CharSequence)lastFileName)) {
                sb.append(fileName);
                lastFileName = fileName;
            }
            sb.append(':');
            sb.append(el.getLineNumber());
            if (androidPlugin) continue;
            androidPlugin = AnalyticsUploader.fromAndroidPlugin(el);
        }
        String desc = sb.toString();
        if (!androidPlugin && i < stackTraceElements.length) {
            while (i < stackTraceElements.length) {
                StackTraceElement el = stackTraceElements[i];
                if (AnalyticsUploader.fromAndroidPlugin(el)) {
                    String android = "... < " + AnalyticsUploader.getBaseName(el.getFileName()) + ":" + el.getLineNumber();
                    if (desc.length() + android.length() > 150) {
                        desc = desc.substring(0, 150 - android.length());
                    }
                    desc = desc + android;
                    break;
                }
                ++i;
            }
        }
        if (desc.length() > 150) {
            desc = desc.substring(0, 149) + ">";
        }
        while (desc.getBytes(Charsets.UTF_8).length > 150) {
            desc = desc.substring(0, desc.length() - 1);
        }
        return desc;
    }

    private static boolean fromAndroidPlugin(StackTraceElement el) {
        return el.getClassName().contains("android");
    }

    private static Throwable getRootCause(Throwable e) {
        int depth = 0;
        while (depth++ < 20) {
            if (e.getCause() == null) {
                return e;
            }
            e = e.getCause();
        }
        return e;
    }

    private static String getBaseName(@Nullable String fileName) {
        if (Strings.isNullOrEmpty((String)fileName)) {
            return "U";
        }
        int extension = fileName.indexOf(46);
        if (extension > 0) {
            return fileName.substring(0, extension);
        }
        return fileName;
    }

    @VisibleForTesting
    @NotNull
    public static URL getPingUrl(@NotNull String categoryId, @NotNull String version, @NotNull String installationId, @NotNull Map<String, String> parameters) throws MalformedURLException, UnsupportedEncodingException {
        String urlPrefix = String.format(Locale.US, "https://tools.google.com/service/update?as=androidsdk_%1$s&version=%2$s&uid=%3$s", categoryId, URLEncoder.encode(version, Charsets.UTF_8.name()), URLEncoder.encode(installationId, Charsets.UTF_8.name()));
        StringBuilder sb = new StringBuilder(urlPrefix);
        for (String key : parameters.keySet()) {
            String value = parameters.get(key);
            sb.append('&');
            sb.append(URLEncoder.encode(key, Charsets.UTF_8.name()));
            sb.append('=');
            sb.append(URLEncoder.encode(value, Charsets.UTF_8.name()));
        }
        return new URL(sb.toString());
    }
}

