/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic;

import com.intellij.internal.statistic.AbstractApplicationUsagesCollector;
import com.intellij.internal.statistic.CollectUsagesException;
import com.intellij.internal.statistic.beans.GroupDescriptor;
import com.intellij.internal.statistic.beans.UsageDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public abstract class UsagesCollector {
    private static final Logger LOG = Logger.getInstance(UsagesCollector.class);
    private static final Object LOCK = new Object();
    public static final ExtensionPointName<UsagesCollector> EP_NAME = ExtensionPointName.create((String)"com.intellij.statistics.usagesCollector");

    @NotNull
    public abstract Set<UsageDescriptor> getUsages() throws CollectUsagesException;

    @NotNull
    public abstract GroupDescriptor getGroupId();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doPersistProjectUsages(@NotNull Project project2) {
        Object object = LOCK;
        synchronized (object) {
            if (!project2.isInitialized() || DumbService.isDumb((Project)project2)) {
                return;
            }
            for (UsagesCollector usagesCollector : (UsagesCollector[])EP_NAME.getExtensions()) {
                if (!(usagesCollector instanceof AbstractApplicationUsagesCollector)) continue;
                ((AbstractApplicationUsagesCollector)usagesCollector).persistProjectUsages(project2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static Map<GroupDescriptor, Set<UsageDescriptor>> getAllUsages(@NotNull Set<String> disabledGroups) {
        Object object = LOCK;
        synchronized (object) {
            LinkedHashMap<GroupDescriptor, Set<UsageDescriptor>> usageDescriptors = new LinkedHashMap<GroupDescriptor, Set<UsageDescriptor>>();
            for (UsagesCollector usagesCollector : (UsagesCollector[])EP_NAME.getExtensions()) {
                GroupDescriptor groupDescriptor = usagesCollector.getGroupId();
                if (disabledGroups.contains(groupDescriptor.getId())) continue;
                try {
                    usageDescriptors.put(groupDescriptor, usagesCollector.getUsages());
                }
                catch (CollectUsagesException e) {
                    LOG.info((Throwable)e);
                }
            }
            return usageDescriptors;
        }
    }
}

