/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic;

import com.intellij.internal.statistic.UsagesCollector;
import com.intellij.internal.statistic.beans.ConvertUsagesUtil;
import com.intellij.internal.statistic.beans.GroupDescriptor;
import com.intellij.internal.statistic.beans.UsageDescriptor;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.Storage;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.annotations.MapAnnotation;
import com.intellij.util.xmlb.annotations.Tag;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

@com.intellij.openapi.components.State(name="UsageTrigger", storages={@Storage(value="statistics.application.usages.xml", roamingType=RoamingType.DISABLED)})
public class UsageTrigger
implements PersistentStateComponent<State> {
    private State myState = new State();

    public static void trigger(@NotNull String feature) {
        UsageTrigger.getInstance().doTrigger(feature);
    }

    public static void triggerOnce(@NotNull String feature) {
        if (!UsageTrigger.getInstance().myState.myValues.containsKey(feature)) {
            UsageTrigger.getInstance().doTrigger(feature);
        }
    }

    private static UsageTrigger getInstance() {
        return (UsageTrigger)ServiceManager.getService(UsageTrigger.class);
    }

    private void doTrigger(String feature) {
        ConvertUsagesUtil.assertDescriptorName(feature);
        Integer count = this.myState.myValues.get(feature);
        if (count == null) {
            this.myState.myValues.put(feature, 1);
        } else {
            this.myState.myValues.put(feature, count + 1);
        }
    }

    public State getState() {
        return this.myState;
    }

    public void loadState(State state) {
        this.myState = state;
    }

    static final class MyCollector
    extends UsagesCollector {
        private static final GroupDescriptor GROUP = GroupDescriptor.create("features counts", 100.0);

        MyCollector() {
        }

        @Override
        @NotNull
        public Set<UsageDescriptor> getUsages() {
            State state = UsageTrigger.getInstance().getState();
            assert (state != null);
            return ContainerUtil.map2Set(state.myValues.entrySet(), (Function)new Function<Map.Entry<String, Integer>, UsageDescriptor>(){

                public UsageDescriptor fun(Map.Entry<String, Integer> e) {
                    return new UsageDescriptor(e.getKey(), e.getValue());
                }
            });
        }

        @Override
        @NotNull
        public GroupDescriptor getGroupId() {
            return GROUP;
        }
    }

    static final class State {
        @Tag(value="counts")
        @MapAnnotation(surroundWithTag=false, keyAttributeName="feature", valueAttributeName="count")
        public Map<String, Integer> myValues = new HashMap<String, Integer>();

        State() {
        }
    }
}

