/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic;

import com.intellij.internal.statistic.CollectUsagesException;
import com.intellij.internal.statistic.UsagesCollector;
import com.intellij.internal.statistic.beans.GroupDescriptor;
import com.intellij.internal.statistic.beans.UsageDescriptor;
import com.intellij.openapi.util.SystemInfo;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

class OsVersionUsageCollector
extends UsagesCollector {
    OsVersionUsageCollector() {
    }

    @Override
    @NotNull
    public Set<UsageDescriptor> getUsages() throws CollectUsagesException {
        UsageDescriptor descriptor = null;
        if (SystemInfo.isUnix && !SystemInfo.isMac) {
            String releaseName = SystemInfo.getUnixReleaseName();
            String releaseVersion = SystemInfo.getUnixReleaseVersion();
            if (releaseName != null && releaseVersion != null) {
                descriptor = new UsageDescriptor(SystemInfo.OS_NAME + " " + releaseName + " " + releaseVersion, 1);
            }
        }
        if (descriptor == null) {
            descriptor = new UsageDescriptor(SystemInfo.OS_NAME + " " + SystemInfo.OS_VERSION, 1);
        }
        return Collections.singleton(descriptor);
    }

    @Override
    @NotNull
    public GroupDescriptor getGroupId() {
        return GroupDescriptor.create("user.os.version");
    }
}

