/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic;

import com.intellij.internal.statistic.CollectUsagesException;
import com.intellij.internal.statistic.UsagesCollector;
import com.intellij.internal.statistic.beans.GroupDescriptor;
import com.intellij.internal.statistic.beans.UsageDescriptor;
import com.intellij.openapi.util.SystemInfo;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

class OsNameUsageCollector
extends UsagesCollector {
    OsNameUsageCollector() {
    }

    @Override
    @NotNull
    public Set<UsageDescriptor> getUsages() throws CollectUsagesException {
        String osName = SystemInfo.isLinux ? "Linux" : (SystemInfo.isMac ? "Mac OS X" : (SystemInfo.isWindows ? "Windows" : SystemInfo.OS_NAME));
        return Collections.singleton(new UsageDescriptor(osName, 1));
    }

    @Override
    @NotNull
    public GroupDescriptor getGroupId() {
        return GroupDescriptor.create("user.os.name");
    }
}

