/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.focus;

import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.wm.impl.FocusRequestInfo;
import com.intellij.ui.JBColor;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.table.JBTable;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;

public class FocusTracesDialog
extends DialogWrapper {
    private final JBTable myRequestsTable;
    private final List<FocusRequestInfo> myRequests;
    private static final String[] COLUMNS = new String[]{"Time", "Forced", "Component"};
    private final ConsoleView consoleView;

    public FocusTracesDialog(Project project2, ArrayList<FocusRequestInfo> requests) {
        super(project2);
        this.myRequests = requests;
        this.setTitle("Focus Traces");
        Object[][] data = new String[requests.size()][];
        for (int i = 0; i < data.length; ++i) {
            FocusRequestInfo r = requests.get(i);
            data[i] = new String[]{r.getDate(), String.valueOf(r.isForced()), String.valueOf(r.getComponent())};
        }
        this.setModal(false);
        this.myRequestsTable = new JBTable((TableModel)new DefaultTableModel(data, COLUMNS){

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        });
        ListSelectionListener selectionListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (FocusTracesDialog.this.consoleView == null) {
                    return;
                }
                int index = FocusTracesDialog.this.myRequestsTable.getSelectedRow();
                FocusTracesDialog.this.consoleView.clear();
                if (-1 < index && index < FocusTracesDialog.this.myRequests.size()) {
                    FocusTracesDialog.this.consoleView.print(((FocusRequestInfo)FocusTracesDialog.this.myRequests.get(index)).getStackTrace(), ConsoleViewContentType.NORMAL_OUTPUT);
                }
            }
        };
        this.myRequestsTable.getSelectionModel().addListSelectionListener(selectionListener);
        TableColumnModel columnModel = this.myRequestsTable.getColumnModel();
        columnModel.getColumn(0).setMinWidth(120);
        columnModel.getColumn(0).setMaxWidth(120);
        columnModel.getColumn(0).setPreferredWidth(120);
        columnModel.getColumn(1).setMinWidth(60);
        columnModel.getColumn(1).setMaxWidth(60);
        columnModel.getColumn(1).setPreferredWidth(60);
        this.myRequestsTable.getSelectionModel().setSelectionMode(0);
        this.myRequestsTable.changeSelection(0, 0, false, true);
        this.consoleView = TextConsoleBuilderFactory.getInstance().createBuilder(ProjectManager.getInstance().getDefaultProject()).getConsole();
        this.init();
    }

    protected String getDimensionServiceKey() {
        return "ide.internal.focus.trace.dialog";
    }

    protected JComponent createCenterPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        JBSplitter splitter = new JBSplitter(true, 0.5f, 0.2f, 0.8f);
        splitter.setFirstComponent((JComponent)new JBScrollPane((Component)this.myRequestsTable, 20, 31));
        JPanel consoleComponent = new JPanel(new BorderLayout());
        consoleComponent.add((Component)this.consoleView.getComponent(), "Center");
        this.consoleView.print(this.myRequests.get(this.myRequestsTable.getSelectedRow()).getStackTrace(), ConsoleViewContentType.NORMAL_OUTPUT);
        splitter.setSecondComponent((JComponent)new JBScrollPane((Component)consoleComponent, 20, 31));
        panel.add((Component)splitter, "Center");
        return panel;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myRequestsTable;
    }

    @NotNull
    protected Action[] createActions() {
        return new Action[]{this.getOKAction(), this.getCopyStackTraceAction()};
    }

    private Action getCopyStackTraceAction() {
        return new AbstractAction("&Copy stacktrace"){

            @Override
            public void actionPerformed(ActionEvent e) {
                CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(((FocusRequestInfo)FocusTracesDialog.this.myRequests.get(FocusTracesDialog.this.myRequestsTable.getSelectedRow())).getStackTrace()));
            }
        };
    }

    public void show() {
        BorderDrawer drawer = new BorderDrawer();
        drawer.start();
        super.show();
        drawer.setDone();
    }

    class BorderDrawer
    extends Thread {
        Component prev;
        private volatile boolean running;

        BorderDrawer() {
            super("Focus Border Drawer");
            this.prev = null;
            this.running = true;
        }

        @Override
        public void run() {
            try {
                while (this.running) {
                    BorderDrawer.sleep(100L);
                    this.paintBorder();
                }
                if (this.prev != null) {
                    this.prev.repaint();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        private void paintBorder() {
            int row = FocusTracesDialog.this.myRequestsTable.getSelectedRow();
            if (row != -1) {
                FocusRequestInfo info = (FocusRequestInfo)FocusTracesDialog.this.myRequests.get(row);
                if (this.prev != null && this.prev != info.getComponent()) {
                    this.prev.repaint();
                }
                this.prev = info.getComponent();
                if (this.prev != null && this.prev.isDisplayable()) {
                    Graphics g = this.prev.getGraphics();
                    g.setColor((Color)JBColor.RED);
                    Dimension sz = this.prev.getSize();
                    UIUtil.drawDottedRectangle((Graphics)g, (int)1, (int)1, (int)(sz.width - 2), (int)(sz.height - 2));
                }
            }
        }

        public void setDone() {
            this.running = false;
        }
    }
}

