/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal;

import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScreenUtil;
import java.awt.BufferCapabilities;
import java.awt.Color;
import java.awt.DisplayMode;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.ImageCapabilities;
import java.awt.Rectangle;
import java.util.ArrayList;
import javax.swing.Action;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class DumpScreenConfigurationAction
extends DumbAwareAction {
    private static final Logger LOG = Logger.getInstance(DumpScreenConfigurationAction.class);

    public void actionPerformed(AnActionEvent event) {
        new ScreenDialog(event).show();
    }

    private static Rectangle minimize(Rectangle bounds) {
        return new Rectangle(bounds.x / 10, bounds.y / 10, bounds.width / 10, bounds.height / 10);
    }

    private static void append(StringBuilder sb, GraphicsDevice device) {
        DumpScreenConfigurationAction.append(sb, "id", device.getIDstring());
        DumpScreenConfigurationAction.append(sb, "type", DumpScreenConfigurationAction.getTypeName(device.getType()));
        DumpScreenConfigurationAction.append(sb, device.getDisplayMode());
        GraphicsConfiguration configuration = device.getDefaultConfiguration();
        DumpScreenConfigurationAction.append(sb, "outer", configuration.getBounds());
        DumpScreenConfigurationAction.append(sb, "inner", ScreenUtil.getScreenRectangle((GraphicsConfiguration)configuration));
        DumpScreenConfigurationAction.append(sb, "default image", configuration.getImageCapabilities());
        BufferCapabilities capabilities = configuration.getBufferCapabilities();
        DumpScreenConfigurationAction.append(sb, "front buffer image", capabilities.getFrontBufferCapabilities());
        DumpScreenConfigurationAction.append(sb, "back buffer image", capabilities.getBackBufferCapabilities());
        sb.append("page flipping: ").append(capabilities.getFlipContents());
        if (capabilities.isFullScreenRequired()) {
            sb.append("; full-screen exclusive mode is required");
        }
        if (capabilities.isMultiBufferAvailable()) {
            sb.append("; more than two buffers can be used");
        }
        sb.append("\n");
    }

    private static void append(StringBuilder sb, String name, String text) {
        sb.append(name).append(": ").append(text).append("\n");
    }

    private static void append(StringBuilder sb, String name, Rectangle bounds) {
        sb.append(name);
        sb.append(": x=").append(bounds.x);
        sb.append(", y=").append(bounds.y);
        sb.append(", width=").append(bounds.width);
        sb.append(", height=").append(bounds.height);
        sb.append("\n");
    }

    private static void append(StringBuilder sb, DisplayMode mode) {
        sb.append("mode: ").append(mode.getWidth()).append("x").append(mode.getHeight());
        sb.append("; bit depth=").append(mode.getBitDepth());
        sb.append("; refresh rate=").append(mode.getRefreshRate());
        sb.append("\n");
    }

    private static void append(StringBuilder sb, String name, ImageCapabilities capabilities) {
        if (capabilities != null) {
            sb.append(name).append(": accelerated=").append(capabilities.isAccelerated());
            if (capabilities.isTrueVolatile()) {
                sb.append("; true volatile");
            }
            sb.append("\n");
        }
    }

    private static String getTypeName(int type) {
        if (type == 0) {
            return "raster screen";
        }
        if (type == 1) {
            return "printer";
        }
        if (type == 2) {
            return "image buffer";
        }
        return "unknown: " + type;
    }

    private static final class ScreenView
    extends JComponent {
        private final ArrayList<ScreenInfo> myScreenList = new ArrayList();
        private final Rectangle myBounds = new Rectangle();

        private ScreenView() {
        }

        private boolean update() {
            boolean updated = false;
            GraphicsDevice[] devices = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
            while (devices.length > this.myScreenList.size()) {
                this.myScreenList.add(new ScreenInfo());
                updated = true;
            }
            while (devices.length < this.myScreenList.size()) {
                this.myScreenList.remove(devices.length);
                updated = true;
            }
            for (int i = 0; i < devices.length; ++i) {
                if (!this.myScreenList.get(i).update(devices[i].getDefaultConfiguration())) continue;
                updated = true;
            }
            if (updated) {
                int minX = 0;
                int maxX = 0;
                int minY = 0;
                int maxY = 0;
                for (ScreenInfo info : this.myScreenList) {
                    int y;
                    int x = ((ScreenInfo)info).myOuterBounds.x;
                    if (minX > x) {
                        minX = x;
                    }
                    if (maxX < (x += ((ScreenInfo)info).myOuterBounds.width)) {
                        maxX = x;
                    }
                    if (minY > (y = ((ScreenInfo)info).myOuterBounds.y)) {
                        minY = y;
                    }
                    if (maxY >= (y += ((ScreenInfo)info).myOuterBounds.height)) continue;
                    maxY = y;
                }
                this.myBounds.setBounds(minX, minY, maxX - minX, maxY - minY);
            }
            return updated;
        }

        @Override
        protected void paintComponent(Graphics g) {
            if (this.update()) {
                this.setPreferredSize(this.myBounds.getSize());
                this.setMinimumSize(this.myBounds.getSize());
                this.revalidate();
                this.repaint();
            }
            if ((g = g.create()) instanceof Graphics2D) {
                UISettings.setupAntialiasing((Graphics)g);
            }
            for (int i = 0; i < this.myScreenList.size(); ++i) {
                ScreenInfo info = this.myScreenList.get(i);
                Rectangle bounds = info.myOuterBounds;
                int x = bounds.x - this.myBounds.x + this.getX();
                int y = bounds.y - this.myBounds.y + this.getY();
                g.setColor((Color)JBColor.BLUE);
                g.fillRect(x, y, bounds.width, bounds.height);
                bounds = info.myInnerBounds;
                x = bounds.x - this.myBounds.x + this.getX();
                y = bounds.y - this.myBounds.y + this.getY();
                g.setColor((Color)JBColor.BLACK);
                g.fillRect(x, y, bounds.width, bounds.height);
                String id = String.valueOf(i + 1);
                int size = Math.min(bounds.width << 1, bounds.height);
                g.setColor((Color)JBColor.WHITE);
                g.setFont(new Font("Monospaced", 1, size));
                FontMetrics fm = g.getFontMetrics();
                g.drawString(id, x += (bounds.width - fm.stringWidth(id)) / 2, (y += (bounds.height - fm.getHeight()) / 2) + size);
            }
            g.dispose();
        }
    }

    private static final class ScreenInfo {
        private final Rectangle myOuterBounds = new Rectangle();
        private final Rectangle myInnerBounds = new Rectangle();

        private ScreenInfo() {
        }

        private boolean update(GraphicsConfiguration configuration) {
            Rectangle inner;
            boolean updated = false;
            Rectangle outer = DumpScreenConfigurationAction.minimize(configuration.getBounds());
            if (!this.myOuterBounds.equals(outer)) {
                this.myOuterBounds.setBounds(outer);
                updated = true;
            }
            if (!this.myInnerBounds.equals(inner = DumpScreenConfigurationAction.minimize(ScreenUtil.getScreenRectangle((GraphicsConfiguration)configuration)))) {
                this.myInnerBounds.setBounds(inner);
                updated = true;
            }
            return updated;
        }
    }

    private static final class ScreenDialog
    extends DialogWrapper {
        private ScreenDialog(AnActionEvent event) {
            super(event.getProject());
            this.init();
            this.setOKButtonText("Dump");
            this.setTitle("Screen Configuration");
        }

        protected JComponent createCenterPanel() {
            return new ScreenView();
        }

        @NotNull
        protected Action[] createActions() {
            return new Action[]{this.getOKAction(), this.getCancelAction()};
        }

        protected void doOKAction() {
            StringBuilder sb = new StringBuilder();
            GraphicsDevice[] devices = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
            DumpScreenConfigurationAction.append(sb, "number of devices", Integer.toString(devices.length));
            for (GraphicsDevice device : devices) {
                DumpScreenConfigurationAction.append(sb.append("\n"), device);
            }
            LOG.warn(sb.toString());
            super.doOKAction();
        }
    }
}

