/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.injected.editor;

import com.intellij.injected.editor.DocumentWindow;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.injected.editor.FoldingRegionWindow;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.FoldingGroup;
import com.intellij.openapi.editor.ex.FoldingListener;
import com.intellij.openapi.editor.ex.FoldingModelEx;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class FoldingModelWindow
implements FoldingModelEx {
    private final FoldingModelEx myDelegate;
    private final DocumentWindow myDocumentWindow;
    private final EditorWindow myEditorWindow;
    private static final Key<FoldingRegionWindow> FOLD_REGION_WINDOW = Key.create((String)"FOLD_REGION_WINDOW");

    FoldingModelWindow(@NotNull FoldingModelEx delegate, @NotNull DocumentWindow documentWindow, @NotNull EditorWindow editorWindow) {
        this.myDelegate = delegate;
        this.myDocumentWindow = documentWindow;
        this.myEditorWindow = editorWindow;
    }

    @Override
    public void setFoldingEnabled(boolean isEnabled) {
        this.myDelegate.setFoldingEnabled(isEnabled);
    }

    @Override
    public boolean isFoldingEnabled() {
        return this.myDelegate.isFoldingEnabled();
    }

    @Override
    public FoldRegion getFoldingPlaceholderAt(Point p) {
        return this.myDelegate.getFoldingPlaceholderAt(p);
    }

    @Override
    public boolean intersectsRegion(int startOffset, int endOffset) {
        int hostStart = this.myDocumentWindow.injectedToHost(startOffset);
        int hostEnd = this.myDocumentWindow.injectedToHost(endOffset);
        return this.myDelegate.intersectsRegion(hostStart, hostEnd);
    }

    public FoldRegion addFoldRegion(int startOffset, int endOffset, @NotNull String placeholderText) {
        FoldRegion region = this.createFoldRegion(startOffset, endOffset, placeholderText, null, false);
        if (region == null) {
            return null;
        }
        if (!this.addFoldRegion(region)) {
            region.dispose();
            return null;
        }
        return region;
    }

    public boolean addFoldRegion(@NotNull FoldRegion region) {
        return this.myDelegate.addFoldRegion((FoldRegion)((FoldingRegionWindow)region).getDelegate());
    }

    public void removeFoldRegion(@NotNull FoldRegion region) {
        this.myDelegate.removeFoldRegion((FoldRegion)((FoldingRegionWindow)region).getDelegate());
    }

    @NotNull
    public FoldRegion[] getAllFoldRegions() {
        FoldRegion[] all = this.myDelegate.getAllFoldRegions();
        ArrayList<FoldingRegionWindow> result = new ArrayList<FoldingRegionWindow>();
        for (FoldRegion region : all) {
            FoldingRegionWindow window = this.getWindowRegion(region);
            if (window == null) continue;
            result.add(window);
        }
        return result.toArray(new FoldRegion[result.size()]);
    }

    public boolean isOffsetCollapsed(int offset) {
        return this.myDelegate.isOffsetCollapsed(this.myDocumentWindow.injectedToHost(offset));
    }

    public FoldRegion getCollapsedRegionAtOffset(int offset) {
        FoldRegion host = this.myDelegate.getCollapsedRegionAtOffset(this.myDocumentWindow.injectedToHost(offset));
        return host;
    }

    @Nullable
    public FoldRegion getFoldRegion(int startOffset, int endOffset) {
        TextRange range = new TextRange(startOffset, endOffset);
        TextRange hostRange = this.myDocumentWindow.injectedToHost(range);
        FoldRegion hostRegion = this.myDelegate.getFoldRegion(hostRange.getStartOffset(), hostRange.getEndOffset());
        return hostRegion == null ? null : this.getWindowRegion(hostRegion);
    }

    @Nullable
    private FoldingRegionWindow getWindowRegion(@NotNull FoldRegion hostRegion) {
        FoldingRegionWindow window = (FoldingRegionWindow)hostRegion.getUserData(FOLD_REGION_WINDOW);
        return window != null && window.getEditor() == this.myEditorWindow ? window : null;
    }

    public void runBatchFoldingOperation(@NotNull Runnable operation) {
        this.myDelegate.runBatchFoldingOperation(operation);
    }

    public void runBatchFoldingOperation(@NotNull Runnable operation, boolean moveCaretFromCollapsedRegion) {
        this.myDelegate.runBatchFoldingOperation(operation, moveCaretFromCollapsedRegion);
    }

    public void runBatchFoldingOperationDoNotCollapseCaret(@NotNull Runnable operation) {
        this.myDelegate.runBatchFoldingOperationDoNotCollapseCaret(operation);
    }

    @Override
    public FoldRegion fetchOutermost(int offset) {
        FoldRegion host = this.myDelegate.fetchOutermost(this.myDocumentWindow.injectedToHost(offset));
        return host;
    }

    @Override
    public int getLastCollapsedRegionBefore(int offset) {
        return -1;
    }

    @Override
    public TextAttributes getPlaceholderAttributes() {
        return this.myDelegate.getPlaceholderAttributes();
    }

    @Override
    public FoldRegion[] fetchTopLevel() {
        return FoldRegion.EMPTY_ARRAY;
    }

    @Override
    public FoldRegion createFoldRegion(int startOffset, int endOffset, @NotNull String placeholder, FoldingGroup group, boolean neverExpands) {
        TextRange hostRange = this.myDocumentWindow.injectedToHost(new TextRange(startOffset, endOffset));
        if (hostRange.getLength() < 2) {
            return null;
        }
        FoldRegion hostRegion = this.myDelegate.createFoldRegion(hostRange.getStartOffset(), hostRange.getEndOffset(), placeholder, group, neverExpands);
        int startShift = Math.max(0, this.myDocumentWindow.hostToInjected(hostRange.getStartOffset()) - startOffset);
        int endShift = Math.max(0, endOffset - this.myDocumentWindow.hostToInjected(hostRange.getEndOffset()) - startShift);
        FoldingRegionWindow window = new FoldingRegionWindow(this.myDocumentWindow, this.myEditorWindow, hostRegion, startShift, endShift);
        hostRegion.putUserData(FOLD_REGION_WINDOW, (Object)window);
        return window;
    }

    @Override
    public void addListener(@NotNull FoldingListener listener2, @NotNull Disposable parentDisposable) {
        this.myDelegate.addListener(listener2, parentDisposable);
    }

    @Override
    public void rebuild() {
        this.myDelegate.rebuild();
    }

    @Override
    @NotNull
    public List<FoldRegion> getGroupedRegions(FoldingGroup group) {
        List<FoldRegion> hostRegions = this.myDelegate.getGroupedRegions(group);
        ArrayList<FoldRegion> result = new ArrayList<FoldRegion>();
        for (FoldRegion hostRegion : hostRegions) {
            FoldingRegionWindow window = this.getWindowRegion(hostRegion);
            if (window == null) continue;
            result.add(window);
        }
        return result;
    }

    @Override
    public void clearDocumentRangesModificationStatus() {
    }

    @Override
    public boolean hasDocumentRegionChangedFor(@NotNull FoldRegion region) {
        return false;
    }

    @Override
    public void clearFoldRegions() {
        this.myDelegate.clearFoldRegions();
    }
}

