/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.injected.editor;

import com.intellij.ide.CopyProvider;
import com.intellij.ide.CutProvider;
import com.intellij.ide.DeleteProvider;
import com.intellij.ide.PasteProvider;
import com.intellij.ide.highlighter.HighlighterFactory;
import com.intellij.injected.editor.CaretModelWindow;
import com.intellij.injected.editor.DocumentWindowImpl;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.injected.editor.FoldingModelWindow;
import com.intellij.injected.editor.ListenerWrapperMap;
import com.intellij.injected.editor.MarkupModelWindow;
import com.intellij.injected.editor.SelectionModelWindow;
import com.intellij.injected.editor.SoftWrapModelWindow;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorGutter;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.IndentsModel;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseEventArea;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.event.EditorMouseMotionListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.editor.ex.FocusChangeListener;
import com.intellij.openapi.editor.ex.FoldingModelEx;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.ScrollingModelEx;
import com.intellij.openapi.editor.ex.SoftWrapModelEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterClient;
import com.intellij.openapi.editor.highlighter.LightHighlighterClient;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.TextDrawingCallback;
import com.intellij.openapi.editor.impl.softwrap.SoftWrapAppliancePlaces;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.containers.WeakList;
import com.intellij.util.ui.ButtonlessScrollBarUI;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditorWindowImpl
extends UserDataHolderBase
implements EditorWindow,
EditorEx {
    private final DocumentWindowImpl myDocumentWindow;
    private final EditorImpl myDelegate;
    private volatile PsiFile myInjectedFile;
    private final boolean myOneLine;
    private final CaretModelWindow myCaretModelDelegate;
    private final SelectionModelWindow mySelectionModelDelegate;
    private static final List<EditorWindowImpl> allEditors = new WeakList();
    private boolean myDisposed;
    private final MarkupModelWindow myMarkupModelDelegate;
    private final MarkupModelWindow myDocumentMarkupModelDelegate;
    private final FoldingModelWindow myFoldingModelWindow;
    private final SoftWrapModelWindow mySoftWrapModel;
    private final ListenerWrapperMap<EditorMouseListener> myEditorMouseListeners = new ListenerWrapperMap();
    private final ListenerWrapperMap<EditorMouseMotionListener> myEditorMouseMotionListeners = new ListenerWrapperMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Editor create(@NotNull DocumentWindowImpl documentRange, @NotNull EditorImpl editor, @NotNull PsiFile injectedFile) {
        EditorWindowImpl window;
        assert (documentRange.isValid());
        assert (injectedFile.isValid());
        List<EditorWindowImpl> list = allEditors;
        synchronized (list) {
            for (EditorWindowImpl editorWindow : allEditors) {
                if (editorWindow.getDocument() == documentRange && editorWindow.getDelegate() == editor) {
                    editorWindow.myInjectedFile = injectedFile;
                    if (editorWindow.isValid()) {
                        return editorWindow;
                    }
                }
                if (!editorWindow.getDocument().areRangesEqual(documentRange)) continue;
            }
            window = new EditorWindowImpl(documentRange, editor, injectedFile, documentRange.isOneLine());
            allEditors.add(window);
        }
        assert (window.isValid());
        return window;
    }

    private EditorWindowImpl(@NotNull DocumentWindowImpl documentWindow, @NotNull EditorImpl delegate, @NotNull PsiFile injectedFile, boolean oneLine) {
        this.myDocumentWindow = documentWindow;
        this.myDelegate = delegate;
        this.myInjectedFile = injectedFile;
        this.myOneLine = oneLine;
        this.myCaretModelDelegate = new CaretModelWindow(this.myDelegate.getCaretModel(), this);
        this.mySelectionModelDelegate = new SelectionModelWindow(this.myDelegate, this.myDocumentWindow, this);
        this.myMarkupModelDelegate = new MarkupModelWindow(this.myDelegate.getMarkupModel(), this.myDocumentWindow);
        this.myDocumentMarkupModelDelegate = new MarkupModelWindow(this.myDelegate.getFilteredDocumentMarkupModel(), this.myDocumentWindow);
        this.myFoldingModelWindow = new FoldingModelWindow(delegate.getFoldingModel(), documentWindow, this);
        this.mySoftWrapModel = new SoftWrapModelWindow(this);
    }

    public static void disposeInvalidEditors() {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        Iterator<EditorWindowImpl> iterator = allEditors.iterator();
        while (iterator.hasNext()) {
            EditorWindowImpl editorWindow = iterator.next();
            if (editorWindow.isValid()) continue;
            editorWindow.dispose();
            InjectedLanguageUtil.clearCaches(editorWindow.myInjectedFile, editorWindow.getDocument());
            iterator.remove();
        }
    }

    @Override
    public boolean isValid() {
        return !this.isDisposed() && !this.myInjectedFile.getProject().isDisposed() && this.myInjectedFile.isValid() && this.myDocumentWindow.isValid();
    }

    private void checkValid() {
        PsiUtilCore.ensureValid((PsiElement)this.myInjectedFile);
        if (!this.isValid()) {
            throw new AssertionError();
        }
    }

    @Override
    @NotNull
    public PsiFile getInjectedFile() {
        return this.myInjectedFile;
    }

    @Override
    @NotNull
    public LogicalPosition hostToInjected(@NotNull LogicalPosition hPos) {
        LogicalPosition iPos;
        this.checkValid();
        DocumentEx hostDocument = this.myDelegate.getDocument();
        int hLineEndOffset = hPos.line >= hostDocument.getLineCount() ? hostDocument.getTextLength() : hostDocument.getLineEndOffset(hPos.line);
        LogicalPosition hLineEndPos = this.myDelegate.offsetToLogicalPosition(hLineEndOffset);
        if (hLineEndPos.column < hPos.column && (iPos = this.myDocumentWindow.hostToInjectedInVirtualSpace(hPos)) != null) {
            return iPos;
        }
        int hOffset = this.myDelegate.logicalPositionToOffset(hPos);
        int iOffset = this.myDocumentWindow.hostToInjected(hOffset);
        return this.offsetToLogicalPosition(iOffset);
    }

    @Override
    @NotNull
    public LogicalPosition injectedToHost(@NotNull LogicalPosition pos) {
        this.checkValid();
        int offset = this.logicalPositionToOffset(pos);
        LogicalPosition samePos = this.offsetToLogicalPosition(offset);
        int virtualSpaceDelta = offset < this.myDocumentWindow.getTextLength() && samePos.line == pos.line && samePos.column < pos.column ? pos.column - samePos.column : 0;
        LogicalPosition hostPos = this.myDelegate.offsetToLogicalPosition(this.myDocumentWindow.injectedToHost(offset));
        return new LogicalPosition(hostPos.line, hostPos.column + virtualSpaceDelta);
    }

    private void dispose() {
        assert (!this.myDisposed);
        this.myCaretModelDelegate.disposeModel();
        for (EditorMouseListener editorMouseListener : this.myEditorMouseListeners.wrappers()) {
            this.myDelegate.removeEditorMouseListener(editorMouseListener);
        }
        this.myEditorMouseListeners.clear();
        for (EditorMouseMotionListener editorMouseMotionListener : this.myEditorMouseMotionListeners.wrappers()) {
            this.myDelegate.removeEditorMouseMotionListener(editorMouseMotionListener);
        }
        this.myEditorMouseMotionListeners.clear();
        this.myDisposed = true;
        Disposer.dispose((Disposable)this.myDocumentWindow);
    }

    @Override
    public void setViewer(boolean isViewer) {
        this.myDelegate.setViewer(isViewer);
    }

    public boolean isViewer() {
        return this.myDelegate.isViewer();
    }

    @Override
    public boolean isRendererMode() {
        return this.myDelegate.isRendererMode();
    }

    @Override
    public void setRendererMode(boolean isRendererMode) {
        this.myDelegate.setRendererMode(isRendererMode);
    }

    @Override
    public void setFile(VirtualFile vFile) {
        this.myDelegate.setFile(vFile);
    }

    public void setHeaderComponent(@Nullable JComponent header) {
    }

    public boolean hasHeaderComponent() {
        return false;
    }

    @Nullable
    public JComponent getHeaderComponent() {
        return null;
    }

    @Override
    public TextDrawingCallback getTextDrawingCallback() {
        return this.myDelegate.getTextDrawingCallback();
    }

    @NotNull
    public SelectionModel getSelectionModel() {
        return this.mySelectionModelDelegate;
    }

    @Override
    @NotNull
    public MarkupModelEx getMarkupModel() {
        return this.myMarkupModelDelegate;
    }

    @Override
    @NotNull
    public MarkupModelEx getFilteredDocumentMarkupModel() {
        return this.myDocumentMarkupModelDelegate;
    }

    @Override
    @NotNull
    public FoldingModelEx getFoldingModel() {
        return this.myFoldingModelWindow;
    }

    @NotNull
    public CaretModel getCaretModel() {
        return this.myCaretModelDelegate;
    }

    @Override
    @NotNull
    public ScrollingModelEx getScrollingModel() {
        return this.myDelegate.getScrollingModel();
    }

    @Override
    @NotNull
    public SoftWrapModelEx getSoftWrapModel() {
        return this.mySoftWrapModel;
    }

    @NotNull
    public EditorSettings getSettings() {
        return this.myDelegate.getSettings();
    }

    @Override
    public void reinitSettings() {
        this.myDelegate.reinitSettings();
    }

    @Override
    public void setFontSize(int fontSize) {
        this.myDelegate.setFontSize(fontSize);
    }

    @Override
    public void setHighlighter(@NotNull EditorHighlighter highlighter) {
        this.myDelegate.setHighlighter(highlighter);
    }

    @Override
    @NotNull
    public EditorHighlighter getHighlighter() {
        EditorColorsScheme scheme = EditorColorsManager.getInstance().getGlobalScheme();
        EditorHighlighter highlighter = HighlighterFactory.createHighlighter((VirtualFile)this.myInjectedFile.getVirtualFile(), (EditorColorsScheme)scheme, (Project)this.getProject());
        highlighter.setText((CharSequence)this.getDocument().getText());
        highlighter.setEditor((HighlighterClient)new LightHighlighterClient((Document)this.getDocument(), this.getProject()));
        return highlighter;
    }

    @Override
    public JComponent getPermanentHeaderComponent() {
        return this.myDelegate.getPermanentHeaderComponent();
    }

    @Override
    public void setPermanentHeaderComponent(JComponent component) {
        this.myDelegate.setPermanentHeaderComponent(component);
    }

    @NotNull
    public JComponent getContentComponent() {
        return this.myDelegate.getContentComponent();
    }

    @Override
    @NotNull
    public EditorGutterComponentEx getGutterComponentEx() {
        return this.myDelegate.getGutterComponentEx();
    }

    @Override
    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener2) {
        this.myDelegate.addPropertyChangeListener(listener2);
    }

    @Override
    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener2, @NotNull Disposable parentDisposable) {
        this.myDelegate.addPropertyChangeListener(listener2, parentDisposable);
    }

    @Override
    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener2) {
        this.myDelegate.removePropertyChangeListener(listener2);
    }

    @Override
    public void setInsertMode(boolean mode) {
        this.myDelegate.setInsertMode(mode);
    }

    public boolean isInsertMode() {
        return this.myDelegate.isInsertMode();
    }

    @Override
    public void setColumnMode(boolean mode) {
        this.myDelegate.setColumnMode(mode);
    }

    public boolean isColumnMode() {
        return this.myDelegate.isColumnMode();
    }

    @NotNull
    public VisualPosition xyToVisualPosition(@NotNull Point p) {
        return this.logicalToVisualPosition(this.xyToLogicalPosition(p));
    }

    @NotNull
    public VisualPosition offsetToVisualPosition(int offset) {
        return this.logicalToVisualPosition(this.offsetToLogicalPosition(offset));
    }

    @NotNull
    public VisualPosition offsetToVisualPosition(int offset, boolean leanForward, boolean beforeSoftWrap) {
        return this.logicalToVisualPosition(this.offsetToLogicalPosition(offset).leanForward(leanForward));
    }

    @NotNull
    public LogicalPosition offsetToLogicalPosition(int offset) {
        return this.offsetToLogicalPosition(offset, true);
    }

    @Override
    @NotNull
    public LogicalPosition offsetToLogicalPosition(int offset, boolean softWrapAware) {
        this.checkValid();
        int lineNumber = this.myDocumentWindow.getLineNumber(offset);
        int lineStartOffset = this.myDocumentWindow.getLineStartOffset(lineNumber);
        int column = this.calcLogicalColumnNumber(offset - lineStartOffset, lineNumber, lineStartOffset);
        return new LogicalPosition(lineNumber, column);
    }

    @Override
    @NotNull
    public EditorColorsScheme createBoundColorSchemeDelegate(@Nullable EditorColorsScheme customGlobalScheme) {
        return this.myDelegate.createBoundColorSchemeDelegate(customGlobalScheme);
    }

    @NotNull
    public LogicalPosition xyToLogicalPosition(@NotNull Point p) {
        this.checkValid();
        LogicalPosition hostPos = this.myDelegate.xyToLogicalPosition(p);
        return this.hostToInjected(hostPos);
    }

    @NotNull
    public Point logicalPositionToXY(@NotNull LogicalPosition pos) {
        this.checkValid();
        LogicalPosition hostPos = this.injectedToHost(pos);
        return this.myDelegate.logicalPositionToXY(hostPos);
    }

    @NotNull
    public Point visualPositionToXY(@NotNull VisualPosition pos) {
        this.checkValid();
        return this.logicalPositionToXY(this.visualToLogicalPosition(pos));
    }

    @Override
    public void repaint(int startOffset, int endOffset) {
        this.checkValid();
        this.myDelegate.repaint(this.myDocumentWindow.injectedToHost(startOffset), this.myDocumentWindow.injectedToHost(endOffset));
    }

    @Override
    @NotNull
    public DocumentWindowImpl getDocument() {
        return this.myDocumentWindow;
    }

    @NotNull
    public JComponent getComponent() {
        return this.myDelegate.getComponent();
    }

    public void addEditorMouseListener(final @NotNull EditorMouseListener listener2) {
        this.checkValid();
        EditorMouseListener wrapper = new EditorMouseListener(){

            public void mousePressed(EditorMouseEvent e) {
                listener2.mousePressed(new EditorMouseEvent((Editor)EditorWindowImpl.this, e.getMouseEvent(), e.getArea()));
            }

            public void mouseClicked(EditorMouseEvent e) {
                listener2.mouseClicked(new EditorMouseEvent((Editor)EditorWindowImpl.this, e.getMouseEvent(), e.getArea()));
            }

            public void mouseReleased(EditorMouseEvent e) {
                listener2.mouseReleased(new EditorMouseEvent((Editor)EditorWindowImpl.this, e.getMouseEvent(), e.getArea()));
            }

            public void mouseEntered(EditorMouseEvent e) {
                listener2.mouseEntered(new EditorMouseEvent((Editor)EditorWindowImpl.this, e.getMouseEvent(), e.getArea()));
            }

            public void mouseExited(EditorMouseEvent e) {
                listener2.mouseExited(new EditorMouseEvent((Editor)EditorWindowImpl.this, e.getMouseEvent(), e.getArea()));
            }
        };
        this.myEditorMouseListeners.registerWrapper(listener2, wrapper);
        this.myDelegate.addEditorMouseListener(wrapper);
    }

    public void removeEditorMouseListener(@NotNull EditorMouseListener listener2) {
        EditorMouseListener wrapper = this.myEditorMouseListeners.removeWrapper(listener2);
        if (wrapper != null) {
            this.myDelegate.removeEditorMouseListener(wrapper);
        }
    }

    public void addEditorMouseMotionListener(final @NotNull EditorMouseMotionListener listener2) {
        this.checkValid();
        EditorMouseMotionListener wrapper = new EditorMouseMotionListener(){

            public void mouseMoved(EditorMouseEvent e) {
                listener2.mouseMoved(new EditorMouseEvent((Editor)EditorWindowImpl.this, e.getMouseEvent(), e.getArea()));
            }

            public void mouseDragged(EditorMouseEvent e) {
                listener2.mouseDragged(new EditorMouseEvent((Editor)EditorWindowImpl.this, e.getMouseEvent(), e.getArea()));
            }
        };
        this.myEditorMouseMotionListeners.registerWrapper(listener2, wrapper);
        this.myDelegate.addEditorMouseMotionListener(wrapper);
    }

    public void removeEditorMouseMotionListener(@NotNull EditorMouseMotionListener listener2) {
        EditorMouseMotionListener wrapper = this.myEditorMouseMotionListeners.removeWrapper(listener2);
        if (wrapper != null) {
            this.myDelegate.removeEditorMouseMotionListener(wrapper);
        }
    }

    public boolean isDisposed() {
        return this.myDisposed || this.myDelegate.isDisposed();
    }

    @Override
    public void setBackgroundColor(Color color) {
        this.myDelegate.setBackgroundColor(color);
    }

    @Override
    public Color getBackgroundColor() {
        return this.myDelegate.getBackgroundColor();
    }

    @Override
    public int getMaxWidthInRange(int startOffset, int endOffset) {
        return this.myDelegate.getMaxWidthInRange(startOffset, endOffset);
    }

    public int getLineHeight() {
        return this.myDelegate.getLineHeight();
    }

    @Override
    public Dimension getContentSize() {
        return this.myDelegate.getContentSize();
    }

    @Override
    @NotNull
    public JScrollPane getScrollPane() {
        return this.myDelegate.getScrollPane();
    }

    public void setBorder(Border border) {
        this.myDelegate.setBorder(border);
    }

    public Insets getInsets() {
        return this.myDelegate.getInsets();
    }

    public int logicalPositionToOffset(@NotNull LogicalPosition pos) {
        return this.logicalPositionToOffset(pos, true);
    }

    @Override
    public int logicalPositionToOffset(@NotNull LogicalPosition pos, boolean softWrapAware) {
        int lineStartOffset = this.myDocumentWindow.getLineStartOffset(pos.line);
        return this.calcOffset(pos.column, pos.line, lineStartOffset);
    }

    private int calcLogicalColumnNumber(int offsetInLine, int lineNumber, int lineStartOffset) {
        if (this.myDocumentWindow.getTextLength() == 0) {
            return 0;
        }
        if (offsetInLine == 0) {
            return 0;
        }
        int end = this.myDocumentWindow.getLineEndOffset(lineNumber);
        if (offsetInLine > end - lineStartOffset) {
            offsetInLine = end - lineStartOffset;
        }
        CharSequence text = this.myDocumentWindow.getCharsSequence();
        return EditorUtil.calcColumnNumber(this, text, lineStartOffset, lineStartOffset + offsetInLine);
    }

    private int calcOffset(int col, int lineNumber, int lineStartOffset) {
        int x;
        if (this.myDocumentWindow.getTextLength() == 0) {
            return 0;
        }
        int end = this.myDocumentWindow.getLineEndOffset(lineNumber);
        int n = x = this.getDocument().getLineNumber(lineStartOffset) == 0 ? this.getPrefixTextWidthInPixels() : 0;
        if (col <= 0) {
            return lineStartOffset;
        }
        int result = EditorUtil.calcSoftWrapUnawareOffset(this, this.myDocumentWindow.getCharsSequence(), lineStartOffset, end, col, EditorUtil.getTabSize(this.myDelegate), x, new int[]{0}, null);
        if (result >= 0) {
            return result;
        }
        return end;
    }

    @Override
    public void setLastColumnNumber(int val) {
        this.myDelegate.setLastColumnNumber(val);
    }

    @Override
    public int getLastColumnNumber() {
        return this.myDelegate.getLastColumnNumber();
    }

    @Override
    @NotNull
    public VisualPosition logicalToVisualPosition(@NotNull LogicalPosition logicalPos, boolean softWrapAware) {
        this.checkValid();
        return new VisualPosition(logicalPos.line, logicalPos.column);
    }

    @NotNull
    public VisualPosition logicalToVisualPosition(@NotNull LogicalPosition pos) {
        return this.logicalToVisualPosition(pos, false);
    }

    @NotNull
    public LogicalPosition visualToLogicalPosition(@NotNull VisualPosition pos) {
        return this.visualToLogicalPosition(pos, true);
    }

    @Override
    @NotNull
    public LogicalPosition visualToLogicalPosition(@NotNull VisualPosition pos, boolean softWrapAware) {
        this.checkValid();
        return new LogicalPosition(pos.line, pos.column);
    }

    @Override
    @NotNull
    public DataContext getDataContext() {
        return this.myDelegate.getDataContext();
    }

    public EditorMouseEventArea getMouseEventArea(@NotNull MouseEvent e) {
        return this.myDelegate.getMouseEventArea(e);
    }

    @Override
    public boolean setCaretVisible(boolean b) {
        return this.myDelegate.setCaretVisible(b);
    }

    @Override
    public boolean setCaretEnabled(boolean enabled) {
        return this.myDelegate.setCaretEnabled(enabled);
    }

    @Override
    public void addFocusListener(@NotNull FocusChangeListener listener2) {
        this.myDelegate.addFocusListener(listener2);
    }

    @Override
    public void addFocusListener(@NotNull FocusChangeListener listener2, @NotNull Disposable parentDisposable) {
        this.myDelegate.addFocusListener(listener2, parentDisposable);
    }

    public Project getProject() {
        return this.myDelegate.getProject();
    }

    public boolean isOneLineMode() {
        return this.myOneLine;
    }

    @Override
    public void setOneLineMode(boolean isOneLineMode) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isEmbeddedIntoDialogWrapper() {
        return this.myDelegate.isEmbeddedIntoDialogWrapper();
    }

    @Override
    public void setEmbeddedIntoDialogWrapper(boolean b) {
        this.myDelegate.setEmbeddedIntoDialogWrapper(b);
    }

    @Override
    public VirtualFile getVirtualFile() {
        return this.myDelegate.getVirtualFile();
    }

    @Override
    public CopyProvider getCopyProvider() {
        return this.myDelegate.getCopyProvider();
    }

    @Override
    public CutProvider getCutProvider() {
        return this.myDelegate.getCutProvider();
    }

    @Override
    public PasteProvider getPasteProvider() {
        return this.myDelegate.getPasteProvider();
    }

    @Override
    public DeleteProvider getDeleteProvider() {
        return this.myDelegate.getDeleteProvider();
    }

    @Override
    public void setColorsScheme(@NotNull EditorColorsScheme scheme) {
        this.myDelegate.setColorsScheme(scheme);
    }

    @NotNull
    public EditorColorsScheme getColorsScheme() {
        return this.myDelegate.getColorsScheme();
    }

    @Override
    public void setVerticalScrollbarOrientation(int type) {
        this.myDelegate.setVerticalScrollbarOrientation(type);
    }

    @Override
    public int getVerticalScrollbarOrientation() {
        return this.myDelegate.getVerticalScrollbarOrientation();
    }

    @Override
    public void setVerticalScrollbarVisible(boolean b) {
        this.myDelegate.setVerticalScrollbarVisible(b);
    }

    @Override
    public void setHorizontalScrollbarVisible(boolean b) {
        this.myDelegate.setHorizontalScrollbarVisible(b);
    }

    @Override
    public boolean processKeyTyped(@NotNull KeyEvent e) {
        return this.myDelegate.processKeyTyped(e);
    }

    @NotNull
    public EditorGutter getGutter() {
        return this.myDelegate.getGutter();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EditorWindowImpl that = (EditorWindowImpl)o;
        DocumentWindowImpl thatWindow = that.getDocument();
        return this.myDelegate.equals(that.myDelegate) && this.myDocumentWindow.equals(thatWindow);
    }

    public int hashCode() {
        return this.myDocumentWindow.hashCode();
    }

    @Override
    @NotNull
    public Editor getDelegate() {
        return this.myDelegate;
    }

    @Override
    public int calcColumnNumber(@NotNull CharSequence text, int start, int offset, int tabSize) {
        int hostStart = this.myDocumentWindow.injectedToHost(start);
        int hostOffset = this.myDocumentWindow.injectedToHost(offset);
        return this.myDelegate.calcColumnNumber(this.myDelegate.getDocument().getText(), hostStart, hostOffset, tabSize);
    }

    @Override
    public int calcColumnNumber(int offset, int lineIndex) {
        return this.myDelegate.calcColumnNumber(this.myDocumentWindow.injectedToHost(offset), this.myDocumentWindow.injectedToHostLine(lineIndex));
    }

    @NotNull
    public IndentsModel getIndentsModel() {
        return this.myDelegate.getIndentsModel();
    }

    @Override
    public void setSoftWrapAppliancePlace(@NotNull SoftWrapAppliancePlaces place) {
        this.myDelegate.setSoftWrapAppliancePlace(place);
    }

    @Override
    public void setPlaceholder(@Nullable CharSequence text) {
        this.myDelegate.setPlaceholder(text);
    }

    @Override
    public void setPlaceholderAttributes(@Nullable TextAttributes attributes) {
        this.myDelegate.setPlaceholderAttributes(attributes);
    }

    @Override
    public void setShowPlaceholderWhenFocused(boolean show) {
        this.myDelegate.setShowPlaceholderWhenFocused(show);
    }

    @Override
    public boolean isStickySelection() {
        return this.myDelegate.isStickySelection();
    }

    @Override
    public void setStickySelection(boolean enable) {
        this.myDelegate.setStickySelection(enable);
    }

    @Override
    public boolean isPurePaintingMode() {
        return this.myDelegate.isPurePaintingMode();
    }

    @Override
    public void setPurePaintingMode(boolean enabled) {
        this.myDelegate.setPurePaintingMode(enabled);
    }

    @Override
    public void registerScrollBarRepaintCallback(@Nullable ButtonlessScrollBarUI.ScrollbarRepaintCallback callback) {
        this.myDelegate.registerScrollBarRepaintCallback(callback);
    }

    @Override
    public void setPrefixTextAndAttributes(@Nullable String prefixText, @Nullable TextAttributes attributes) {
        this.myDelegate.setPrefixTextAndAttributes(prefixText, attributes);
    }

    @Override
    public int getPrefixTextWidthInPixels() {
        return this.myDelegate.getPrefixTextWidthInPixels();
    }

    public String toString() {
        return super.toString() + "[disposed=" + this.myDisposed + "; valid=" + this.isValid() + "]";
    }

    @Override
    public int getExpectedCaretOffset() {
        return this.myDocumentWindow.hostToInjected(this.myDelegate.getExpectedCaretOffset());
    }

    @Override
    public void setContextMenuGroupId(@Nullable String groupId) {
        this.myDelegate.setContextMenuGroupId(groupId);
    }

    @Override
    @Nullable
    public String getContextMenuGroupId() {
        return this.myDelegate.getContextMenuGroupId();
    }
}

