/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.idea;

import com.intellij.ide.IdeBundle;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.JetBrainsProtocolHandler;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.NotNullProducer;
import com.intellij.util.PlatformUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.net.NetUtils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.ConnectException;
import java.net.Socket;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.io.BuiltInServer;
import org.jetbrains.io.MessageDecoder;

public final class SocketLock {
    private static final String PORT_FILE = "port";
    private static final String PORT_LOCK_FILE = "port.lock";
    private static final String TOKEN_FILE = "token";
    private static final String ACTIVATE_COMMAND = "activate ";
    private static final String PID_COMMAND = "pid";
    private static final String PATHS_EOT_RESPONSE = "---";
    private static final String OK_RESPONSE = "ok";
    private final String myConfigPath;
    private final String mySystemPath;
    private final AtomicReference<Consumer<List<String>>> myActivateListener = new AtomicReference();
    private String myToken;
    private BuiltInServer myServer;

    public SocketLock(@NotNull String configPath, @NotNull String systemPath) {
        this.myConfigPath = SocketLock.canonicalPath(configPath);
        this.mySystemPath = SocketLock.canonicalPath(systemPath);
    }

    public void setExternalInstanceListener(@Nullable Consumer<List<String>> consumer) {
        this.myActivateListener.set(consumer);
    }

    public void dispose() {
        SocketLock.log("enter: dispose()", new Object[0]);
        BuiltInServer server = this.myServer;
        if (server == null) {
            return;
        }
        try {
            Disposer.dispose((Disposable)server);
        }
        catch (Throwable throwable) {
            try {
                this.underLocks(new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        FileUtil.delete((File)new File(SocketLock.this.myConfigPath, SocketLock.PORT_FILE));
                        FileUtil.delete((File)new File(SocketLock.this.mySystemPath, SocketLock.PORT_FILE));
                        FileUtil.delete((File)new File(SocketLock.this.mySystemPath, SocketLock.TOKEN_FILE));
                        return null;
                    }
                });
            }
            catch (Exception e) {
                Logger.getInstance(SocketLock.class).warn((Throwable)e);
            }
            throw throwable;
        }
        try {
            this.underLocks(new /* invalid duplicate definition of identical inner class */);
        }
        catch (Exception e) {
            Logger.getInstance(SocketLock.class).warn((Throwable)e);
        }
    }

    @Nullable
    public BuiltInServer getServer() {
        return this.myServer;
    }

    @NotNull
    public ActivateStatus lock() throws Exception {
        return this.lock(ArrayUtil.EMPTY_STRING_ARRAY);
    }

    @NotNull
    public ActivateStatus lock(final @NotNull String[] args) throws Exception {
        SocketLock.log("enter: lock(config=%s system=%s)", this.myConfigPath, this.mySystemPath);
        return this.underLocks(new Callable<ActivateStatus>(){

            @Override
            public ActivateStatus call() throws Exception {
                File portMarkerC = new File(SocketLock.this.myConfigPath, SocketLock.PORT_FILE);
                File portMarkerS = new File(SocketLock.this.mySystemPath, SocketLock.PORT_FILE);
                List ports = ContainerUtil.newSmartList();
                SocketLock.addExistingPort(portMarkerC, ports);
                SocketLock.addExistingPort(portMarkerS, ports);
                if (!ports.isEmpty()) {
                    Iterator iterator = ports.iterator();
                    while (iterator.hasNext()) {
                        int port = (Integer)iterator.next();
                        ActivateStatus status = SocketLock.tryActivate(port, SocketLock.this.myConfigPath, SocketLock.this.mySystemPath, args);
                        if (status == ActivateStatus.NO_INSTANCE) continue;
                        return status;
                    }
                }
                if (SocketLock.isShutdownCommand()) {
                    System.exit(0);
                }
                SocketLock.this.myToken = UUID.randomUUID().toString();
                final String[] lockedPaths = new String[]{SocketLock.this.myConfigPath, SocketLock.this.mySystemPath};
                int workerCount = PlatformUtils.isIdeaCommunity() || PlatformUtils.isDatabaseIDE() || PlatformUtils.isCidr() ? 1 : 2;
                SocketLock.this.myServer = BuiltInServer.startNioOrOio(workerCount, 6942, 50, false, new NotNullProducer<ChannelHandler>(){

                    @NotNull
                    public ChannelHandler produce() {
                        return new MyChannelInboundHandler(lockedPaths, SocketLock.this.myActivateListener, SocketLock.this.myToken);
                    }
                });
                byte[] portBytes = Integer.toString(SocketLock.this.myServer.getPort()).getBytes(CharsetToolkit.UTF8_CHARSET);
                FileUtil.writeToFile((File)portMarkerC, (byte[])portBytes);
                FileUtil.writeToFile((File)portMarkerS, (byte[])portBytes);
                File tokenFile = new File(SocketLock.this.mySystemPath, SocketLock.TOKEN_FILE);
                FileUtil.writeToFile((File)tokenFile, (byte[])SocketLock.this.myToken.getBytes(CharsetToolkit.UTF8_CHARSET));
                PosixFileAttributeView view = Files.getFileAttributeView(tokenFile.toPath(), PosixFileAttributeView.class, new LinkOption[0]);
                if (view != null) {
                    try {
                        view.setPermissions(ContainerUtil.newHashSet((Object[])new PosixFilePermission[]{PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE}));
                    }
                    catch (IOException e) {
                        SocketLock.log(e);
                    }
                }
                SocketLock.log("exit: lock(): succeed", new Object[0]);
                return ActivateStatus.NO_INSTANCE;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <V> V underLocks(@NotNull Callable<V> action) throws Exception {
        FileUtilRt.createDirectory((File)new File(this.myConfigPath));
        try (FileOutputStream lock1 = new FileOutputStream(new File(this.myConfigPath, PORT_LOCK_FILE), true);){
            V v;
            FileUtilRt.createDirectory((File)new File(this.mySystemPath));
            FileOutputStream lock2 = new FileOutputStream(new File(this.mySystemPath, PORT_LOCK_FILE), true);
            try {
                v = action.call();
            }
            catch (Throwable throwable) {
                lock2.close();
                throw throwable;
            }
            lock2.close();
            return v;
        }
    }

    private static void addExistingPort(@NotNull File portMarker, @NotNull List<Integer> ports) {
        if (portMarker.exists()) {
            try {
                int port = Integer.parseInt(FileUtilRt.loadFile((File)portMarker));
                if (!ports.contains(port)) {
                    ports.add(port);
                }
            }
            catch (Exception e) {
                SocketLock.log(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private static ActivateStatus tryActivate(int portNumber, @NotNull String configPath, @NotNull String systemPath, @NotNull String[] args) {
        SocketLock.log("trying: port=%s", portNumber);
        args = SocketLock.checkForJetBrainsProtocolCommand(args);
        try (Socket socket = new Socket(NetUtils.getLoopbackAddress(), portNumber);){
            socket.setSoTimeout(1000);
            boolean result = false;
            DataInputStream in = new DataInputStream(socket.getInputStream());
            try {
                while (true) {
                    String path = in.readUTF();
                    SocketLock.log("read: path=%s", path);
                    if (!PATHS_EOT_RESPONSE.equals(path)) {
                        if (!configPath.equals(path) && !systemPath.equals(path)) continue;
                        result = true;
                        continue;
                    }
                    break;
                }
            }
            catch (IOException e) {
                SocketLock.log("read: %s", e.getMessage());
            }
            if (!result) return ActivateStatus.NO_INSTANCE;
            try {
                String token = FileUtil.loadFile((File)new File(systemPath, TOKEN_FILE));
                DataOutputStream out = new DataOutputStream(socket.getOutputStream());
                out.writeUTF(ACTIVATE_COMMAND + token + "\u0000" + new File(".").getAbsolutePath() + "\u0000" + StringUtil.join((String[])args, (String)"\u0000"));
                out.flush();
                String response = in.readUTF();
                SocketLock.log("read: response=%s", response);
                if (response.equals(OK_RESPONSE)) {
                    if (SocketLock.isShutdownCommand()) {
                        SocketLock.printPID(portNumber);
                    }
                    ActivateStatus activateStatus = ActivateStatus.ACTIVATED;
                    return activateStatus;
                }
            }
            catch (IOException e) {
                SocketLock.log(e);
            }
            ActivateStatus activateStatus = ActivateStatus.CANNOT_ACTIVATE;
            return activateStatus;
        }
        catch (ConnectException e) {
            SocketLock.log("%s (stale port file?)", e.getMessage());
            return ActivateStatus.NO_INSTANCE;
        }
        catch (IOException e) {
            SocketLock.log(e);
        }
        return ActivateStatus.NO_INSTANCE;
    }

    private static void printPID(int port) {
        try {
            Socket socket = new Socket(NetUtils.getLoopbackAddress(), port);
            socket.setSoTimeout(1000);
            DataOutputStream out = new DataOutputStream(socket.getOutputStream());
            out.writeUTF(PID_COMMAND);
            DataInputStream in = new DataInputStream(socket.getInputStream());
            int pid = 0;
            try {
                while (true) {
                    String s;
                    if (!Pattern.matches("[0-9]+@.*", s = in.readUTF())) {
                        continue;
                    }
                    pid = Integer.parseInt(s.substring(0, s.indexOf(64)));
                    System.err.println(pid);
                }
            }
            catch (IOException e) {
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static boolean isShutdownCommand() {
        return "shutdown".equals(JetBrainsProtocolHandler.getCommand());
    }

    private static String[] checkForJetBrainsProtocolCommand(String[] args) {
        String jbUrl = System.getProperty(JetBrainsProtocolHandler.class.getName());
        if (jbUrl != null) {
            return new String[]{jbUrl};
        }
        return args;
    }

    @NotNull
    private static String canonicalPath(@NotNull String configPath) {
        try {
            return new File(configPath).getCanonicalPath();
        }
        catch (IOException ignore) {
            return configPath;
        }
    }

    private static void log(Exception e) {
        Logger.getInstance(SocketLock.class).warn((Throwable)e);
    }

    private static void log(String format, Object ... args) {
        Logger logger = Logger.getInstance(SocketLock.class);
        if (logger.isDebugEnabled()) {
            logger.debug(String.format(format, args));
        }
    }

    private static class MyChannelInboundHandler
    extends MessageDecoder {
        private final String[] myLockedPaths;
        private final AtomicReference<Consumer<List<String>>> myActivateListener;
        private final String myToken;
        private State myState = State.HEADER;

        public MyChannelInboundHandler(@NotNull String[] lockedPaths, @NotNull AtomicReference<Consumer<List<String>>> activateListener, @NotNull String token) {
            this.myLockedPaths = lockedPaths;
            this.myActivateListener = activateListener;
            this.myToken = token;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void channelActive(ChannelHandlerContext context) throws Exception {
            ByteBuf buffer = context.alloc().ioBuffer(1024);
            boolean success = false;
            try {
                ByteBufOutputStream out = new ByteBufOutputStream(buffer);
                for (String path : this.myLockedPaths) {
                    out.writeUTF(path);
                }
                out.writeUTF(SocketLock.PATHS_EOT_RESPONSE);
                out.close();
                success = true;
            }
            finally {
                if (!success) {
                    buffer.release();
                }
            }
            context.writeAndFlush((Object)buffer);
        }

        @Override
        protected void messageReceived(@NotNull ChannelHandlerContext context, @NotNull ByteBuf input) throws Exception {
            while (true) {
                switch (this.myState) {
                    case HEADER: {
                        ByteBuf buffer = this.getBufferIfSufficient(input, 2, context);
                        if (buffer == null) {
                            return;
                        }
                        this.contentLength = buffer.readUnsignedShort();
                        if (this.contentLength > 8192) {
                            context.close();
                            return;
                        }
                        this.myState = State.CONTENT;
                        break;
                    }
                    case CONTENT: {
                        CharSequence command = this.readChars(input);
                        if (command == null) {
                            return;
                        }
                        if (StringUtil.startsWith((CharSequence)command, (CharSequence)SocketLock.PID_COMMAND)) {
                            ByteBuf buffer = context.alloc().ioBuffer();
                            ByteBufOutputStream out = new ByteBufOutputStream(buffer);
                            String name = ManagementFactory.getRuntimeMXBean().getName();
                            out.writeUTF(name);
                            out.close();
                            context.writeAndFlush((Object)buffer);
                        }
                        if (StringUtil.startsWith((CharSequence)command, (CharSequence)SocketLock.ACTIVATE_COMMAND)) {
                            boolean tokenOK;
                            List args = StringUtil.split((String)command.subSequence(SocketLock.ACTIVATE_COMMAND.length(), command.length()).toString(), (String)"\u0000");
                            boolean bl = tokenOK = !args.isEmpty() && this.myToken.equals(args.get(0));
                            if (!tokenOK) {
                                SocketLock.log(new UnsupportedOperationException("unauthorized request: " + command));
                                Notifications.Bus.notify((Notification)new Notification("System Messages", IdeBundle.message((String)"activation.auth.title", (Object[])new Object[0]), IdeBundle.message((String)"activation.auth.message", (Object[])new Object[0]), NotificationType.WARNING));
                            } else {
                                Consumer<List<String>> listener2 = this.myActivateListener.get();
                                if (listener2 != null) {
                                    listener2.consume(args.subList(1, args.size()));
                                }
                            }
                            ByteBuf buffer = context.alloc().ioBuffer(4);
                            ByteBufOutputStream out = new ByteBufOutputStream(buffer);
                            out.writeUTF(SocketLock.OK_RESPONSE);
                            out.close();
                            context.writeAndFlush((Object)buffer);
                        }
                        context.close();
                    }
                }
            }
        }

        private static enum State {
            HEADER,
            CONTENT;

        }
    }

    public static enum ActivateStatus {
        ACTIVATED,
        NO_INSTANCE,
        CANNOT_ACTIVATE;

    }
}

