/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.treeView.smartTree;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.smartTree.CachingChildrenTreeNode;
import com.intellij.ide.util.treeView.smartTree.Group;
import com.intellij.ide.util.treeView.smartTree.TreeElement;
import com.intellij.ide.util.treeView.smartTree.TreeElementWrapper;
import com.intellij.ide.util.treeView.smartTree.TreeModel;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class GroupWrapper
extends CachingChildrenTreeNode<Group> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.util.treeView.smartTree.GroupWrapper");

    public GroupWrapper(Project project2, Group value, TreeModel treeModel) {
        super(project2, value, treeModel);
        this.clearChildren();
    }

    @Override
    public void copyFromNewInstance(@NotNull CachingChildrenTreeNode newInstance) {
        this.clearChildren();
        this.setChildren(newInstance.getChildren());
        this.synchronizeChildren();
    }

    public void update(PresentationData presentation) {
        presentation.updateFrom(((Group)this.getValue()).getPresentation());
    }

    @Override
    public void initChildren() {
        this.clearChildren();
        Group group = (Group)this.getValue();
        Collection children2 = group.getChildren();
        for (TreeElement child : children2) {
            if (child == null) {
                LOG.error(group + " returned null child: " + children2);
            }
            TreeElementWrapper childNode = this.createChildNode(child);
            this.addSubElement(childNode);
        }
    }

    @Override
    protected void performTreeActions() {
        this.filterChildren(this.myTreeModel.getFilters());
        this.groupChildren(this.myTreeModel.getGroupers());
        this.sortChildren(this.myTreeModel.getSorters());
    }
}

