/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.scopeChooser;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.packageDependencies.ChangeListsScopesProvider;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopes;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.search.scope.ProjectFilesScope;
import com.intellij.psi.search.scope.ProjectProductionScope;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScopeChooserUtils {
    private static final String CURRENT_FILE_SCOPE_NAME = IdeBundle.message((String)"scope.current.file", (Object[])new Object[0]);

    private ScopeChooserUtils() {
    }

    @NotNull
    public static GlobalSearchScope findScopeByName(@NotNull Project project2, @Nullable String scopeName) {
        NamedScope namedScope;
        NamedScope namedScope2 = namedScope = scopeName == null ? null : ChangeListsScopesProvider.getInstance(project2).getCustomScope(scopeName);
        if (namedScope == null) {
            namedScope = NamedScopesHolder.getScope((Project)project2, (String)scopeName);
        }
        if (namedScope == null && "Open Files".equals(scopeName)) {
            return ScopeChooserUtils.intersectWithContentScope(project2, GlobalSearchScopes.openFilesScope((Project)project2));
        }
        if (namedScope == null && CURRENT_FILE_SCOPE_NAME.equals(scopeName)) {
            Object[] array = FileEditorManager.getInstance((Project)project2).getSelectedFiles();
            List files = ContainerUtil.createMaybeSingletonList((Object)ArrayUtil.getFirstElement((Object[])array));
            GlobalSearchScope scope = GlobalSearchScope.filesScope((Project)project2, (Collection)files, (String)CURRENT_FILE_SCOPE_NAME);
            return ScopeChooserUtils.intersectWithContentScope(project2, scope);
        }
        if (namedScope == null) {
            namedScope = new ProjectFilesScope();
        }
        GlobalSearchScope scope = GlobalSearchScopesCore.filterScope((Project)project2, (NamedScope)namedScope);
        if (namedScope instanceof ProjectFilesScope || namedScope instanceof ProjectProductionScope) {
            return scope;
        }
        return ScopeChooserUtils.intersectWithContentScope(project2, scope);
    }

    @NotNull
    private static GlobalSearchScope intersectWithContentScope(@NotNull Project project2, @NotNull GlobalSearchScope scope) {
        return scope.intersectWith(ProjectScope.getContentScope((Project)project2));
    }
}

