/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.newProjectWizard.modes;

import com.intellij.ide.util.newProjectWizard.SelectTemplateStep;
import com.intellij.ide.util.newProjectWizard.StepSequence;
import com.intellij.ide.util.newProjectWizard.TemplatesGroup;
import com.intellij.ide.util.newProjectWizard.modes.WizardMode;
import com.intellij.ide.util.projectWizard.AbstractModuleBuilder;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.platform.ProjectTemplate;
import com.intellij.platform.ProjectTemplatesFactory;
import com.intellij.util.containers.MultiMap;
import java.util.Arrays;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateFromTemplateMode
extends WizardMode {
    private SelectTemplateStep mySelectTemplateStep;

    public static MultiMap<TemplatesGroup, ProjectTemplate> getTemplatesMap(WizardContext context) {
        ProjectTemplatesFactory[] factories = (ProjectTemplatesFactory[])ProjectTemplatesFactory.EP_NAME.getExtensions();
        MultiMap groups = new MultiMap();
        for (ProjectTemplatesFactory factory : factories) {
            for (String group : factory.getGroups()) {
                ProjectTemplate[] templates = factory.createTemplates(group, context);
                List<ProjectTemplate> values = Arrays.asList(templates);
                if (values.isEmpty()) continue;
                Icon icon = factory.getGroupIcon(group);
                String parentGroup = factory.getParentGroup(group);
                TemplatesGroup templatesGroup = new TemplatesGroup(group, null, icon, factory.getGroupWeight(group), parentGroup, group, null);
                groups.putValues((Object)templatesGroup, values);
            }
        }
        return groups;
    }

    @Override
    @NotNull
    public String getDisplayName(WizardContext context) {
        return ProjectBundle.message((String)"project.new.wizard.from.template.title", (Object[])new Object[]{context.getPresentationName()});
    }

    @Override
    @NotNull
    public String getDescription(WizardContext context) {
        return ProjectBundle.message((String)"project.new.wizard.from.template.description", (Object[])new Object[]{context.getPresentationName()});
    }

    @Override
    public boolean isAvailable(WizardContext context) {
        return true;
    }

    @Override
    @Nullable
    protected StepSequence createSteps(@NotNull WizardContext context, @NotNull ModulesProvider modulesProvider) {
        MultiMap<TemplatesGroup, ProjectTemplate> map = CreateFromTemplateMode.getTemplatesMap(context);
        StepSequence sequence = new StepSequence(new ModuleWizardStep[0]);
        for (ProjectTemplate template : map.values()) {
            sequence.addStepsForBuilder(template.createModuleBuilder(), context, modulesProvider);
        }
        this.mySelectTemplateStep = new SelectTemplateStep(context, sequence, map);
        sequence.addCommonStep(this.mySelectTemplateStep);
        return sequence;
    }

    @Nullable
    public AbstractModuleBuilder getModuleBuilder() {
        ProjectTemplate template = this.mySelectTemplateStep.getSelectedTemplate();
        if (template == null) {
            return null;
        }
        return template.createModuleBuilder();
    }

    @Override
    public String getShortName() {
        return "Create from Template";
    }

    @Override
    public void onChosen(boolean enabled) {
    }
}

