/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.gotoByName;

import com.intellij.util.diff.Diff;
import com.intellij.util.diff.FilesTooBigForDiffException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModelDiff {
    @Nullable
    public static List<Cmd> createDiffCmds(@NotNull Model<Object> listModel, @NotNull Object[] oldElements, @NotNull Object[] newElements) {
        Diff.Change change = null;
        try {
            change = Diff.buildChanges((Object[])oldElements, (Object[])newElements);
        }
        catch (FilesTooBigForDiffException filesTooBigForDiffException) {
            // empty catch block
        }
        if (change == null) {
            return null;
        }
        ArrayList<Cmd> commands = new ArrayList<Cmd>();
        int inserted = 0;
        int deleted = 0;
        while (change != null) {
            if (change.deleted > 0) {
                int start = change.line0 + inserted - deleted;
                commands.add(new RemoveCmd(listModel, start, start + change.deleted - 1));
            }
            if (change.inserted > 0) {
                for (int i = 0; i < change.inserted; ++i) {
                    commands.add(new InsertCmd(listModel, change.line0 + i + inserted - deleted, newElements[change.line1 + i]));
                }
            }
            deleted += change.deleted;
            inserted += change.inserted;
            change = change.link;
        }
        return commands;
    }

    private static class InsertCmd<T>
    implements Cmd {
        private final Model<T> myListModel;
        private final int idx;
        private final T element;

        private InsertCmd(@NotNull Model<T> model, int idx, @NotNull T element) {
            this.myListModel = model;
            this.idx = idx;
            this.element = element;
        }

        @Override
        public void apply() {
            this.myListModel.addToModel(this.idx, this.element);
        }

        @Override
        public int translateSelection(int row) {
            return this.idx > row ? row : row + 1;
        }

        public String toString() {
            return "+[" + this.idx + "]";
        }
    }

    private static class RemoveCmd<T>
    implements Cmd {
        private final Model<T> myListModel;
        private final int start;
        private final int end;

        private RemoveCmd(@NotNull Model<T> model, int start, int end) {
            this.myListModel = model;
            this.start = start;
            this.end = end;
        }

        @Override
        public void apply() {
            this.myListModel.removeRangeFromModel(this.start, this.end);
        }

        @Override
        public int translateSelection(int row) {
            if (row < this.start) {
                return row;
            }
            if (row >= this.end) {
                return row - (this.end - this.start);
            }
            return this.start - 1;
        }

        public String toString() {
            return "-[" + this.start + ", " + this.end + "]";
        }
    }

    public static interface Model<T> {
        public void addToModel(int var1, T var2);

        public void removeRangeFromModel(int var1, int var2);
    }

    public static interface Cmd {
        public void apply();

        public int translateSelection(int var1);
    }
}

