/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.gotoByName;

import com.intellij.ide.util.gotoByName.ChooseByNamePopup;
import com.intellij.navigation.ChooseByNameContributorEx;
import com.intellij.navigation.GotoClassContributor;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.MinusculeMatcher;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.psi.presentation.java.SymbolPresentationUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.psi.util.ClassUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FindSymbolParameters;
import com.intellij.util.indexing.IdFilter;
import java.util.Collection;
import java.util.regex.Matcher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultClassNavigationContributor
implements ChooseByNameContributorEx,
GotoClassContributor {
    @NotNull
    public String[] getNames(Project project2, boolean includeNonProjectItems) {
        if (FileBasedIndex.ourEnableTracingOfKeyHashToVirtualFileMapping) {
            GlobalSearchScope scope = includeNonProjectItems ? GlobalSearchScope.allScope((Project)project2) : GlobalSearchScope.projectScope((Project)project2);
            CommonProcessors.CollectProcessor processor2 = new CommonProcessors.CollectProcessor();
            this.processNames((Processor<String>)processor2, scope, IdFilter.getProjectIdFilter((Project)project2, (boolean)includeNonProjectItems));
            return ArrayUtil.toStringArray((Collection)processor2.getResults());
        }
        return PsiShortNamesCache.getInstance((Project)project2).getAllClassNames();
    }

    @NotNull
    public NavigationItem[] getItemsByName(String name, String pattern, Project project2, boolean includeNonProjectItems) {
        CommonProcessors.CollectProcessor processor2 = new CommonProcessors.CollectProcessor();
        this.processElementsWithName(name, (Processor<NavigationItem>)processor2, FindSymbolParameters.wrap(pattern, project2, includeNonProjectItems));
        return (NavigationItem[])processor2.toArray((Object[])new NavigationItem[processor2.getResults().size()]);
    }

    public String getQualifiedName(NavigationItem item) {
        if (item instanceof PsiClass) {
            return DefaultClassNavigationContributor.getQualifiedNameForClass((PsiClass)item);
        }
        return null;
    }

    public static String getQualifiedNameForClass(PsiClass psiClass) {
        String qName = psiClass.getQualifiedName();
        if (qName != null) {
            return qName;
        }
        String containerText = SymbolPresentationUtil.getSymbolContainerText((PsiElement)psiClass);
        return containerText + "." + psiClass.getName();
    }

    public String getQualifiedNameSeparator() {
        return "$";
    }

    @Override
    public void processNames(@NotNull Processor<String> processor2, @NotNull GlobalSearchScope scope, @Nullable IdFilter filter) {
        PsiShortNamesCache.getInstance((Project)scope.getProject()).processAllClassNames(processor2, scope, filter);
    }

    @Override
    public void processElementsWithName(@NotNull String name, final @NotNull Processor<NavigationItem> processor2, final @NotNull FindSymbolParameters parameters) {
        Matcher matcher;
        String namePattern = StringUtil.getShortName((String)parameters.getCompletePattern());
        boolean hasDollar = namePattern.contains("$");
        if (hasDollar && (matcher = ChooseByNamePopup.patternToDetectAnonymousClasses.matcher(namePattern)).matches()) {
            namePattern = matcher.group(1);
            hasDollar = namePattern.contains("$");
        }
        final MinusculeMatcher innerMatcher = hasDollar ? new MinusculeMatcher("*" + namePattern, NameUtil.MatchingCaseSensitivity.NONE) : null;
        PsiShortNamesCache.getInstance((Project)parameters.getProject()).processClassesWithName(name, (Processor)new Processor<PsiClass>(){
            final boolean isAnnotation;
            {
                this.isAnnotation = parameters.getLocalPatternName().startsWith("@");
            }

            public boolean process(PsiClass aClass) {
                if (aClass.getContainingFile().getVirtualFile() == null || !aClass.isPhysical()) {
                    return true;
                }
                if (this.isAnnotation && !aClass.isAnnotationType()) {
                    return true;
                }
                if (innerMatcher != null) {
                    if (aClass.getContainingClass() == null) {
                        return true;
                    }
                    String jvmQName = ClassUtil.getJVMClassName((PsiClass)aClass);
                    if (jvmQName == null || !innerMatcher.matches(StringUtil.getShortName((String)jvmQName))) {
                        return true;
                    }
                }
                return processor2.process((Object)aClass);
            }
        }, parameters.getSearchScope(), parameters.getIdFilter());
    }
}

