/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.gotoByName;

import com.intellij.concurrency.JobLauncher;
import com.intellij.ide.util.gotoByName.ChooseByNameBase;
import com.intellij.ide.util.gotoByName.ChooseByNameItemProvider;
import com.intellij.ide.util.gotoByName.ChooseByNameModel;
import com.intellij.ide.util.gotoByName.ChooseByNameModelEx;
import com.intellij.ide.util.gotoByName.ContributorsBasedGotoByModel;
import com.intellij.ide.util.gotoByName.CustomMatcherModel;
import com.intellij.ide.util.gotoByName.MatchResult;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.MinusculeMatcher;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.proximity.PsiProximityComparator;
import com.intellij.util.CollectConsumer;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.SynchronizedCollectConsumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FList;
import com.intellij.util.indexing.FindSymbolParameters;
import com.intellij.util.indexing.IdFilter;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultChooseByNameItemProvider
implements ChooseByNameItemProvider {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.util.gotoByName.ChooseByNameIdea");
    private final SmartPsiElementPointer myContext;

    public DefaultChooseByNameItemProvider(@Nullable PsiElement context) {
        this.myContext = context == null ? null : SmartPointerManager.getInstance((Project)context.getProject()).createSmartPsiElementPointer(context);
    }

    @Override
    public boolean filterElements(final @NotNull ChooseByNameBase base, final @NotNull String pattern, boolean everywhere, final @NotNull ProgressIndicator indicator, @NotNull Processor<Object> consumer) {
        long started;
        String namePattern = DefaultChooseByNameItemProvider.getNamePattern(base, pattern);
        String qualifierPattern = DefaultChooseByNameItemProvider.getQualifierPattern(base, pattern);
        if (DefaultChooseByNameItemProvider.removeModelSpecificMarkup(base.getModel(), namePattern).isEmpty() && !base.canShowListForEmptyPattern()) {
            return true;
        }
        final ChooseByNameModel model = base.getModel();
        String matchingPattern = DefaultChooseByNameItemProvider.convertToMatchingPattern(base, namePattern);
        if (matchingPattern == null) {
            return true;
        }
        ArrayList namesList = new ArrayList();
        SynchronizedCollectConsumer collect = new SynchronizedCollectConsumer(namesList);
        if (model instanceof ChooseByNameModelEx) {
            indicator.checkCanceled();
            started = System.currentTimeMillis();
            final MinusculeMatcher matcher = DefaultChooseByNameItemProvider.buildPatternMatcher(matchingPattern, NameUtil.MatchingCaseSensitivity.NONE);
            ((ChooseByNameModelEx)model).processNames(new Processor<String>((CollectConsumer)collect){
                final /* synthetic */ CollectConsumer val$collect;
                {
                    this.val$collect = collectConsumer;
                }

                public boolean process(String sequence) {
                    indicator.checkCanceled();
                    MatchResult result = DefaultChooseByNameItemProvider.matches(base, pattern, matcher, sequence);
                    if (result != null) {
                        this.val$collect.consume((Object)result);
                        return true;
                    }
                    return false;
                }
            }, everywhere);
            if (LOG.isDebugEnabled()) {
                LOG.debug("loaded + matched:" + (System.currentTimeMillis() - started) + "," + collect.getResult().size());
            }
        } else {
            String[] names = base.getNames(everywhere);
            started = System.currentTimeMillis();
            DefaultChooseByNameItemProvider.processNamesByPattern(base, names, matchingPattern, indicator, (Consumer<MatchResult>)collect);
            if (LOG.isDebugEnabled()) {
                LOG.debug("matched:" + (System.currentTimeMillis() - started) + "," + names.length);
            }
        }
        indicator.checkCanceled();
        started = System.currentTimeMillis();
        List results = (List)collect.getResult();
        this.sortNamesList(matchingPattern, results);
        if (LOG.isDebugEnabled()) {
            LOG.debug("sorted:" + (System.currentTimeMillis() - started) + ",results:" + results.size());
        }
        indicator.checkCanceled();
        SmartList sameNameElements = new SmartList();
        THashMap qualifierMatchResults = ContainerUtil.newIdentityTroveMap();
        Comparator<Object> weightComparator = new Comparator<Object>((Map)qualifierMatchResults){
            Comparator<Object> modelComparator;
            final /* synthetic */ Map val$qualifierMatchResults;
            {
                this.val$qualifierMatchResults = map;
                this.modelComparator = model instanceof Comparator ? (Comparator)model : new PathProximityComparator(DefaultChooseByNameItemProvider.this.myContext == null ? null : DefaultChooseByNameItemProvider.this.myContext.getElement());
            }

            @Override
            public int compare(Object o1, Object o2) {
                int result = this.modelComparator.compare(o1, o2);
                return result != 0 ? result : ((MatchResult)this.val$qualifierMatchResults.get(o1)).compareTo((MatchResult)this.val$qualifierMatchResults.get(o2));
            }
        };
        ArrayList<Object> qualifierMiddleMatched = new ArrayList<Object>();
        List<Pair<String, MinusculeMatcher>> patternsAndMatchers = DefaultChooseByNameItemProvider.getPatternsAndMatchers(qualifierPattern, base);
        boolean sortedByMatchingDegree = !(base.getModel() instanceof CustomMatcherModel);
        IdFilter idFilter = null;
        if (model instanceof ContributorsBasedGotoByModel) {
            idFilter = ((ContributorsBasedGotoByModel)model).getIdFilter(everywhere);
        }
        GlobalSearchScope searchScope = FindSymbolParameters.searchScopeFor(base.myProject, everywhere);
        FindSymbolParameters parameters = new FindSymbolParameters(pattern, namePattern, searchScope, idFilter);
        boolean afterStartMatch = false;
        for (MatchResult result : namesList) {
            Object[] elements;
            indicator.checkCanceled();
            String name = result.elementName;
            boolean needSeparator = sortedByMatchingDegree && !result.startMatch && afterStartMatch;
            Object[] objectArray = elements = model instanceof ContributorsBasedGotoByModel ? ((ContributorsBasedGotoByModel)model).getElementsByName(name, parameters, indicator) : model.getElementsByName(name, everywhere, namePattern);
            if (elements.length > 1) {
                sameNameElements.clear();
                qualifierMatchResults.clear();
                for (Object element : elements) {
                    indicator.checkCanceled();
                    MatchResult qualifierResult = DefaultChooseByNameItemProvider.matchQualifier(element, base, patternsAndMatchers);
                    if (qualifierResult == null) continue;
                    sameNameElements.add(element);
                    qualifierMatchResults.put(element, qualifierResult);
                }
                Collections.sort(sameNameElements, weightComparator);
                for (Object element : sameNameElements) {
                    if (!((MatchResult)qualifierMatchResults.get(element)).startMatch) {
                        qualifierMiddleMatched.add(element);
                        continue;
                    }
                    if (needSeparator && !DefaultChooseByNameItemProvider.startMiddleMatchVariants(qualifierMiddleMatched, consumer)) {
                        return false;
                    }
                    if (!consumer.process(element)) {
                        return false;
                    }
                    needSeparator = false;
                    afterStartMatch = result.startMatch;
                }
                continue;
            }
            if (elements.length != 1 || DefaultChooseByNameItemProvider.matchQualifier(elements[0], base, patternsAndMatchers) == null) continue;
            if (needSeparator && !DefaultChooseByNameItemProvider.startMiddleMatchVariants(qualifierMiddleMatched, consumer)) {
                return false;
            }
            if (!consumer.process(elements[0])) {
                return false;
            }
            afterStartMatch = result.startMatch;
        }
        return ContainerUtil.process(qualifierMiddleMatched, consumer);
    }

    private static boolean startMiddleMatchVariants(@NotNull List<Object> qualifierMiddleMatched, @NotNull Processor<Object> consumer) {
        if (!consumer.process((Object)"non-prefix matches:")) {
            return false;
        }
        if (!ContainerUtil.process(qualifierMiddleMatched, consumer)) {
            return false;
        }
        qualifierMiddleMatched.clear();
        return true;
    }

    protected void sortNamesList(@NotNull String namePattern, @NotNull List<MatchResult> namesList) {
        Collections.sort(namesList);
    }

    @NotNull
    private static String getQualifierPattern(@NotNull ChooseByNameBase base, @NotNull String pattern) {
        pattern = base.transformPattern(pattern);
        String[] separators = base.getModel().getSeparators();
        int lastSeparatorOccurrence = 0;
        for (String separator : separators) {
            int idx = pattern.lastIndexOf(separator);
            if (idx == pattern.length() - 1) {
                idx = pattern.lastIndexOf(separator, idx - 1);
            }
            lastSeparatorOccurrence = Math.max(lastSeparatorOccurrence, idx);
        }
        return pattern.substring(0, lastSeparatorOccurrence);
    }

    @NotNull
    private static String getNamePattern(@NotNull ChooseByNameBase base, String pattern) {
        String transformedPattern = base.transformPattern(pattern);
        return DefaultChooseByNameItemProvider.getNamePattern(base.getModel(), transformedPattern);
    }

    public static String getNamePattern(ChooseByNameModel model, String pattern) {
        String[] separators = model.getSeparators();
        int lastSeparatorOccurrence = 0;
        for (String separator : separators) {
            int idx = pattern.lastIndexOf(separator);
            if (idx == pattern.length() - 1) {
                idx = pattern.lastIndexOf(separator, idx - 1);
            }
            lastSeparatorOccurrence = Math.max(lastSeparatorOccurrence, idx == -1 ? idx : idx + separator.length());
        }
        return pattern.substring(lastSeparatorOccurrence);
    }

    @NotNull
    private static List<String> split(@NotNull String s, @NotNull ChooseByNameBase base) {
        ArrayList<String> answer = new ArrayList<String>();
        for (String token : StringUtil.tokenize((String)s, (String)StringUtil.join((String[])base.getModel().getSeparators(), (String)""))) {
            if (token.isEmpty()) continue;
            answer.add(token);
        }
        return answer.isEmpty() ? Collections.singletonList(s) : answer;
    }

    private static MatchResult matchQualifier(@NotNull Object element, @NotNull ChooseByNameBase base, @NotNull List<Pair<String, MinusculeMatcher>> patternsAndMatchers) {
        String name = base.getModel().getFullName(element);
        if (name == null) {
            return null;
        }
        List<String> suspects = DefaultChooseByNameItemProvider.split(name, base);
        int matchingDegree = 0;
        int matchPosition = 0;
        boolean startMatch = true;
        block0: for (Pair<String, MinusculeMatcher> patternAndMatcher : patternsAndMatchers) {
            String pattern = (String)patternAndMatcher.first;
            MinusculeMatcher matcher = (MinusculeMatcher)patternAndMatcher.second;
            if (pattern.isEmpty()) continue;
            for (int j = matchPosition; j < suspects.size() - 1; ++j) {
                String suspect = suspects.get(j);
                MatchResult suspectMatch = DefaultChooseByNameItemProvider.matches(base, pattern, matcher, suspect);
                if (suspectMatch != null) {
                    matchingDegree += suspectMatch.matchingDegree;
                    startMatch &= suspectMatch.startMatch;
                    matchPosition = j + 1;
                    continue block0;
                }
                matchingDegree -= (j + 1) * (j + 1);
            }
            return null;
        }
        for (int j = matchPosition; j < suspects.size() - 1; ++j) {
            matchingDegree -= (j + 1) * (j + 1);
        }
        return new MatchResult(name, matchingDegree, startMatch);
    }

    @NotNull
    private static List<Pair<String, MinusculeMatcher>> getPatternsAndMatchers(@NotNull String qualifierPattern, final @NotNull ChooseByNameBase base) {
        return ContainerUtil.map2List(DefaultChooseByNameItemProvider.split(qualifierPattern, base), (Function)new Function<String, Pair<String, MinusculeMatcher>>(){

            @NotNull
            public Pair<String, MinusculeMatcher> fun(String s) {
                String namePattern = DefaultChooseByNameItemProvider.addSearchAnywherePatternDecorationIfNeeded(base, DefaultChooseByNameItemProvider.getNamePattern(base, s));
                return Pair.create((Object)namePattern, (Object)DefaultChooseByNameItemProvider.buildPatternMatcher(namePattern, NameUtil.MatchingCaseSensitivity.NONE));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public List<String> filterNames(@NotNull ChooseByNameBase base, @NotNull String[] names, @NotNull String pattern) {
        if ((pattern = DefaultChooseByNameItemProvider.convertToMatchingPattern(base, pattern)) == null) {
            return Collections.emptyList();
        }
        final ArrayList<String> filtered = new ArrayList<String>();
        DefaultChooseByNameItemProvider.processNamesByPattern(base, names, pattern, ProgressIndicatorProvider.getGlobalProgressIndicator(), new Consumer<MatchResult>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void consume(MatchResult result) {
                List list = filtered;
                synchronized (list) {
                    filtered.add(result.elementName);
                }
            }
        });
        ArrayList<String> arrayList = filtered;
        synchronized (arrayList) {
            return filtered;
        }
    }

    private static void processNamesByPattern(final @NotNull ChooseByNameBase base, @NotNull String[] names, final @NotNull String pattern, ProgressIndicator indicator, final @NotNull Consumer<MatchResult> consumer) {
        final MinusculeMatcher matcher = DefaultChooseByNameItemProvider.buildPatternMatcher(pattern, NameUtil.MatchingCaseSensitivity.NONE);
        Processor<String> processor2 = new Processor<String>(){

            public boolean process(String name) {
                ProgressManager.checkCanceled();
                MatchResult result = DefaultChooseByNameItemProvider.matches(base, pattern, matcher, name);
                if (result != null) {
                    consumer.consume((Object)result);
                }
                return true;
            }
        };
        if (!JobLauncher.getInstance().invokeConcurrentlyUnderProgress(Arrays.asList(names), indicator, false, true, processor2)) {
            throw new ProcessCanceledException();
        }
    }

    @Nullable
    private static String convertToMatchingPattern(@NotNull ChooseByNameBase base, @NotNull String pattern) {
        pattern = DefaultChooseByNameItemProvider.removeModelSpecificMarkup(base.getModel(), pattern);
        if (!base.canShowListForEmptyPattern() && pattern.isEmpty()) {
            return null;
        }
        return DefaultChooseByNameItemProvider.addSearchAnywherePatternDecorationIfNeeded(base, pattern);
    }

    @NotNull
    private static String addSearchAnywherePatternDecorationIfNeeded(@NotNull ChooseByNameBase base, @NotNull String pattern) {
        String trimmedPattern;
        if (base.isSearchInAnyPlace() && !(trimmedPattern = pattern.trim()).isEmpty() && trimmedPattern.length() > 1) {
            pattern = "*" + pattern;
        }
        return pattern;
    }

    @NotNull
    private static String removeModelSpecificMarkup(@NotNull ChooseByNameModel model, @NotNull String pattern) {
        if (model instanceof ContributorsBasedGotoByModel) {
            pattern = ((ContributorsBasedGotoByModel)model).removeModelSpecificMarkup(pattern);
        }
        return pattern;
    }

    @Nullable
    private static MatchResult matches(@NotNull ChooseByNameBase base, @NotNull String pattern, @NotNull MinusculeMatcher matcher, @Nullable String name) {
        if (name == null) {
            return null;
        }
        if (base.getModel() instanceof CustomMatcherModel) {
            try {
                return ((CustomMatcherModel)base.getModel()).matches(name, pattern) ? new MatchResult(name, 0, true) : null;
            }
            catch (Exception e) {
                LOG.info((Throwable)e);
                return null;
            }
        }
        FList fragments = matcher.matchingFragments(name);
        return fragments != null ? new MatchResult(name, matcher.matchingDegree(name, false, fragments), MinusculeMatcher.isStartMatch((Iterable)fragments)) : null;
    }

    @NotNull
    private static MinusculeMatcher buildPatternMatcher(@NotNull String pattern, @NotNull NameUtil.MatchingCaseSensitivity caseSensitivity) {
        return NameUtil.buildMatcher((String)pattern, (NameUtil.MatchingCaseSensitivity)caseSensitivity);
    }

    private static class PathProximityComparator
    implements Comparator<Object> {
        @NotNull
        private final PsiProximityComparator myProximityComparator;

        private PathProximityComparator(@Nullable PsiElement context) {
            this.myProximityComparator = new PsiProximityComparator(context);
        }

        private static boolean isCompiledWithoutSource(Object o) {
            return o instanceof PsiCompiledElement && ((PsiCompiledElement)o).getNavigationElement() == o;
        }

        @Override
        public int compare(Object o1, Object o2) {
            int rc = this.myProximityComparator.compare(o1, o2);
            if (rc != 0) {
                return rc;
            }
            int o1Weight = PathProximityComparator.isCompiledWithoutSource(o1) ? 1 : 0;
            int o2Weight = PathProximityComparator.isCompiledWithoutSource(o2) ? 1 : 0;
            return o1Weight - o2Weight;
        }
    }
}

