/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.ide.projectView.impl.nodes.ClassTreeNode;
import com.intellij.ide.util.AbstractTreeClassChooserDialog;
import com.intellij.ide.util.ClassFilter;
import com.intellij.ide.util.TreeChooser;
import com.intellij.ide.util.TreeClassChooser;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.util.Query;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TreeJavaClassChooserDialog
extends AbstractTreeClassChooserDialog<PsiClass>
implements TreeClassChooser {
    public TreeJavaClassChooserDialog(String title, Project project2) {
        super(title, project2, PsiClass.class);
    }

    public TreeJavaClassChooserDialog(String title, Project project2, @Nullable PsiClass initialClass) {
        super(title, project2, PsiClass.class, initialClass);
    }

    public TreeJavaClassChooserDialog(String title, @NotNull Project project2, GlobalSearchScope scope, ClassFilter classFilter, @Nullable PsiClass initialClass) {
        super(title, project2, scope, PsiClass.class, TreeJavaClassChooserDialog.createFilter(classFilter), initialClass);
    }

    public TreeJavaClassChooserDialog(String title, @NotNull Project project2, GlobalSearchScope scope, @Nullable ClassFilter classFilter, PsiClass baseClass, @Nullable PsiClass initialClass, boolean isShowMembers) {
        super(title, project2, scope, PsiClass.class, TreeJavaClassChooserDialog.createFilter(classFilter), baseClass, initialClass, isShowMembers, true);
    }

    public static TreeJavaClassChooserDialog withInnerClasses(String title, @NotNull Project project2, GlobalSearchScope scope, ClassFilter classFilter, @Nullable PsiClass initialClass) {
        return new TreeJavaClassChooserDialog(title, project2, scope, classFilter, null, initialClass, true);
    }

    @Nullable
    private static TreeChooser.Filter<PsiClass> createFilter(final @Nullable ClassFilter classFilter) {
        if (classFilter == null) {
            return null;
        }
        return new TreeChooser.Filter<PsiClass>(){

            public boolean isAccepted(final PsiClass element) {
                return (Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

                    public Boolean compute() {
                        return classFilter.isAccepted(element);
                    }
                });
            }
        };
    }

    @Override
    @Nullable
    protected PsiClass getSelectedFromTreeUserObject(DefaultMutableTreeNode node) {
        Object userObject = node.getUserObject();
        if (!(userObject instanceof ClassTreeNode)) {
            return null;
        }
        ClassTreeNode descriptor = (ClassTreeNode)((Object)userObject);
        return descriptor.getPsiClass();
    }

    @Override
    @NotNull
    protected List<PsiClass> getClassesByName(String name, boolean checkBoxState, String pattern, GlobalSearchScope searchScope) {
        PsiShortNamesCache cache = PsiShortNamesCache.getInstance((Project)this.getProject());
        Object[] classes = cache.getClassesByName(name, checkBoxState ? searchScope : GlobalSearchScope.projectScope((Project)this.getProject()).intersectWith(searchScope));
        return ContainerUtil.newArrayList((Object[])classes);
    }

    @Override
    @NotNull
    protected AbstractTreeClassChooserDialog.BaseClassInheritorsProvider<PsiClass> getInheritorsProvider(@NotNull PsiClass baseClass) {
        return new JavaInheritorsProvider(this.getProject(), baseClass, this.getScope());
    }

    public static class InheritanceJavaClassFilterImpl
    implements ClassFilter {
        private final PsiClass myBase;
        private final boolean myAcceptsSelf;
        private final boolean myAcceptsInner;
        @NotNull
        private final Condition<? super PsiClass> myAdditionalCondition;

        public InheritanceJavaClassFilterImpl(PsiClass base, boolean acceptsSelf, boolean acceptInner, @Nullable Condition<? super PsiClass> additionalCondition) {
            this.myAcceptsSelf = acceptsSelf;
            this.myAcceptsInner = acceptInner;
            if (additionalCondition == null) {
                additionalCondition = Conditions.alwaysTrue();
            }
            this.myAdditionalCondition = additionalCondition;
            this.myBase = base;
        }

        public boolean isAccepted(PsiClass aClass) {
            if (!this.myAcceptsInner && !(aClass.getParent() instanceof PsiJavaFile)) {
                return false;
            }
            if (!this.myAdditionalCondition.value((Object)aClass)) {
                return false;
            }
            return this.myAcceptsSelf || !aClass.getManager().areElementsEquivalent((PsiElement)aClass, (PsiElement)this.myBase);
        }
    }

    private static class JavaInheritorsProvider
    extends AbstractTreeClassChooserDialog.BaseClassInheritorsProvider<PsiClass> {
        private final Project myProject;

        public JavaInheritorsProvider(Project project2, PsiClass baseClass, GlobalSearchScope scope) {
            super(baseClass, scope);
            this.myProject = project2;
        }

        @Override
        @NotNull
        protected Query<PsiClass> searchForInheritors(PsiClass baseClass, GlobalSearchScope searchScope, boolean checkDeep) {
            return ClassInheritorsSearch.search((PsiClass)baseClass, (SearchScope)searchScope, (boolean)checkDeep);
        }

        @Override
        protected boolean isInheritor(PsiClass clazz, PsiClass baseClass, boolean checkDeep) {
            return clazz.isInheritor(baseClass, checkDeep);
        }

        @Override
        protected String[] getNames() {
            return PsiShortNamesCache.getInstance((Project)this.myProject).getAllClassNames();
        }
    }
}

