/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.ide.structureView.StructureViewModel;
import com.intellij.ide.structureView.StructureViewModelBase;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.structureView.impl.StructureViewComposite;
import com.intellij.ide.util.treeView.smartTree.Filter;
import com.intellij.ide.util.treeView.smartTree.NodeProvider;
import com.intellij.ide.util.treeView.smartTree.ProvidingTreeModel;
import com.intellij.ide.util.treeView.smartTree.TreeElement;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.Disposable;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StructureViewCompositeModel
extends StructureViewModelBase
implements Disposable {
    private final StructureViewComposite.StructureViewDescriptor[] myViews;

    public StructureViewCompositeModel(PsiFile file2, StructureViewComposite.StructureViewDescriptor[] views) {
        super(file2, StructureViewCompositeModel.createRootNode(file2, views));
        this.myViews = views;
    }

    private static StructureViewTreeElement createRootNode(final PsiFile file2, final StructureViewComposite.StructureViewDescriptor[] views) {
        return new StructureViewTreeElement(){

            public Object getValue() {
                return file2;
            }

            public void navigate(boolean requestFocus) {
                file2.navigate(requestFocus);
            }

            public boolean canNavigate() {
                return file2.canNavigate();
            }

            public boolean canNavigateToSource() {
                return file2.canNavigateToSource();
            }

            @NotNull
            public ItemPresentation getPresentation() {
                return file2.getPresentation();
            }

            @NotNull
            public TreeElement[] getChildren() {
                ArrayList<TreeElement> elements = new ArrayList<TreeElement>();
                for (StructureViewComposite.StructureViewDescriptor view : views) {
                    elements.add(StructureViewCompositeModel.createTreeElementFromView(file2, view));
                }
                return elements.toArray(new TreeElement[elements.size()]);
            }
        };
    }

    @NotNull
    public Collection<NodeProvider> getNodeProviders() {
        HashSet<NodeProvider> providers = new HashSet<NodeProvider>();
        for (StructureViewComposite.StructureViewDescriptor view : this.myViews) {
            StructureViewModel model = view.structureView.getTreeModel();
            if (!(model instanceof ProvidingTreeModel)) continue;
            providers.addAll(((ProvidingTreeModel)model).getNodeProviders());
        }
        return providers;
    }

    @NotNull
    public Filter[] getFilters() {
        HashSet<Filter> filters = new HashSet<Filter>();
        for (StructureViewComposite.StructureViewDescriptor view : this.myViews) {
            StructureViewModel model = view.structureView.getTreeModel();
            filters.addAll(Arrays.asList(model.getFilters()));
        }
        return filters.toArray(new Filter[filters.size()]);
    }

    private static TreeElement createTreeElementFromView(final PsiFile file2, final StructureViewComposite.StructureViewDescriptor view) {
        return new StructureViewTreeElement(){

            public Object getValue() {
                return view;
            }

            public void navigate(boolean requestFocus) {
                file2.navigate(requestFocus);
            }

            public boolean canNavigate() {
                return file2.canNavigate();
            }

            public boolean canNavigateToSource() {
                return file2.canNavigateToSource();
            }

            @NotNull
            public ItemPresentation getPresentation() {
                return new ItemPresentation(){

                    @Nullable
                    public String getPresentableText() {
                        return view.title;
                    }

                    @Nullable
                    public String getLocationString() {
                        return null;
                    }

                    @Nullable
                    public Icon getIcon(boolean unused) {
                        return view.icon;
                    }
                };
            }

            @NotNull
            public TreeElement[] getChildren() {
                return view.structureView.getTreeModel().getRoot().getChildren();
            }
        };
    }
}

