/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.util.text.StringUtil;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PropertiesComponentImpl
extends PropertiesComponent
implements PersistentStateComponent<Element> {
    private final Map<String, String> myMap = new LinkedHashMap<String, String>();
    @NonNls
    private static final String ELEMENT_PROPERTY = "property";
    @NonNls
    private static final String ATTRIBUTE_NAME = "name";
    @NonNls
    private static final String ATTRIBUTE_VALUE = "value";

    @NotNull
    public String getComponentName() {
        return "PropertiesComponent";
    }

    PropertiesComponentImpl() {
    }

    @Deprecated
    public static PropertiesComponentImpl create() {
        return new PropertiesComponentImpl();
    }

    public Element getState() {
        Element parentNode = new Element("state");
        for (String key : this.myMap.keySet()) {
            String value = this.myMap.get(key);
            if (value == null) continue;
            Element element = new Element(ELEMENT_PROPERTY);
            element.setAttribute(ATTRIBUTE_NAME, key);
            element.setAttribute(ATTRIBUTE_VALUE, value);
            parentNode.addContent(element);
        }
        return parentNode;
    }

    public void loadState(Element parentNode) {
        this.myMap.clear();
        for (Element e : parentNode.getChildren(ELEMENT_PROPERTY)) {
            String name = e.getAttributeValue(ATTRIBUTE_NAME);
            if (name == null) continue;
            this.myMap.put(name, e.getAttributeValue(ATTRIBUTE_VALUE));
        }
    }

    public String getValue(String name) {
        return this.myMap.get(name);
    }

    public void setValue(@NotNull String name, @Nullable String value) {
        if (value == null) {
            this.myMap.remove(name);
        } else {
            this.myMap.put(name, value);
        }
    }

    public void setValue(@NotNull String name, @Nullable String value, @Nullable String defaultValue) {
        if (value == null || value.equals(defaultValue)) {
            this.myMap.remove(name);
        } else {
            this.myMap.put(name, value);
        }
    }

    public void setValue(@NotNull String name, float value, float defaultValue) {
        if (value == defaultValue) {
            this.myMap.remove(name);
        } else {
            this.myMap.put(name, String.valueOf(value));
        }
    }

    public void setValue(@NotNull String name, int value, int defaultValue) {
        if (value == defaultValue) {
            this.myMap.remove(name);
        } else {
            this.myMap.put(name, String.valueOf(value));
        }
    }

    public void setValue(@NotNull String name, boolean value, boolean defaultValue) {
        if (value == defaultValue) {
            this.myMap.remove(name);
        } else {
            this.setValue(name, String.valueOf(value));
        }
    }

    public void unsetValue(String name) {
        this.myMap.remove(name);
    }

    public boolean isValueSet(String name) {
        return this.myMap.containsKey(name);
    }

    @Nullable
    public String[] getValues(@NonNls String name) {
        String value = this.getValue(name);
        return value != null ? value.split("\n") : null;
    }

    public void setValues(@NonNls String name, String[] values) {
        if (values == null) {
            this.setValue(name, null);
        } else {
            this.setValue(name, StringUtil.join((String[])values, (String)"\n"));
        }
    }
}

