/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.CommonBundle;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.PackageUtil;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileChooser.ex.TextFieldAction;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.FileIndex;
import com.intellij.openapi.roots.ModuleFileIndex;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.PackageChooser;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPackage;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.JavaReferenceEditorUtil;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.Alarm;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.Convertor;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;

public class PackageChooserDialog
extends PackageChooser {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.util.PackageChooserDialog");
    private Tree myTree;
    private DefaultTreeModel myModel;
    private final Project myProject;
    private final String myTitle;
    private Module myModule;
    private EditorTextField myPathEditor;
    private final Alarm myAlarm = new Alarm(this.getDisposable());

    public PackageChooserDialog(String title, @NotNull Module module2) {
        super(module2.getProject(), true);
        this.setTitle(title);
        this.myTitle = title;
        this.myProject = module2.getProject();
        this.myModule = module2;
        this.init();
    }

    public PackageChooserDialog(String title, Project project2) {
        super(project2, true);
        this.setTitle(title);
        this.myTitle = title;
        this.myProject = project2;
        this.init();
    }

    protected JComponent createCenterPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        this.myModel = new DefaultTreeModel(new DefaultMutableTreeNode());
        this.createTreeModel();
        this.myTree = new Tree((TreeModel)this.myModel);
        UIUtil.setLineStyleAngled((JTree)this.myTree);
        this.myTree.setCellRenderer((TreeCellRenderer)new DefaultTreeCellRenderer(){

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                DefaultMutableTreeNode node;
                Object object;
                super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
                this.setIcon(PlatformIcons.PACKAGE_ICON);
                if (value instanceof DefaultMutableTreeNode && (object = (node = (DefaultMutableTreeNode)value).getUserObject()) instanceof PsiPackage) {
                    String name = ((PsiPackage)object).getName();
                    if (name != null && name.length() > 0) {
                        this.setText(name);
                    } else {
                        this.setText(IdeBundle.message((String)"node.default", (Object[])new Object[0]));
                    }
                }
                return this;
            }
        });
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)this.myTree);
        scrollPane.setPreferredSize((Dimension)JBUI.size((int)500, (int)300));
        new TreeSpeedSearch(this.myTree, new Convertor<TreePath, String>(){

            public String convert(TreePath path) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
                Object object = node.getUserObject();
                if (object instanceof PsiPackage) {
                    return ((PsiPackage)object).getName();
                }
                return "";
            }
        });
        this.myTree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                PsiPackage selection = PackageChooserDialog.this.getTreeSelection();
                if (selection != null) {
                    String name = selection.getQualifiedName();
                    PackageChooserDialog.this.setTitle(PackageChooserDialog.this.myTitle + " - " + ("".equals(name) ? IdeBundle.message((String)"node.default.package", (Object[])new Object[0]) : name));
                } else {
                    PackageChooserDialog.this.setTitle(PackageChooserDialog.this.myTitle);
                }
                PackageChooserDialog.this.updatePathFromTree();
            }
        });
        panel.add((Component)scrollPane, "Center");
        DefaultActionGroup group = this.createActionGroup((JComponent)this.myTree);
        JPanel northPanel = new JPanel(new BorderLayout());
        panel.add((Component)northPanel, "North");
        ActionToolbar toolBar = ActionManager.getInstance().createActionToolbar("unknown", (ActionGroup)group, true);
        northPanel.add((Component)toolBar.getComponent(), "West");
        this.setupPathComponent(northPanel);
        return panel;
    }

    private void setupPathComponent(final JPanel northPanel) {
        northPanel.add((Component)((Object)new TextFieldAction(){

            public void linkSelected(LinkLabel aSource, Object aLinkData) {
                PackageChooserDialog.this.toggleShowPathComponent(northPanel, this);
            }
        }), "East");
        this.myPathEditor = new EditorTextField(JavaReferenceEditorUtil.createDocument("", this.myProject, false), this.myProject, (FileType)StdFileTypes.JAVA);
        this.myPathEditor.addDocumentListener((DocumentListener)new DocumentAdapter(){

            public void documentChanged(DocumentEvent e) {
                PackageChooserDialog.this.myAlarm.cancelAllRequests();
                PackageChooserDialog.this.myAlarm.addRequest(new Runnable(){

                    @Override
                    public void run() {
                        PackageChooserDialog.this.updateTreeFromPath();
                    }
                }, 300);
            }
        });
        this.myPathEditor.setBorder(BorderFactory.createEmptyBorder(0, 0, 2, 0));
        northPanel.add((Component)((Object)this.myPathEditor), "South");
    }

    private void toggleShowPathComponent(JPanel northPanel, TextFieldAction fieldAction) {
        boolean toShowTextField = !PackageChooserDialog.isPathShowing();
        PropertiesComponent.getInstance().setValue("FileChooser.ShowPath", toShowTextField, true);
        this.myPathEditor.setVisible(toShowTextField);
        fieldAction.update();
        northPanel.revalidate();
        northPanel.repaint();
        this.updatePathFromTree();
    }

    private static boolean isPathShowing() {
        return PropertiesComponent.getInstance().getBoolean("FileChooser.ShowPath", true);
    }

    private void updatePathFromTree() {
        if (!PackageChooserDialog.isPathShowing()) {
            return;
        }
        PsiPackage selection = this.getTreeSelection();
        this.myPathEditor.setText(selection != null ? selection.getQualifiedName() : "");
    }

    private void updateTreeFromPath() {
        this.selectPackage(this.myPathEditor.getText().trim());
    }

    private DefaultActionGroup createActionGroup(JComponent component) {
        DefaultActionGroup group = new DefaultActionGroup();
        DefaultActionGroup temp = new DefaultActionGroup();
        NewPackageAction newPackageAction = new NewPackageAction();
        newPackageAction.enableInModalConext();
        newPackageAction.registerCustomShortcutSet(ActionManager.getInstance().getAction("NewElement").getShortcutSet(), component);
        temp.add((AnAction)newPackageAction);
        group.add((AnAction)temp);
        return group;
    }

    protected void doOKAction() {
        super.doOKAction();
    }

    public String getDimensionServiceKey() {
        return "#com.intellij.ide.util.PackageChooserDialog";
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myTree;
    }

    public PsiPackage getSelectedPackage() {
        return this.getTreeSelection();
    }

    public List<PsiPackage> getSelectedPackages() {
        return TreeUtil.collectSelectedObjectsOfType((JTree)this.myTree, PsiPackage.class);
    }

    public void selectPackage(String qualifiedName) {
        DefaultMutableTreeNode node = this.findNodeForPackage(qualifiedName);
        if (node != null) {
            TreePath path = new TreePath(node.getPath());
            TreeUtil.selectPath((JTree)this.myTree, (TreePath)path);
        }
    }

    @Nullable
    private PsiPackage getTreeSelection() {
        if (this.myTree == null) {
            return null;
        }
        TreePath path = this.myTree.getSelectionPath();
        if (path == null) {
            return null;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
        return (PsiPackage)node.getUserObject();
    }

    private void createTreeModel() {
        PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
        ModuleFileIndex fileIndex = this.myModule != null ? ModuleRootManager.getInstance((Module)this.myModule).getFileIndex() : ProjectRootManager.getInstance((Project)this.myProject).getFileIndex();
        fileIndex.iterateContent(new ContentIterator((FileIndex)fileIndex, psiManager){
            final /* synthetic */ FileIndex val$fileIndex;
            final /* synthetic */ PsiManager val$psiManager;
            {
                this.val$fileIndex = fileIndex;
                this.val$psiManager = psiManager;
            }

            public boolean processFile(VirtualFile fileOrDir) {
                if (fileOrDir.isDirectory() && this.val$fileIndex.isUnderSourceRootOfType(fileOrDir, JavaModuleSourceRootTypes.SOURCES)) {
                    PsiDirectory psiDirectory = this.val$psiManager.findDirectory(fileOrDir);
                    LOG.assertTrue(psiDirectory != null);
                    PsiPackage aPackage = JavaDirectoryService.getInstance().getPackage(psiDirectory);
                    if (aPackage != null) {
                        PackageChooserDialog.this.addPackage(aPackage);
                    }
                }
                return true;
            }
        });
        TreeUtil.sort((DefaultTreeModel)this.myModel, (Comparator)new Comparator(){

            public int compare(Object o1, Object o2) {
                DefaultMutableTreeNode n1 = (DefaultMutableTreeNode)o1;
                DefaultMutableTreeNode n2 = (DefaultMutableTreeNode)o2;
                PsiNamedElement element1 = (PsiNamedElement)n1.getUserObject();
                PsiNamedElement element2 = (PsiNamedElement)n2.getUserObject();
                return element1.getName().compareToIgnoreCase(element2.getName());
            }
        });
    }

    @NotNull
    private DefaultMutableTreeNode addPackage(PsiPackage aPackage) {
        String qualifiedPackageName = aPackage.getQualifiedName();
        PsiPackage parentPackage = aPackage.getParentPackage();
        if (parentPackage == null) {
            DefaultMutableTreeNode rootNode = (DefaultMutableTreeNode)this.myModel.getRoot();
            if (qualifiedPackageName.length() == 0) {
                rootNode.setUserObject(aPackage);
                return rootNode;
            }
            DefaultMutableTreeNode packageNode = PackageChooserDialog.findPackageNode(rootNode, qualifiedPackageName);
            if (packageNode != null) {
                return packageNode;
            }
            packageNode = new DefaultMutableTreeNode(aPackage);
            rootNode.add(packageNode);
            return packageNode;
        }
        DefaultMutableTreeNode parentNode = this.addPackage(parentPackage);
        DefaultMutableTreeNode packageNode = PackageChooserDialog.findPackageNode(parentNode, qualifiedPackageName);
        if (packageNode != null) {
            return packageNode;
        }
        packageNode = new DefaultMutableTreeNode(aPackage);
        parentNode.add(packageNode);
        return packageNode;
    }

    @Nullable
    private static DefaultMutableTreeNode findPackageNode(DefaultMutableTreeNode rootNode, String qualifiedName) {
        for (int i = 0; i < rootNode.getChildCount(); ++i) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)rootNode.getChildAt(i);
            PsiPackage nodePackage = (PsiPackage)child.getUserObject();
            if (nodePackage == null || !Comparing.equal((String)nodePackage.getQualifiedName(), (String)qualifiedName)) continue;
            return child;
        }
        return null;
    }

    private DefaultMutableTreeNode findNodeForPackage(String qualifiedPackageName) {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.myModel.getRoot();
        Enumeration<TreeNode> enumeration = root.depthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode node;
            PsiPackage nodePackage;
            TreeNode o = enumeration.nextElement();
            if (!(o instanceof DefaultMutableTreeNode) || (nodePackage = (PsiPackage)(node = (DefaultMutableTreeNode)o).getUserObject()) == null || !Comparing.equal((String)nodePackage.getQualifiedName(), (String)qualifiedPackageName)) continue;
            return node;
        }
        return null;
    }

    private void createNewPackage() {
        final PsiPackage selectedPackage = this.getTreeSelection();
        if (selectedPackage == null) {
            return;
        }
        final String newPackageName = Messages.showInputDialog((Project)this.myProject, (String)IdeBundle.message((String)"prompt.enter.a.new.package.name", (Object[])new Object[0]), (String)IdeBundle.message((String)"title.new.package", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon(), (String)"", (InputValidator)new InputValidator(){

            public boolean checkInput(String inputString) {
                return inputString != null && inputString.length() > 0;
            }

            public boolean canClose(String inputString) {
                return this.checkInput(inputString);
            }
        });
        if (newPackageName == null) {
            return;
        }
        CommandProcessor.getInstance().executeCommand(this.myProject, new Runnable(){

            @Override
            public void run() {
                Runnable action = new Runnable(){

                    @Override
                    public void run() {
                        block4: {
                            try {
                                String newQualifiedName = selectedPackage.getQualifiedName();
                                if (!Comparing.strEqual((String)newQualifiedName, (String)"")) {
                                    newQualifiedName = newQualifiedName + ".";
                                }
                                newQualifiedName = newQualifiedName + newPackageName;
                                PsiDirectory dir = PackageUtil.findOrCreateDirectoryForPackage(PackageChooserDialog.this.myProject, newQualifiedName, null, false);
                                if (dir == null) {
                                    return;
                                }
                                PsiPackage newPackage = JavaDirectoryService.getInstance().getPackage(dir);
                                DefaultMutableTreeNode node = (DefaultMutableTreeNode)PackageChooserDialog.this.myTree.getSelectionPath().getLastPathComponent();
                                DefaultMutableTreeNode newChild = new DefaultMutableTreeNode();
                                newChild.setUserObject(newPackage);
                                node.add(newChild);
                                DefaultTreeModel model = (DefaultTreeModel)PackageChooserDialog.this.myTree.getModel();
                                model.nodeStructureChanged(node);
                                TreePath selectionPath = PackageChooserDialog.this.myTree.getSelectionPath();
                                TreePath path = selectionPath == null ? new TreePath(newChild.getPath()) : selectionPath.pathByAddingChild(newChild);
                                PackageChooserDialog.this.myTree.setSelectionPath(path);
                                PackageChooserDialog.this.myTree.scrollPathToVisible(path);
                                PackageChooserDialog.this.myTree.expandPath(path);
                            }
                            catch (IncorrectOperationException e) {
                                Messages.showMessageDialog((Component)PackageChooserDialog.this.getContentPane(), (String)StringUtil.getMessage((Throwable)e), (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
                                if (!LOG.isDebugEnabled()) break block4;
                                LOG.debug((Throwable)e);
                            }
                        }
                    }
                };
                ApplicationManager.getApplication().runReadAction(action);
            }
        }, IdeBundle.message((String)"command.create.new.package", (Object[])new Object[0]), null);
    }

    private class NewPackageAction
    extends AnAction {
        public NewPackageAction() {
            super(IdeBundle.message((String)"action.new.package", (Object[])new Object[0]), IdeBundle.message((String)"action.description.create.new.package", (Object[])new Object[0]), AllIcons.Actions.NewFolder);
        }

        public void actionPerformed(AnActionEvent e) {
            PackageChooserDialog.this.createNewPackage();
        }

        public void update(AnActionEvent event) {
            Presentation presentation = event.getPresentation();
            presentation.setEnabled(PackageChooserDialog.this.getTreeSelection() != null);
        }

        public void enableInModalConext() {
            this.setEnabledInModalContext(true);
        }
    }
}

