/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.ide.IdeBundle;
import com.intellij.lang.findUsages.FindUsagesProvider;
import com.intellij.lang.findUsages.LanguageFindUsages;
import com.intellij.psi.ElementDescriptionLocation;
import com.intellij.psi.ElementDescriptionProvider;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.util.PsiUtilBase;
import org.jetbrains.annotations.NotNull;

public class DeleteTypeDescriptionLocation
extends ElementDescriptionLocation {
    private final boolean myPlural;
    public static final DeleteTypeDescriptionLocation SINGULAR = new DeleteTypeDescriptionLocation(false);
    public static final DeleteTypeDescriptionLocation PLURAL = new DeleteTypeDescriptionLocation(true);
    private static final ElementDescriptionProvider ourDefaultProvider = new DefaultProvider();

    private DeleteTypeDescriptionLocation(boolean plural) {
        this.myPlural = plural;
    }

    public ElementDescriptionProvider getDefaultProvider() {
        return ourDefaultProvider;
    }

    public boolean isPlural() {
        return this.myPlural;
    }

    public static class DefaultProvider
    implements ElementDescriptionProvider {
        public String getElementDescription(@NotNull PsiElement element, @NotNull ElementDescriptionLocation location) {
            if (location instanceof DeleteTypeDescriptionLocation) {
                int count;
                boolean plural = ((DeleteTypeDescriptionLocation)location).isPlural();
                int n = count = plural ? 2 : 1;
                if (element instanceof PsiFileSystemItem && PsiUtilBase.isSymLink((PsiFileSystemItem)((PsiFileSystemItem)element))) {
                    return IdeBundle.message((String)"prompt.delete.symlink", (Object[])new Object[]{count});
                }
                if (element instanceof PsiFile) {
                    return IdeBundle.message((String)"prompt.delete.file", (Object[])new Object[]{count});
                }
                if (element instanceof PsiDirectory) {
                    return IdeBundle.message((String)"prompt.delete.directory", (Object[])new Object[]{count});
                }
                if (!plural) {
                    return ((FindUsagesProvider)LanguageFindUsages.INSTANCE.forLanguage(element.getLanguage())).getType(element);
                }
                return "elements";
            }
            return null;
        }
    }
}

