/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.todo.nodes;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.PackageElement;
import com.intellij.ide.projectView.impl.nodes.PackageElementNode;
import com.intellij.ide.todo.HighlightedRegionProvider;
import com.intellij.ide.todo.TodoFileDirAndModuleComparator;
import com.intellij.ide.todo.TodoTreeBuilder;
import com.intellij.ide.todo.TodoTreeStructure;
import com.intellij.ide.todo.nodes.TodoFileNode;
import com.intellij.ide.todo.nodes.TodoJavaTreeHelper;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.HighlightedRegion;
import com.intellij.usageView.UsageTreeColors;
import com.intellij.usageView.UsageTreeColorsScheme;
import com.intellij.util.ArrayUtil;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TodoPackageNode
extends PackageElementNode
implements HighlightedRegionProvider {
    private final ArrayList<HighlightedRegion> myHighlightedRegions;
    private final TodoTreeBuilder myBuilder;
    @Nullable
    private final String myPresentationName;

    public TodoPackageNode(@NotNull Project project2, PackageElement element, TodoTreeBuilder builder) {
        this(project2, element, builder, null);
    }

    public TodoPackageNode(@NotNull Project project2, PackageElement element, TodoTreeBuilder builder, @Nullable String name) {
        super(project2, element, ViewSettings.DEFAULT);
        this.myBuilder = builder;
        this.myHighlightedRegions = new ArrayList(2);
        if (element != null && name == null) {
            PsiPackage aPackage = element.getPackage();
            this.myPresentationName = aPackage.getName();
        } else {
            this.myPresentationName = name;
        }
    }

    public ArrayList<HighlightedRegion> getHighlightedRegions() {
        return this.myHighlightedRegions;
    }

    @Override
    protected void update(PresentationData data) {
        super.update(data);
        PackageElement packageElement = (PackageElement)this.getValue();
        try {
            if (packageElement == null || !packageElement.getPackage().isValid()) {
                this.setValue(null);
                return;
            }
            int fileCount = this.getFileCount(packageElement);
            if (fileCount == 0) {
                this.setValue(null);
                return;
            }
            PsiPackage aPackage = packageElement.getPackage();
            String newName = this.getStructure().areFlattenPackages() ? aPackage.getQualifiedName() : (this.myPresentationName != null ? this.myPresentationName : "");
            int nameEndOffset = newName.length();
            int todoItemCount = this.getTodoItemCount(packageElement);
            newName = IdeBundle.message((String)"node.todo.group", (Object[])new Object[]{newName, todoItemCount, fileCount});
            this.myHighlightedRegions.clear();
            TextAttributes textAttributes = new TextAttributes();
            Color newColor = null;
            if (CopyPasteManager.getInstance().isCutElement((Object)packageElement)) {
                newColor = CopyPasteManager.CUT_COLOR;
            }
            textAttributes.setForegroundColor(newColor);
            this.myHighlightedRegions.add(new HighlightedRegion(0, nameEndOffset, textAttributes));
            EditorColorsScheme colorsScheme = UsageTreeColorsScheme.getInstance().getScheme();
            this.myHighlightedRegions.add(new HighlightedRegion(nameEndOffset, newName.length(), colorsScheme.getAttributes(UsageTreeColors.NUMBER_OF_USAGES)));
            data.setPresentableText(newName);
        }
        catch (IndexNotReadyException e) {
            LOG.info((Throwable)e);
            data.setPresentableText("N/A");
        }
    }

    public void apply(@NotNull Map<String, String> info) {
        info.put("toDoFileCount", String.valueOf(this.getFileCount((PackageElement)this.getValue())));
        info.put("toDoItemCount", String.valueOf(this.getTodoItemCount((PackageElement)this.getValue())));
    }

    private int getFileCount(PackageElement packageElement) {
        int count = 0;
        if (this.getSettings().isFlattenPackages()) {
            PsiDirectory[] directories;
            PsiPackage aPackage = packageElement.getPackage();
            Module module2 = packageElement.getModule();
            GlobalSearchScope scope = module2 != null ? GlobalSearchScope.moduleScope((Module)module2) : GlobalSearchScope.projectScope((Project)aPackage.getProject());
            for (PsiDirectory directory : directories = aPackage.getDirectories(scope)) {
                Iterator<PsiFile> iterator = this.myBuilder.getFilesUnderDirectory(directory);
                while (iterator.hasNext()) {
                    PsiFile psiFile = iterator.next();
                    if (!this.getStructure().accept(psiFile)) continue;
                    ++count;
                }
            }
        } else {
            Iterator<PsiFile> iterator = this.getFiles(packageElement);
            while (iterator.hasNext()) {
                PsiFile psiFile = iterator.next();
                if (!this.getStructure().accept(psiFile)) continue;
                ++count;
            }
        }
        return count;
    }

    public int getTodoItemCount(PackageElement packageElement) {
        int count = 0;
        if (this.getSettings().isFlattenPackages()) {
            PsiDirectory[] directories;
            PsiPackage aPackage = packageElement.getPackage();
            Module module2 = packageElement.getModule();
            GlobalSearchScope scope = module2 != null ? GlobalSearchScope.moduleScope((Module)module2) : GlobalSearchScope.projectScope((Project)aPackage.getProject());
            for (PsiDirectory directory : directories = aPackage.getDirectories(scope)) {
                Iterator<PsiFile> iterator = this.myBuilder.getFilesUnderDirectory(directory);
                while (iterator.hasNext()) {
                    PsiFile psiFile = iterator.next();
                    count += this.getStructure().getTodoItemCount(psiFile);
                }
            }
        } else {
            Iterator<PsiFile> iterator = this.getFiles(packageElement);
            while (iterator.hasNext()) {
                PsiFile psiFile = iterator.next();
                count += this.getStructure().getTodoItemCount(psiFile);
            }
        }
        return count;
    }

    private TodoTreeStructure getStructure() {
        return this.myBuilder.getTodoTreeStructure();
    }

    @Override
    @NotNull
    public Collection<AbstractTreeNode> getChildren() {
        ArrayList<AbstractTreeNode> children2 = new ArrayList<AbstractTreeNode>();
        Project project2 = this.getProject();
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)project2).getFileIndex();
        PsiPackage psiPackage = ((PackageElement)this.getValue()).getPackage();
        Module module2 = ((PackageElement)this.getValue()).getModule();
        if (!this.getStructure().getIsFlattenPackages() || psiPackage == null) {
            Iterator<PsiFile> iterator = this.getFiles((PackageElement)this.getValue());
            block0: while (iterator.hasNext()) {
                PsiFile psiFile = iterator.next();
                Module psiFileModule = projectFileIndex.getModuleForFile(psiFile.getVirtualFile());
                if (module2 != null && psiFileModule != null && !module2.equals(psiFileModule)) continue;
                PsiDirectory containingDirectory = psiFile.getContainingDirectory();
                TodoFileNode todoFileNode = new TodoFileNode(project2, psiFile, this.myBuilder, false);
                if (ArrayUtil.find((Object[])psiPackage.getDirectories(), (Object)containingDirectory) > -1 && !children2.contains(todoFileNode)) {
                    children2.add((AbstractTreeNode)todoFileNode);
                    continue;
                }
                PsiDirectory _dir = psiFile.getContainingDirectory();
                while (_dir != null) {
                    String name;
                    GlobalSearchScope scope;
                    TodoPackageNode todoPackageNode;
                    PsiPackage _package;
                    PsiDirectory parentDirectory = _dir.getParentDirectory();
                    if (parentDirectory != null && (_package = JavaDirectoryService.getInstance().getPackage(_dir)) != null && _package.getParentPackage() != null && psiPackage.equals(_package.getParentPackage()) && !children2.contains(todoPackageNode = new TodoPackageNode(project2, new PackageElement(module2, _package = TodoJavaTreeHelper.findNonEmptyPackage(_package, module2, project2, this.myBuilder, scope = module2 != null ? GlobalSearchScope.moduleScope((Module)module2) : GlobalSearchScope.projectScope((Project)project2)), false), this.myBuilder, name = _package.getParentPackage().equals(psiPackage) ? null : _package.getQualifiedName().substring(psiPackage.getQualifiedName().length() + 1)))) {
                        children2.add((AbstractTreeNode)todoPackageNode);
                        continue block0;
                    }
                    _dir = parentDirectory;
                }
            }
        } else {
            Iterator<PsiFile> iterator = this.getFiles((PackageElement)this.getValue());
            while (iterator.hasNext()) {
                PsiFile psiFile = iterator.next();
                Module psiFileModule = projectFileIndex.getModuleForFile(psiFile.getVirtualFile());
                if (module2 != null && psiFileModule != null && !module2.equals(psiFileModule)) continue;
                PsiDirectory _dir = psiFile.getContainingDirectory();
                TodoFileNode todoFileNode = new TodoFileNode(this.getProject(), psiFile, this.myBuilder, false);
                if (ArrayUtil.find((Object[])psiPackage.getDirectories(), (Object)_dir) <= -1 || children2.contains(todoFileNode)) continue;
                children2.add((AbstractTreeNode)todoFileNode);
            }
        }
        Collections.sort(children2, TodoFileDirAndModuleComparator.INSTANCE);
        return children2;
    }

    public Iterator<PsiFile> getFiles(PackageElement packageElement) {
        PsiDirectory[] directories;
        ArrayList<PsiFile> psiFileList = new ArrayList<PsiFile>();
        GlobalSearchScope scope = packageElement.getModule() != null ? GlobalSearchScope.moduleScope((Module)packageElement.getModule()) : GlobalSearchScope.projectScope((Project)this.myProject);
        for (PsiDirectory directory : directories = packageElement.getPackage().getDirectories(scope)) {
            Iterator<PsiFile> files = this.myBuilder.getFiles(directory, false);
            while (files.hasNext()) {
                psiFileList.add(files.next());
            }
        }
        return psiFileList.iterator();
    }

    @Override
    public int getWeight() {
        return 3;
    }
}

