/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.todo;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.PsiTodoSearchHelper;
import com.intellij.psi.search.TodoPattern;
import com.intellij.util.ArrayUtilRt;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class TodoFilter
implements Cloneable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.todo.TodoFilter");
    private String myName;
    private HashSet<TodoPattern> myTodoPatterns;
    @NonNls
    private static final String ATTRIBUTE_NAME = "name";
    @NonNls
    private static final String ELEMENT_PATTERN = "pattern";
    @NonNls
    private static final String ATTRIBUTE_INDEX = "index";

    public TodoFilter() {
        this.setName("");
        this.myTodoPatterns = new HashSet(1);
    }

    public boolean accept(PsiTodoSearchHelper searchHelper, PsiFile psiFile) {
        Iterator<TodoPattern> i = this.iterator();
        while (i.hasNext()) {
            TodoPattern todoPattern = i.next();
            if (searchHelper.getTodoItemsCount(psiFile, todoPattern) <= 0) continue;
            return true;
        }
        return false;
    }

    public String getName() {
        return this.myName;
    }

    public void setName(@NotNull String name) {
        this.myName = name;
    }

    public boolean contains(TodoPattern pattern) {
        return this.myTodoPatterns.contains(pattern);
    }

    public void addTodoPattern(TodoPattern pattern) {
        LOG.assertTrue(!this.myTodoPatterns.contains(pattern));
        this.myTodoPatterns.add(pattern);
    }

    public void removeTodoPattern(TodoPattern pattern) {
        LOG.assertTrue(this.myTodoPatterns.contains(pattern));
        this.myTodoPatterns.remove(pattern);
    }

    public Iterator<TodoPattern> iterator() {
        return this.myTodoPatterns.iterator();
    }

    public boolean isEmpty() {
        return this.myTodoPatterns.isEmpty();
    }

    public void readExternal(Element element, @NotNull List<TodoPattern> patterns) {
        this.myName = element.getAttributeValue(ATTRIBUTE_NAME);
        if (this.myName == null) {
            throw new IllegalArgumentException();
        }
        this.myTodoPatterns.clear();
        for (Element child : element.getChildren()) {
            if (!ELEMENT_PATTERN.equals(child.getName())) continue;
            try {
                TodoPattern pattern;
                int index = Integer.parseInt(child.getAttributeValue(ATTRIBUTE_INDEX));
                if (index < 0 || index > patterns.size() - 1 || this.myTodoPatterns.contains(pattern = patterns.get(index))) continue;
                this.myTodoPatterns.add(pattern);
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    public void writeExternal(Element element, TodoPattern[] patterns) {
        element.setAttribute(ATTRIBUTE_NAME, this.myName);
        for (TodoPattern pattern : this.myTodoPatterns) {
            int index = ArrayUtilRt.find((Object[])patterns, (Object)pattern);
            LOG.assertTrue(index != -1);
            Element child = new Element(ELEMENT_PATTERN);
            child.setAttribute(ATTRIBUTE_INDEX, Integer.toString(index));
            element.addContent(child);
        }
    }

    public int hashCode() {
        int hashCode = this.myName.hashCode();
        for (TodoPattern myTodoPattern : this.myTodoPatterns) {
            hashCode += myTodoPattern.hashCode();
        }
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TodoFilter)) {
            return false;
        }
        TodoFilter filter = (TodoFilter)obj;
        if (!this.myName.equals(filter.myName)) {
            return false;
        }
        if (this.myTodoPatterns.size() != filter.myTodoPatterns.size()) {
            return false;
        }
        for (TodoPattern pattern : this.myTodoPatterns) {
            if (filter.contains(pattern)) continue;
            return false;
        }
        return true;
    }

    public TodoFilter clone() {
        try {
            TodoFilter filter = (TodoFilter)super.clone();
            filter.myTodoPatterns = new HashSet<TodoPattern>(this.myTodoPatterns);
            return filter;
        }
        catch (CloneNotSupportedException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }
}

