/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.structureView.impl.java;

import com.intellij.ide.structureView.StructureViewModel;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.structureView.TextEditorBasedStructureViewModel;
import com.intellij.ide.structureView.impl.java.AnonymousClassesSorter;
import com.intellij.ide.structureView.impl.java.FieldsFilter;
import com.intellij.ide.structureView.impl.java.JavaAnonymousClassesNodeProvider;
import com.intellij.ide.structureView.impl.java.JavaFileTreeElement;
import com.intellij.ide.structureView.impl.java.JavaInheritedMembersNodeProvider;
import com.intellij.ide.structureView.impl.java.KindSorter;
import com.intellij.ide.structureView.impl.java.PropertiesGrouper;
import com.intellij.ide.structureView.impl.java.PublicElementsFilter;
import com.intellij.ide.structureView.impl.java.SuperTypesGrouper;
import com.intellij.ide.structureView.impl.java.VisibilitySorter;
import com.intellij.ide.util.treeView.smartTree.Filter;
import com.intellij.ide.util.treeView.smartTree.Grouper;
import com.intellij.ide.util.treeView.smartTree.NodeProvider;
import com.intellij.ide.util.treeView.smartTree.Sorter;
import com.intellij.ide.util.treeView.smartTree.TreeStructureUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMethod;
import com.intellij.ui.PlaceHolder;
import java.util.Arrays;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaFileTreeModel
extends TextEditorBasedStructureViewModel
implements StructureViewModel.ElementInfoProvider,
PlaceHolder<String> {
    private static final Collection<NodeProvider> NODE_PROVIDERS = Arrays.asList(new JavaInheritedMembersNodeProvider(), new JavaAnonymousClassesNodeProvider());
    private String myPlace;

    public JavaFileTreeModel(@NotNull PsiClassOwner file2, @Nullable Editor editor) {
        super(editor, (PsiFile)file2);
    }

    @NotNull
    public Filter[] getFilters() {
        return new Filter[]{new FieldsFilter(), new PublicElementsFilter()};
    }

    @NotNull
    public Collection<NodeProvider> getNodeProviders() {
        return NODE_PROVIDERS;
    }

    @NotNull
    public Grouper[] getGroupers() {
        return new Grouper[]{new SuperTypesGrouper(), new PropertiesGrouper()};
    }

    @NotNull
    public StructureViewTreeElement getRoot() {
        return new JavaFileTreeElement(this.getPsiFile());
    }

    public boolean shouldEnterElement(Object element) {
        return element instanceof PsiClass;
    }

    @NotNull
    public Sorter[] getSorters() {
        return new Sorter[]{TreeStructureUtil.isInStructureViewPopup(this) ? KindSorter.POPUP_INSTANCE : KindSorter.INSTANCE, VisibilitySorter.INSTANCE, AnonymousClassesSorter.INSTANCE, Sorter.ALPHA_SORTER};
    }

    protected PsiClassOwner getPsiFile() {
        return (PsiClassOwner)super.getPsiFile();
    }

    public boolean isAlwaysShowsPlus(StructureViewTreeElement element) {
        Object value = element.getValue();
        return value instanceof PsiClass || value instanceof PsiFile;
    }

    public boolean isAlwaysLeaf(StructureViewTreeElement element) {
        Object value = element.getValue();
        return value instanceof PsiMethod || value instanceof PsiField;
    }

    protected boolean isSuitable(PsiElement element) {
        if (super.isSuitable(element)) {
            if (element instanceof PsiMethod) {
                PsiMethod method = (PsiMethod)element;
                PsiClass parent = method.getContainingClass();
                return parent != null && (parent.getQualifiedName() != null || parent instanceof PsiAnonymousClass);
            }
            if (element instanceof PsiField) {
                PsiField field = (PsiField)element;
                PsiClass parent = field.getContainingClass();
                return parent != null && parent.getQualifiedName() != null;
            }
            if (element instanceof PsiClass) {
                return ((PsiClass)element).getQualifiedName() != null;
            }
        }
        return false;
    }

    @NotNull
    protected Class[] getSuitableClasses() {
        return new Class[]{PsiClass.class, PsiMethod.class, PsiField.class, PsiJavaFile.class};
    }

    public void setPlace(@NotNull String place) {
        this.myPlace = place;
    }

    public String getPlace() {
        return this.myPlace;
    }
}

