/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.structureView.impl;

import com.intellij.ide.structureView.FileEditorPositionListener;
import com.intellij.ide.structureView.ModelListener;
import com.intellij.ide.structureView.StructureViewModel;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.structureView.impl.StructureViewElementWrapper;
import com.intellij.ide.util.treeView.smartTree.Filter;
import com.intellij.ide.util.treeView.smartTree.Grouper;
import com.intellij.ide.util.treeView.smartTree.Sorter;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;

public class StructureViewModelWrapper
implements StructureViewModel {
    private final StructureViewModel myStructureViewModel;
    private final PsiFile myMainFile;

    public StructureViewModelWrapper(StructureViewModel structureViewModel, PsiFile mainFile) {
        this.myStructureViewModel = structureViewModel;
        this.myMainFile = mainFile;
    }

    public Object getCurrentEditorElement() {
        return this.myStructureViewModel.getCurrentEditorElement();
    }

    public void addEditorPositionListener(@NotNull FileEditorPositionListener listener2) {
        this.myStructureViewModel.addEditorPositionListener(listener2);
    }

    public void removeEditorPositionListener(@NotNull FileEditorPositionListener listener2) {
        this.myStructureViewModel.removeEditorPositionListener(listener2);
    }

    public void addModelListener(@NotNull ModelListener modelListener) {
        this.myStructureViewModel.addModelListener(modelListener);
    }

    public void removeModelListener(@NotNull ModelListener modelListener) {
        this.myStructureViewModel.removeModelListener(modelListener);
    }

    @NotNull
    public StructureViewTreeElement getRoot() {
        return new StructureViewElementWrapper(this.myStructureViewModel.getRoot(), this.myMainFile);
    }

    public void dispose() {
        this.myStructureViewModel.dispose();
    }

    public boolean shouldEnterElement(Object element) {
        return false;
    }

    @NotNull
    public Grouper[] getGroupers() {
        return this.myStructureViewModel.getGroupers();
    }

    @NotNull
    public Sorter[] getSorters() {
        return this.myStructureViewModel.getSorters();
    }

    @NotNull
    public Filter[] getFilters() {
        return this.myStructureViewModel.getFilters();
    }
}

