/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.structureView.impl;

import com.intellij.ide.impl.StructureViewWrapperImpl;
import com.intellij.ide.structureView.StructureView;
import com.intellij.ide.structureView.StructureViewExtension;
import com.intellij.ide.structureView.StructureViewFactoryEx;
import com.intellij.ide.structureView.StructureViewModel;
import com.intellij.ide.structureView.StructureViewWrapper;
import com.intellij.ide.structureView.newStructureView.StructureViewComponent;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.MultiValuesMap;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.psi.PsiElement;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

@com.intellij.openapi.components.State(name="StructureViewFactory", storages={@Storage(value="$WORKSPACE_FILE$")})
public final class StructureViewFactoryImpl
extends StructureViewFactoryEx
implements PersistentStateComponent<State> {
    private final Project myProject;
    private StructureViewWrapperImpl myStructureViewWrapperImpl;
    private State myState = new State();
    private Runnable myRunWhenInitialized = null;
    private static final NotNullLazyValue<MultiValuesMap<Class<? extends PsiElement>, StructureViewExtension>> myExtensions = new NotNullLazyValue<MultiValuesMap<Class<? extends PsiElement>, StructureViewExtension>>(){

        @NotNull
        protected MultiValuesMap<Class<? extends PsiElement>, StructureViewExtension> compute() {
            StructureViewExtension[] extensions;
            MultiValuesMap map = new MultiValuesMap();
            for (StructureViewExtension extension : extensions = (StructureViewExtension[])Extensions.getExtensions(StructureViewExtension.EXTENSION_POINT_NAME)) {
                map.put(extension.getType(), (Object)extension);
            }
            return map;
        }
    };
    private final MultiValuesMap<Class<? extends PsiElement>, StructureViewExtension> myImplExtensions = new MultiValuesMap();

    public StructureViewFactoryImpl(Project project2) {
        this.myProject = project2;
    }

    @Override
    public StructureViewWrapper getStructureViewWrapper() {
        return this.myStructureViewWrapperImpl;
    }

    @NotNull
    public State getState() {
        return this.myState;
    }

    public void loadState(State state) {
        this.myState = state;
    }

    public void initToolWindow(ToolWindowEx toolWindow) {
        this.myStructureViewWrapperImpl = new StructureViewWrapperImpl(this.myProject, toolWindow);
        if (this.myRunWhenInitialized != null) {
            this.myRunWhenInitialized.run();
            this.myRunWhenInitialized = null;
        }
    }

    @Override
    @NotNull
    public Collection<StructureViewExtension> getAllExtensions(@NotNull Class<? extends PsiElement> type) {
        Collection result = this.myImplExtensions.get(type);
        if (result == null) {
            MultiValuesMap map = (MultiValuesMap)myExtensions.getValue();
            for (Class registeredType : map.keySet()) {
                if (!ReflectionUtil.isAssignable((Class)registeredType, type)) continue;
                Collection extensions = map.get((Object)registeredType);
                for (StructureViewExtension extension : extensions) {
                    this.myImplExtensions.put(type, (Object)extension);
                }
            }
            result = this.myImplExtensions.get(type);
            if (result == null) {
                return Collections.emptyList();
            }
        }
        return result;
    }

    @Override
    public void setActiveAction(String name, boolean state) {
        Collection<String> activeActions = this.collectActiveActions();
        if (state) {
            activeActions.add(name);
        } else {
            activeActions.remove(name);
        }
        this.myState.ACTIVE_ACTIONS = StructureViewFactoryImpl.toString(activeActions);
    }

    private static String toString(Collection<String> activeActions) {
        return StringUtil.join(activeActions, (String)",");
    }

    private Collection<String> collectActiveActions() {
        return ContainerUtil.newLinkedHashSet((Object[])this.myState.ACTIVE_ACTIONS.split(","));
    }

    @Override
    public boolean isActionActive(String name) {
        return this.collectActiveActions().contains(name);
    }

    @Override
    public void runWhenInitialized(@NotNull Runnable runnable2) {
        if (this.myStructureViewWrapperImpl != null) {
            runnable2.run();
        } else {
            this.myRunWhenInitialized = runnable2;
        }
    }

    @NotNull
    public StructureView createStructureView(FileEditor fileEditor, @NotNull StructureViewModel treeModel, @NotNull Project project2) {
        return this.createStructureView(fileEditor, treeModel, project2, true);
    }

    @NotNull
    public StructureView createStructureView(FileEditor fileEditor, @NotNull StructureViewModel treeModel, @NotNull Project project2, boolean showRootNode) {
        return new StructureViewComponent(fileEditor, treeModel, project2, showRootNode);
    }

    public static class State {
        public boolean AUTOSCROLL_MODE = true;
        public boolean AUTOSCROLL_FROM_SOURCE = false;
        public String ACTIVE_ACTIONS = "";
    }
}

