/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.structureView.impl;

import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.util.treeView.smartTree.TreeElement;
import com.intellij.lang.Language;
import com.intellij.navigation.ItemPresentation;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.templateLanguages.TemplateLanguageFileViewProvider;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StructureViewElementWrapper<V extends PsiElement>
implements StructureViewTreeElement {
    private final StructureViewTreeElement myTreeElement;
    private final PsiFile myMainFile;

    public StructureViewElementWrapper(@NotNull StructureViewTreeElement treeElement, @NotNull PsiFile mainFile) {
        this.myTreeElement = treeElement;
        this.myMainFile = mainFile;
    }

    public StructureViewTreeElement getWrappedElement() {
        return this.myTreeElement;
    }

    public V getValue() {
        return (V)((PsiElement)this.myTreeElement.getValue());
    }

    @NotNull
    public StructureViewTreeElement[] getChildren() {
        TreeElement[] baseChildren = this.myTreeElement.getChildren();
        ArrayList<StructureViewElementWrapper<V>> result = new ArrayList<StructureViewElementWrapper<V>>();
        for (TreeElement element : baseChildren) {
            StructureViewElementWrapper<V> wrapper = new StructureViewElementWrapper<V>((StructureViewTreeElement)element, this.myMainFile);
            result.add(wrapper);
        }
        return result.toArray(new StructureViewTreeElement[result.size()]);
    }

    @NotNull
    public ItemPresentation getPresentation() {
        return this.myTreeElement.getPresentation();
    }

    public void navigate(boolean requestFocus) {
        Navigatable navigatable = this.getNavigatableInTemplateLanguageFile();
        if (navigatable != null) {
            navigatable.navigate(requestFocus);
        }
    }

    @Nullable
    private Navigatable getNavigatableInTemplateLanguageFile() {
        PsiElement element = (PsiElement)this.myTreeElement.getValue();
        if (element == null) {
            return null;
        }
        int offset = element.getTextRange().getStartOffset();
        Language dataLanguage = ((TemplateLanguageFileViewProvider)this.myMainFile.getViewProvider()).getTemplateDataLanguage();
        PsiFile dataFile = this.myMainFile.getViewProvider().getPsi(dataLanguage);
        if (dataFile == null) {
            return null;
        }
        for (PsiElement tlElement = dataFile.findElementAt(offset); tlElement != null && tlElement.getTextRange().getStartOffset() == offset; tlElement = tlElement.getParent()) {
            if (!(tlElement instanceof Navigatable)) continue;
            return (Navigatable)tlElement;
        }
        return null;
    }

    public boolean canNavigate() {
        return this.getNavigatableInTemplateLanguageFile() != null;
    }

    public boolean canNavigateToSource() {
        return this.canNavigate();
    }
}

