/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.scratch;

import com.intellij.icons.AllIcons;
import com.intellij.ide.scratch.RootType;
import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.ide.scratch.ScratchFileType;
import com.intellij.lang.Language;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.RunResult;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.UIBundle;
import com.intellij.util.ObjectUtils;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ScratchRootType
extends RootType {
    @NotNull
    public static ScratchRootType getInstance() {
        return ScratchRootType.findByClass(ScratchRootType.class);
    }

    ScratchRootType() {
        super("scratches", "Scratches");
    }

    @Override
    public Language substituteLanguage(@NotNull Project project2, @NotNull VirtualFile file2) {
        return (Language)ScratchFileService.getInstance().getScratchesMapping().getMapping(file2);
    }

    @Override
    @Nullable
    public Icon substituteIcon(@NotNull Project project2, @NotNull VirtualFile file2) {
        Icon icon = (Icon)ObjectUtils.chooseNotNull((Object)super.substituteIcon(project2, file2), (Object)ScratchFileType.INSTANCE.getIcon());
        return LayeredIcon.create((Icon)icon, (Icon)AllIcons.Actions.Scratch);
    }

    @Nullable
    public VirtualFile createScratchFile(Project project2, String fileName, Language language, String text) {
        return this.createScratchFile(project2, fileName, language, text, ScratchFileService.Option.create_new_always);
    }

    @Nullable
    public VirtualFile createScratchFile(Project project2, final String fileName, final Language language, final String text, final ScratchFileService.Option option) {
        RunResult result = new WriteCommandAction<VirtualFile>(project2, UIBundle.message((String)"file.chooser.create.new.file.command.name", (Object[])new Object[0]), new PsiFile[0]){

            protected boolean isGlobalUndoAction() {
                return true;
            }

            protected UndoConfirmationPolicy getUndoConfirmationPolicy() {
                return UndoConfirmationPolicy.REQUEST_CONFIRMATION;
            }

            protected void run(@NotNull Result<VirtualFile> result) throws Throwable {
                ScratchFileService fileService = ScratchFileService.getInstance();
                VirtualFile file2 = fileService.findFile(ScratchRootType.this, fileName, option);
                fileService.getScratchesMapping().setMapping(file2, (Object)language);
                VfsUtil.saveText((VirtualFile)file2, (String)text);
                result.setResult((Object)file2);
            }
        }.execute();
        if (result.hasException()) {
            Messages.showMessageDialog((String)UIBundle.message((String)"create.new.file.could.not.create.file.error.message", (Object[])new Object[]{fileName}), (String)UIBundle.message((String)"error.dialog.title", (Object[])new Object[0]), (Icon)Messages.getErrorIcon());
            return null;
        }
        return (VirtualFile)result.getResultObject();
    }
}

