/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.scratch;

import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.ide.scratch.LRUPopupBuilder;
import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.ide.scratch.ScratchRootType;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.lang.PerFileMappings;
import com.intellij.lang.StdLanguages;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScratchFileActions {
    private static int ourCurrentBuffer = 0;

    static void doCreateNewScratch(@NotNull Project project2, boolean buffer, @NotNull Language language, @NotNull String text) {
        FeatureUsageTracker.getInstance().triggerFeatureUsed("scratch");
        LanguageFileType fileType = language.getAssociatedFileType();
        String ext = buffer || fileType == null ? "" : fileType.getDefaultExtension();
        String fileName = buffer ? "buffer" + ScratchFileActions.nextBufferIndex() : "scratch";
        ScratchFileService.Option option = buffer ? ScratchFileService.Option.create_if_missing : ScratchFileService.Option.create_new_always;
        VirtualFile f = ScratchRootType.getInstance().createScratchFile(project2, PathUtil.makeFileName((String)fileName, (String)ext), language, text, option);
        if (f != null) {
            FileEditorManager.getInstance((Project)project2).openFile(f, true);
        }
    }

    private static int nextBufferIndex() {
        ourCurrentBuffer = ourCurrentBuffer % Registry.intValue((String)"ide.scratch.buffers") + 1;
        return ourCurrentBuffer;
    }

    @Nullable
    static String getSelectionText(@Nullable Editor editor) {
        if (editor == null) {
            return null;
        }
        return editor.getSelectionModel().getSelectedText();
    }

    @Nullable
    static Language getLanguageFromCaret(@NotNull Project project2, @Nullable Editor editor, @Nullable PsiFile psiFile) {
        if (editor == null || psiFile == null) {
            return null;
        }
        Caret caret = editor.getCaretModel().getPrimaryCaret();
        int offset = caret.getOffset();
        PsiElement element = InjectedLanguageManager.getInstance((Project)project2).findInjectedElementAt(psiFile, offset);
        PsiFile file2 = element != null ? element.getContainingFile() : psiFile;
        return file2.getLanguage();
    }

    public static class LanguageAction
    extends DumbAwareAction {
        public void update(AnActionEvent e) {
            Project project2 = e.getProject();
            JBIterable files = JBIterable.of((Object[])((Object[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY)));
            if (project2 == null || files.isEmpty()) {
                e.getPresentation().setEnabledAndVisible(false);
                return;
            }
            Condition<VirtualFile> isScratch = this.fileFilter(project2);
            if (!files.filter(Conditions.not(isScratch)).isEmpty()) {
                e.getPresentation().setEnabledAndVisible(false);
                return;
            }
            Set langs = (Set)files.filter(isScratch).transform(this.fileLanguage(project2)).filter(Conditions.notNull()).addAllTo((Collection)ContainerUtil.newLinkedHashSet());
            String langName = langs.size() == 1 ? ((Language)langs.iterator().next()).getDisplayName() : langs.size() + " different";
            e.getPresentation().setText(String.format("Change %s (%s)...", this.getLanguageTerm(), langName));
            e.getPresentation().setEnabledAndVisible(true);
        }

        @NotNull
        protected String getLanguageTerm() {
            return "Language";
        }

        public void actionPerformed(AnActionEvent e) {
            Project project2 = e.getProject();
            JBIterable files = JBIterable.of((Object[])((Object[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY))).filter(this.fileFilter(project2));
            if (project2 == null || files.isEmpty()) {
                return;
            }
            this.actionPerformedImpl(e, project2, (JBIterable<VirtualFile>)files);
        }

        @NotNull
        protected Condition<VirtualFile> fileFilter(Project project2) {
            return new Condition<VirtualFile>(){

                public boolean value(@NotNull VirtualFile file2) {
                    return ScratchRootType.getInstance().containsFile(file2);
                }
            };
        }

        @NotNull
        protected Function<VirtualFile, Language> fileLanguage(final Project project2) {
            return new Function<VirtualFile, Language>(){
                ScratchFileService fileService = ScratchFileService.getInstance();

                public Language fun(VirtualFile file2) {
                    Language lang = (Language)this.fileService.getScratchesMapping().getMapping(file2);
                    return lang != null ? lang : LanguageUtil.getLanguageForPsi((Project)project2, (VirtualFile)file2);
                }
            };
        }

        protected void actionPerformedImpl(AnActionEvent e, Project project2, JBIterable<VirtualFile> files) {
            ScratchFileService fileService = ScratchFileService.getInstance();
            PerFileMappings<Language> mapping = fileService.getScratchesMapping();
            LRUPopupBuilder.forFileLanguages(project2, files, mapping).showInBestPositionFor(e.getDataContext());
        }
    }

    public static class NewBufferAction
    extends DumbAwareAction {
        public void update(@NotNull AnActionEvent e) {
            boolean enabled = e.getProject() != null && Registry.is((String)"ide.scratch.enabled") && Registry.intValue((String)"ide.scratch.buffers") > 0;
            e.getPresentation().setEnabledAndVisible(enabled);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Project project2 = e.getProject();
            if (project2 == null) {
                return;
            }
            PsiFile file2 = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
            Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
            String text = StringUtil.notNullize((String)ScratchFileActions.getSelectionText(editor));
            Language language = text.isEmpty() ? null : ScratchFileActions.getLanguageFromCaret(project2, editor, file2);
            ScratchFileActions.doCreateNewScratch(project2, true, (Language)ObjectUtils.notNull((Object)language, (Object)StdLanguages.TEXT), text);
        }
    }

    public static class NewFileAction
    extends DumbAwareAction {
        public void update(@NotNull AnActionEvent e) {
            boolean enabled = e.getProject() != null && Registry.is((String)"ide.scratch.enabled");
            e.getPresentation().setEnabledAndVisible(enabled);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            final Project project2 = e.getProject();
            if (project2 == null) {
                return;
            }
            PsiFile file2 = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
            Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
            final String text = StringUtil.notNullize((String)ScratchFileActions.getSelectionText(editor));
            Language language = text.isEmpty() ? null : ScratchFileActions.getLanguageFromCaret(project2, editor, file2);
            Consumer<Language> consumer = new Consumer<Language>(){

                public void consume(Language language) {
                    ScratchFileActions.doCreateNewScratch(project2, false, language, text);
                }
            };
            if (language != null) {
                consumer.consume((Object)language);
            } else {
                LRUPopupBuilder.forFileLanguages(project2, null, consumer).showCenteredInCurrentWindow(project2);
            }
        }
    }
}

