/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.scratch;

import com.intellij.openapi.fileTypes.FileTypeEvent;
import com.intellij.openapi.fileTypes.FileTypeListener;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.util.PairConsumer;
import com.intellij.util.containers.ConcurrentIntObjectMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class LightDirectoryIndex<T> {
    private final ConcurrentIntObjectMap<T> myInfoCache = ContainerUtil.createConcurrentIntObjectMap();
    private final T myDefValue;

    public LightDirectoryIndex(@NotNull MessageBusConnection connection, @NotNull T defValue) {
        this.myDefValue = defValue;
        this.reinitRoots();
        connection.subscribe(FileTypeManager.TOPIC, (Object)new FileTypeListener.Adapter(){

            public void fileTypesChanged(@NotNull FileTypeEvent event) {
                LightDirectoryIndex.this.reinitRoots();
            }
        });
        connection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){

            public void before(@NotNull List<? extends VFileEvent> events) {
            }

            public void after(@NotNull List<? extends VFileEvent> events) {
                for (VFileEvent vFileEvent : events) {
                    VirtualFile file2 = vFileEvent.getFile();
                    if (file2 != null && !file2.isDirectory()) continue;
                    LightDirectoryIndex.this.reinitRoots();
                    break;
                }
            }
        });
    }

    public void reinitRoots() {
        this.myInfoCache.clear();
        this.collectRoots(new PairConsumer<VirtualFile, T>(){

            public void consume(VirtualFile file2, T info) {
                LightDirectoryIndex.this.cacheInfo(file2, info);
            }
        });
    }

    protected abstract void collectRoots(@NotNull PairConsumer<VirtualFile, T> var1);

    @NotNull
    public T getInfoForFile(@NotNull VirtualFile file2) {
        VirtualFile dir;
        if (!file2.isDirectory()) {
            T info = this.getCachedInfo(file2);
            if (info != null) {
                return info;
            }
            dir = file2.getParent();
        } else {
            dir = file2;
        }
        int count = 0;
        for (VirtualFile root = dir; root != null; root = root.getParent()) {
            if (++count > 1000) {
                throw new IllegalStateException("Possible loop in tree, started at " + dir.getName());
            }
            T info = this.getCachedInfo(root);
            if (info == null) continue;
            if (!dir.equals(root)) {
                this.cacheInfos(dir, root, info);
            }
            return info;
        }
        return this.cacheInfos(dir, null, this.myDefValue);
    }

    @NotNull
    private T cacheInfos(VirtualFile dir, @Nullable VirtualFile stopAt, @NotNull T info) {
        while (dir != null) {
            this.cacheInfo(dir, info);
            if (dir.equals(stopAt)) break;
            dir = dir.getParent();
        }
        return info;
    }

    private void cacheInfo(VirtualFile file2, T info) {
        this.myInfoCache.put(((VirtualFileWithId)file2).getId(), info);
    }

    private T getCachedInfo(VirtualFile file2) {
        return (T)this.myInfoCache.get(((VirtualFileWithId)file2).getId());
    }
}

