/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.scratch;

import com.intellij.ide.scratch.ScratchUtil;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.lang.PerFileMappings;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.command.undo.BasicUndoableAction;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.command.undo.UnexpectedUndoException;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.ListSeparator;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.EdtInvocationManager;
import com.intellij.util.ui.EmptyIcon;
import java.awt.Dimension;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JLabel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LRUPopupBuilder<T> {
    private static final int MAX_VISIBLE_SIZE = 20;
    private static final int LRU_ITEMS = 4;
    private final String myTitle;
    private final PropertiesComponent myPropertiesComponent;
    private final Map<T, Pair<String, Icon>> myPresentations = ContainerUtil.newIdentityHashMap();
    private T mySelection;
    private Consumer<T> myOnChosen;
    private Comparator<? super T> myComparator;
    private Iterable<? extends T> myItemsIterable;
    private JBIterable<T> myExtraItems = JBIterable.empty();

    @NotNull
    public static ListPopup forFileLanguages(final @NotNull Project project2, @NotNull Iterable<VirtualFile> files, final @NotNull PerFileMappings<Language> mappings) {
        final VirtualFile[] filesCopy = VfsUtilCore.toVirtualFileArray((Collection)JBIterable.from(files).toList());
        Arrays.sort(filesCopy, new Comparator<VirtualFile>(){

            @Override
            public int compare(VirtualFile o1, VirtualFile o2) {
                return StringUtil.compare((String)o1.getName(), (String)o2.getName(), (!o1.getFileSystem().isCaseSensitive() ? 1 : 0) != 0);
            }
        });
        return LRUPopupBuilder.forFileLanguages(project2, null, new Consumer<Language>(){

            public void consume(final Language t) {
                new WriteCommandAction(project2, "Change Language", new PsiFile[0]){

                    protected void run(@NotNull Result result) throws Throwable {
                        LRUPopupBuilder.changeLanguageWithUndo(project2, t, filesCopy, (PerFileMappings<Language>)mappings);
                    }
                }.execute();
            }
        });
    }

    @NotNull
    public static ListPopup forFileLanguages(@NotNull Project project2, @Nullable Language selection, @NotNull Consumer<Language> onChosen) {
        return LRUPopupBuilder.languagePopupBuilder(project2, "Languages").forValues(LanguageUtil.getFileLanguages()).withSelection(selection).onChosen(onChosen).buildPopup();
    }

    @NotNull
    public static LRUPopupBuilder<Language> languagePopupBuilder(@NotNull Project project2, @NotNull String title) {
        return new LRUPopupBuilder<Language>(project2, title){

            @Override
            public String getDisplayName(Language language) {
                return language.getDisplayName();
            }

            @Override
            public Icon getIcon(Language language) {
                LanguageFileType associatedLanguage = language.getAssociatedFileType();
                return associatedLanguage != null ? associatedLanguage.getIcon() : null;
            }

            @Override
            public String getStorageId(Language language) {
                return language.getID();
            }
        }.withComparator(LanguageUtil.LANGUAGE_COMPARATOR);
    }

    protected LRUPopupBuilder(@NotNull Project project2, @NotNull String title) {
        this.myTitle = title;
        this.myPropertiesComponent = PropertiesComponent.getInstance((Project)project2);
    }

    public abstract String getDisplayName(T var1);

    public abstract String getStorageId(T var1);

    public abstract Icon getIcon(T var1);

    public LRUPopupBuilder<T> forValues(@Nullable Iterable<? extends T> items) {
        this.myItemsIterable = items;
        return this;
    }

    public LRUPopupBuilder<T> withSelection(@Nullable T t) {
        this.mySelection = t;
        return this;
    }

    public LRUPopupBuilder<T> withExtra(@NotNull T extra, @NotNull String displayName, @Nullable Icon icon) {
        this.myExtraItems = this.myExtraItems.append(extra);
        this.myPresentations.put(extra, (Pair<String, Icon>)Pair.create((Object)displayName, (Object)icon));
        return this;
    }

    public LRUPopupBuilder<T> onChosen(@Nullable Consumer<T> consumer) {
        this.myOnChosen = consumer;
        return this;
    }

    public LRUPopupBuilder<T> withComparator(@Nullable Comparator<? super T> comparator2) {
        this.myComparator = comparator2;
        return this;
    }

    @NotNull
    public ListPopup buildPopup() {
        final ArrayList ids = ContainerUtil.newArrayList((Object[])this.restoreLRUItems());
        if (this.mySelection != null) {
            ids.add(this.getStorageId(this.mySelection));
        }
        ArrayList lru = ContainerUtil.newArrayListWithCapacity((int)4);
        ArrayList items = ContainerUtil.newArrayListWithCapacity((int)20);
        final List extra = this.myExtraItems.toList();
        for (T t : this.myItemsIterable) {
            (ContainerUtil.indexOf((List)ids, (Object)this.getStorageId(t)) != -1 ? lru : items).add(t);
        }
        if (this.myComparator != null) {
            Collections.sort(items, this.myComparator);
        }
        if (!lru.isEmpty()) {
            Collections.sort(lru, new Comparator<T>(){

                @Override
                public int compare(T o1, T o2) {
                    return ContainerUtil.indexOf((List)ids, (Object)LRUPopupBuilder.this.getStorageId(o1)) - ContainerUtil.indexOf((List)ids, (Object)LRUPopupBuilder.this.getStorageId(o2));
                }
            });
        }
        final Object separator1 = !lru.isEmpty() && !items.isEmpty() ? items.get(0) : null;
        final Object separator2 = !lru.isEmpty() || !items.isEmpty() ? ContainerUtil.getFirstItem((List)extra) : null;
        List combinedItems = ContainerUtil.concat((List[])new List[]{lru, items, extra});
        BaseListPopupStep step = new BaseListPopupStep<T>(this.myTitle, combinedItems){

            @NotNull
            public String getTextFor(T t) {
                return t == null ? "" : (String)((LRUPopupBuilder)LRUPopupBuilder.this).getPresentation(t).first;
            }

            public Icon getIconFor(T t) {
                return t == null ? null : (Icon)((LRUPopupBuilder)LRUPopupBuilder.this).getPresentation(t).second;
            }

            public boolean isSpeedSearchEnabled() {
                return true;
            }

            public PopupStep onChosen(final T t, boolean finalChoice) {
                if (!extra.contains(t)) {
                    LRUPopupBuilder.this.storeLRUItems(t);
                }
                if (LRUPopupBuilder.this.myOnChosen != null) {
                    EdtInvocationManager.getInstance().invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            LRUPopupBuilder.this.myOnChosen.consume(t);
                        }
                    });
                }
                return null;
            }

            @Nullable
            public ListSeparator getSeparatorAbove(T value) {
                return value == separator1 || value == separator2 ? new ListSeparator() : null;
            }
        };
        int selection = Math.max(0, this.mySelection != null ? combinedItems.indexOf(this.mySelection) : 0);
        step.setDefaultOptionIndex(selection);
        return LRUPopupBuilder.tweakSizeToPreferred(JBPopupFactory.getInstance().createListPopup((ListPopupStep)step));
    }

    @NotNull
    private Pair<String, Icon> getPresentation(T t) {
        Pair p = this.myPresentations.get(t);
        if (p == null) {
            p = Pair.create((Object)this.getDisplayName(t), (Object)this.getIcon(t));
            this.myPresentations.put(t, (Pair<String, Icon>)p);
        }
        return p;
    }

    @NotNull
    private static ListPopup tweakSizeToPreferred(@NotNull ListPopup popup) {
        int nameLen = 0;
        ListPopupStep step = popup.getListStep();
        List values = step.getValues();
        for (Object v : values) {
            nameLen = Math.max(nameLen, step.getTextFor(v).length());
        }
        if (values.size() > 20) {
            Dimension size = new JLabel(StringUtil.repeatSymbol((char)'a', (int)nameLen), EmptyIcon.ICON_16, 2).getPreferredSize();
            size.width += 20;
            size.height *= 20;
            popup.setSize(size);
        }
        return popup;
    }

    @NotNull
    private String[] restoreLRUItems() {
        return (String[])ObjectUtils.notNull((Object)this.myPropertiesComponent.getValues(this.getLRUKey()), (Object)ArrayUtil.EMPTY_STRING_ARRAY);
    }

    private void storeLRUItems(@NotNull T t) {
        String[] values = this.myPropertiesComponent.getValues(this.getLRUKey());
        ArrayList lastUsed = ContainerUtil.newArrayListWithCapacity((int)4);
        lastUsed.add(this.getStorageId(t));
        if (values != null) {
            for (String value : values) {
                if (!lastUsed.contains(value)) {
                    lastUsed.add(value);
                }
                if (lastUsed.size() == 4) break;
            }
        }
        this.myPropertiesComponent.setValues(this.getLRUKey(), ArrayUtil.toStringArray((Collection)lastUsed));
    }

    @NotNull
    private String getLRUKey() {
        return this.getClass().getName() + "/" + this.myTitle;
    }

    private static void changeLanguageWithUndo(@NotNull Project project2, final @NotNull Language t, final @NotNull VirtualFile[] sortedFiles, final @NotNull PerFileMappings<Language> mappings) throws UnexpectedUndoException {
        ReadonlyStatusHandler.OperationStatus status = ReadonlyStatusHandler.getInstance((Project)project2).ensureFilesWritable(sortedFiles);
        if (status.hasReadonlyFiles()) {
            return;
        }
        LinkedHashSet matchedExtensions = ContainerUtil.newLinkedHashSet();
        final HashMap oldMapping = ContainerUtil.newHashMap();
        for (VirtualFile file2 : sortedFiles) {
            oldMapping.put(file2, mappings.getMapping(file2));
            if (!ScratchUtil.hasMatchingExtension(project2, file2)) continue;
            matchedExtensions.add(file2);
        }
        BasicUndoableAction action = new BasicUndoableAction(sortedFiles){

            public void undo() throws UnexpectedUndoException {
                for (VirtualFile file2 : sortedFiles) {
                    mappings.setMapping(file2, oldMapping.get(file2));
                }
            }

            public void redo() throws UnexpectedUndoException {
                for (VirtualFile file2 : sortedFiles) {
                    mappings.setMapping(file2, (Object)t);
                }
            }
        };
        action.redo();
        UndoManager.getInstance((Project)project2).undoableActionPerformed((UndoableAction)action);
        for (VirtualFile file3 : matchedExtensions) {
            try {
                ScratchUtil.updateFileExtension(project2, file3);
            }
            catch (IOException iOException) {}
        }
    }
}

