/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectWizard;

import com.intellij.framework.addSupport.FrameworkSupportInModuleProvider;
import com.intellij.ide.projectWizard.ChooseTemplateStep;
import com.intellij.ide.projectWizard.NewProjectWizard;
import com.intellij.ide.projectWizard.ProjectCategory;
import com.intellij.ide.projectWizard.ProjectSettingsStep;
import com.intellij.ide.projectWizard.ProjectTemplateList;
import com.intellij.ide.projectWizard.TemplateBasedCategory;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.ide.util.frameworkSupport.FrameworkRole;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportUtil;
import com.intellij.ide.util.newProjectWizard.AddSupportForFrameworksPanel;
import com.intellij.ide.util.newProjectWizard.FrameworkSupportNode;
import com.intellij.ide.util.newProjectWizard.TemplatesGroup;
import com.intellij.ide.util.newProjectWizard.WizardDelegate;
import com.intellij.ide.util.newProjectWizard.impl.FrameworkSupportModelBase;
import com.intellij.ide.util.newProjectWizard.modes.CreateFromTemplateMode;
import com.intellij.ide.util.projectWizard.AbstractModuleBuilder;
import com.intellij.ide.util.projectWizard.EmptyModuleBuilder;
import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.ProjectBuilder;
import com.intellij.ide.util.projectWizard.SettingsStep;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.ide.wizard.CommitStepException;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesContainer;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesContainerFactory;
import com.intellij.openapi.ui.popup.ListItemDescriptor;
import com.intellij.openapi.ui.popup.ListItemDescriptorAdapter;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.platform.ProjectTemplate;
import com.intellij.platform.ProjectTemplateEP;
import com.intellij.platform.templates.ArchivedProjectTemplate;
import com.intellij.platform.templates.BuilderBasedTemplate;
import com.intellij.platform.templates.LocalArchivedTemplate;
import com.intellij.platform.templates.RemoteTemplatesFactory;
import com.intellij.platform.templates.TemplateModuleBuilder;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ListSpeedSearch;
import com.intellij.ui.SingleSelectionModel;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.popup.list.GroupedItemsListRenderer;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.Function;
import com.intellij.util.PlatformUtils;
import com.intellij.util.containers.ConcurrentMultiMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.ui.UIUtil;
import gnu.trove.THashMap;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectTypeStep
extends ModuleWizardStep
implements SettingsStep,
Disposable {
    private static final Logger LOG = Logger.getInstance(ProjectTypeStep.class);
    public static final Convertor<FrameworkSupportInModuleProvider, String> PROVIDER_STRING_CONVERTOR = new Convertor<FrameworkSupportInModuleProvider, String>(){

        public String convert(FrameworkSupportInModuleProvider o) {
            return o.getId();
        }
    };
    public static final Function<FrameworkSupportNode, String> NODE_STRING_FUNCTION = new Function<FrameworkSupportNode, String>(){

        public String fun(FrameworkSupportNode node) {
            return node.getId();
        }
    };
    private static final String TEMPLATES_CARD = "templates card";
    private static final String FRAMEWORKS_CARD = "frameworks card";
    private static final String PROJECT_WIZARD_GROUP = "project.wizard.group";
    private final WizardContext myContext;
    private final NewProjectWizard myWizard;
    private final ModulesProvider myModulesProvider;
    private final AddSupportForFrameworksPanel myFrameworksPanel;
    private final ModuleBuilder.ModuleConfigurationUpdater myConfigurationUpdater;
    private final FactoryMap<ProjectTemplate, ModuleBuilder> myBuilders;
    private final Map<String, ModuleWizardStep> myCustomSteps;
    private final MultiMap<TemplatesGroup, ProjectTemplate> myTemplatesMap;
    private JPanel myPanel;
    private JPanel myOptionsPanel;
    private JBList myProjectTypeList;
    private ProjectTemplateList myTemplatesList;
    private JPanel myFrameworksPanelPlaceholder;
    private JPanel myHeaderPanel;
    private JBLabel myFrameworksLabel;
    @Nullable
    private ModuleWizardStep mySettingsStep;
    private String myCurrentCard;
    private TemplatesGroup myLastSelectedGroup;

    public ProjectTypeStep(WizardContext context, NewProjectWizard wizard, ModulesProvider modulesProvider) {
        TemplatesGroup group;
        this.$$$setupUI$$$();
        this.myBuilders = new FactoryMap<ProjectTemplate, ModuleBuilder>(){

            @Nullable
            protected ModuleBuilder create(ProjectTemplate key) {
                return (ModuleBuilder)key.createModuleBuilder();
            }
        };
        this.myCustomSteps = new THashMap();
        this.myContext = context;
        this.myWizard = wizard;
        this.myTemplatesMap = new ConcurrentMultiMap();
        final List<TemplatesGroup> groups = this.fillTemplatesMap(context);
        this.myProjectTypeList.setModel((ListModel)new CollectionListModel(groups));
        this.myProjectTypeList.setSelectionModel((ListSelectionModel)new SingleSelectionModel());
        this.myProjectTypeList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ProjectTypeStep.this.updateSelection();
            }
        });
        this.myProjectTypeList.setCellRenderer((ListCellRenderer)new GroupedItemsListRenderer((ListItemDescriptor)new ListItemDescriptorAdapter<TemplatesGroup>(){

            @Nullable
            public String getTextFor(TemplatesGroup value) {
                return value.getName();
            }

            @Nullable
            public String getTooltipFor(TemplatesGroup value) {
                return value.getDescription();
            }

            @Nullable
            public Icon getIconFor(TemplatesGroup value) {
                return value.getIcon();
            }

            public boolean hasSeparatorAboveOf(TemplatesGroup value) {
                int index = groups.indexOf(value);
                if (index < 1) {
                    return false;
                }
                TemplatesGroup upper = (TemplatesGroup)groups.get(index - 1);
                if (upper.getParentGroup() == null && value.getParentGroup() == null) {
                    return true;
                }
                return !Comparing.equal((String)upper.getParentGroup(), (String)value.getParentGroup()) && !Comparing.equal((String)upper.getName(), (String)value.getParentGroup());
            }
        }){

            @Override
            protected JComponent createItemComponent() {
                JComponent component = super.createItemComponent();
                this.myTextLabel.setBorder(IdeBorderFactory.createEmptyBorder((int)3));
                return component;
            }
        });
        new ListSpeedSearch((JList)this.myProjectTypeList){

            @Override
            protected String getElementText(Object element) {
                return ((TemplatesGroup)element).getName();
            }
        };
        this.myModulesProvider = modulesProvider;
        Project project2 = context.getProject();
        LibrariesContainer container = LibrariesContainerFactory.createContainer(context, modulesProvider);
        FrameworkSupportModelBase model = new FrameworkSupportModelBase(project2, null, container){

            @Override
            @NotNull
            public String getBaseDirectoryForLibrariesPath() {
                ModuleBuilder builder = ProjectTypeStep.this.getSelectedBuilder();
                return StringUtil.notNullize((String)builder.getContentEntryPath());
            }

            @Override
            public ModuleBuilder getModuleBuilder() {
                return ProjectTypeStep.this.getSelectedBuilder();
            }
        };
        this.myFrameworksPanel = new AddSupportForFrameworksPanel(Collections.emptyList(), model, true, this.myHeaderPanel);
        Disposer.register((Disposable)this, (Disposable)this.myFrameworksPanel);
        this.myFrameworksPanelPlaceholder.add(this.myFrameworksPanel.getMainPanel());
        this.myFrameworksLabel.setLabelFor((Component)((Object)this.myFrameworksPanel.getFrameworksTree()));
        this.myFrameworksLabel.setBorder(IdeBorderFactory.createEmptyBorder((int)3));
        this.myConfigurationUpdater = new ModuleBuilder.ModuleConfigurationUpdater(){

            public void update(@NotNull Module module2, @NotNull ModifiableRootModel rootModel) {
                if (ProjectTypeStep.this.isFrameworksMode()) {
                    ProjectTypeStep.this.myFrameworksPanel.addSupport(module2, rootModel);
                }
            }
        };
        this.myProjectTypeList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ProjectTypeStep.this.projectTypeChanged();
            }
        });
        this.myTemplatesList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ProjectTypeStep.this.updateSelection();
            }
        });
        for (TemplatesGroup templatesGroup : this.myTemplatesMap.keySet()) {
            ModuleBuilder builder = templatesGroup.getModuleBuilder();
            if (builder != null) {
                this.myWizard.getSequence().addStepsForBuilder((AbstractModuleBuilder)builder, context, modulesProvider);
            }
            for (ProjectTemplate template : this.myTemplatesMap.get((Object)templatesGroup)) {
                this.myWizard.getSequence().addStepsForBuilder((AbstractModuleBuilder)this.myBuilders.get((Object)template), context, modulesProvider);
            }
        }
        final String groupId = PropertiesComponent.getInstance().getValue(PROJECT_WIZARD_GROUP);
        if (groupId != null && (group = (TemplatesGroup)ContainerUtil.find(groups, (Condition)new Condition<TemplatesGroup>(){

            public boolean value(TemplatesGroup group) {
                return groupId.equals(group.getId());
            }
        })) != null) {
            this.myProjectTypeList.setSelectedValue((Object)group, true);
        }
        if (this.myProjectTypeList.getSelectedValue() == null) {
            this.myProjectTypeList.setSelectedIndex(0);
        }
        this.myTemplatesList.restoreSelection();
    }

    private static ModuleType getModuleType(TemplatesGroup group) {
        ModuleBuilder moduleBuilder = group.getModuleBuilder();
        return moduleBuilder == null ? null : moduleBuilder.getModuleType();
    }

    private static boolean matchFramework(ProjectCategory projectCategory, FrameworkSupportInModuleProvider framework) {
        FrameworkRole[] roles = framework.getRoles();
        if (roles.length == 0) {
            return true;
        }
        List<FrameworkRole> acceptable = Arrays.asList(projectCategory.getAcceptableFrameworkRoles());
        return ContainerUtil.intersects(Arrays.asList(roles), acceptable);
    }

    private boolean isFrameworksMode() {
        return FRAMEWORKS_CARD.equals(this.myCurrentCard) && this.getSelectedBuilder().equals((Object)this.myContext.getProjectBuilder());
    }

    private List<TemplatesGroup> fillTemplatesMap(WizardContext context) {
        TemplatesGroup group;
        List builders = ModuleBuilder.getAllBuilders();
        if (context.isCreatingNewProject()) {
            builders.add(new EmptyModuleBuilder());
        }
        HashMap<String, TemplatesGroup> groupMap = new HashMap<String, TemplatesGroup>();
        for (ProjectCategory[] builder : builders) {
            TemplatesGroup group2;
            BuilderBasedTemplate template = new BuilderBasedTemplate((ModuleBuilder)builder);
            if (builder.isTemplate()) {
                group2 = (TemplatesGroup)groupMap.get(builder.getGroupName());
                if (group2 == null) {
                    group2 = new TemplatesGroup((ModuleBuilder)builder);
                }
                this.myTemplatesMap.putValue((Object)group2, (Object)template);
                continue;
            }
            group2 = new TemplatesGroup((ModuleBuilder)builder);
            groupMap.put(group2.getName(), group2);
            this.myTemplatesMap.put((Object)group2, new ArrayList());
        }
        MultiMap<TemplatesGroup, ProjectTemplate> map = CreateFromTemplateMode.getTemplatesMap(context);
        this.myTemplatesMap.putAllValues(map);
        for (ProjectCategory category : (ProjectCategory[])ProjectCategory.EXTENSION_POINT_NAME.getExtensions()) {
            TemplatesGroup group3 = new TemplatesGroup(category);
            this.myTemplatesMap.remove((Object)group3);
            this.myTemplatesMap.put((Object)group3, new ArrayList());
        }
        if (context.isCreatingNewProject()) {
            MultiMap<String, ProjectTemplate> localTemplates = this.loadLocalTemplates();
            for (TemplatesGroup group4 : this.myTemplatesMap.keySet()) {
                this.myTemplatesMap.putValues((Object)group4, localTemplates.get((Object)group4.getId()));
            }
        }
        ArrayList<TemplatesGroup> groups = new ArrayList<TemplatesGroup>(this.myTemplatesMap.keySet());
        final MultiMap moduleTypes = new MultiMap();
        for (TemplatesGroup group5 : groups) {
            ModuleType type = ProjectTypeStep.getModuleType(group5);
            moduleTypes.putValue((Object)type, (Object)group5);
        }
        Collections.sort(groups, new Comparator<TemplatesGroup>(){

            @Override
            public int compare(TemplatesGroup o1, TemplatesGroup o2) {
                int i = o2.getWeight() - o1.getWeight();
                if (i != 0) {
                    return i;
                }
                int i1 = moduleTypes.get((Object)ProjectTypeStep.getModuleType(o2)).size() - moduleTypes.get((Object)ProjectTypeStep.getModuleType(o1)).size();
                if (i1 != 0) {
                    return i1;
                }
                return o1.compareTo(o2);
            }
        });
        Set groupNames = ContainerUtil.map2Set(groups, (Function)new Function<TemplatesGroup, String>(){

            public String fun(TemplatesGroup group) {
                return group.getParentGroup();
            }
        });
        MultiMap subGroups = new MultiMap();
        ListIterator<TemplatesGroup> iterator = groups.listIterator();
        while (iterator.hasNext()) {
            group = (TemplatesGroup)iterator.next();
            String parentGroup = group.getParentGroup();
            if (parentGroup == null || !groupNames.contains(parentGroup) || group.getName().equals(parentGroup) || !groupMap.containsKey(parentGroup)) continue;
            subGroups.putValue((Object)parentGroup, (Object)group);
            iterator.remove();
        }
        iterator = groups.listIterator();
        while (iterator.hasNext()) {
            group = (TemplatesGroup)iterator.next();
            for (TemplatesGroup subGroup : subGroups.get((Object)group.getName())) {
                iterator.add(subGroup);
            }
        }
        if (PlatformUtils.isIdeaCommunity()) {
            iterator = groups.listIterator();
            while (iterator.hasNext()) {
                group = (TemplatesGroup)iterator.next();
                if (!"WEB_MODULE".equals(group.getId()) || !this.myTemplatesMap.get((Object)group).isEmpty()) continue;
                iterator.remove();
                break;
            }
        }
        return groups;
    }

    public void projectTypeChanged() {
        TemplatesGroup group = this.getSelectedGroup();
        if (group == null || group == this.myLastSelectedGroup) {
            return;
        }
        this.myLastSelectedGroup = group;
        PropertiesComponent.getInstance().setValue(PROJECT_WIZARD_GROUP, group.getId());
        ModuleBuilder groupModuleBuilder = group.getModuleBuilder();
        this.mySettingsStep = null;
        this.myHeaderPanel.removeAll();
        if (groupModuleBuilder != null && groupModuleBuilder.getModuleType() != null) {
            this.mySettingsStep = groupModuleBuilder.modifyProjectTypeStep((SettingsStep)this);
        }
        if (groupModuleBuilder == null || groupModuleBuilder.isTemplateBased()) {
            this.showTemplates(group);
        } else if (!this.showCustomOptions(groupModuleBuilder)) {
            List<FrameworkSupportInModuleProvider> providers = FrameworkSupportUtil.getProviders(groupModuleBuilder);
            final ProjectCategory category = group.getProjectCategory();
            if (category != null) {
                List filtered = ContainerUtil.filter(providers, (Condition)new Condition<FrameworkSupportInModuleProvider>(){

                    public boolean value(FrameworkSupportInModuleProvider provider) {
                        return ProjectTypeStep.matchFramework(category, provider);
                    }
                });
                Map map = ContainerUtil.newMapFromValues(providers.iterator(), PROVIDER_STRING_CONVERTOR);
                HashSet<FrameworkSupportInModuleProvider> set = new HashSet<FrameworkSupportInModuleProvider>(filtered);
                for (FrameworkSupportInModuleProvider provider : filtered) {
                    for (FrameworkSupportInModuleProvider.FrameworkDependency depId : provider.getDependenciesFrameworkIds()) {
                        FrameworkSupportInModuleProvider dependency = (FrameworkSupportInModuleProvider)map.get(depId.getFrameworkId());
                        if (dependency == null) {
                            if (depId.isOptional()) continue;
                            LOG.error("Cannot find provider '" + depId.getFrameworkId() + "' which is required for '" + provider.getId() + "'");
                            continue;
                        }
                        set.add(dependency);
                    }
                }
                this.myFrameworksPanel.setProviders(new ArrayList<FrameworkSupportInModuleProvider>(set), new HashSet<String>(Arrays.asList(category.getAssociatedFrameworkIds())), new HashSet<String>(Arrays.asList(category.getPreselectedFrameworkIds())));
            } else {
                this.myFrameworksPanel.setProviders(providers);
            }
            this.getSelectedBuilder().addModuleConfigurationUpdater(this.myConfigurationUpdater);
            this.showCard(FRAMEWORKS_CARD);
        }
        this.myHeaderPanel.setVisible(this.myHeaderPanel.getComponentCount() > 0);
        List labels = UIUtil.findComponentsOfType((JComponent)this.myHeaderPanel, JLabel.class);
        int width = 0;
        for (JLabel label : labels) {
            int width1 = label.getPreferredSize().width;
            width = Math.max(width, width1);
        }
        for (JLabel label : labels) {
            label.setPreferredSize(new Dimension(width, label.getPreferredSize().height));
        }
        this.myHeaderPanel.revalidate();
        this.myHeaderPanel.repaint();
        this.updateSelection();
    }

    private void showCard(String card) {
        ((CardLayout)this.myOptionsPanel.getLayout()).show(this.myOptionsPanel, card);
        this.myCurrentCard = card;
    }

    private void showTemplates(TemplatesGroup group) {
        Collection templates = this.myTemplatesMap.get((Object)group);
        this.setTemplatesList(group, templates, false);
        this.showCard(TEMPLATES_CARD);
    }

    private void setTemplatesList(TemplatesGroup group, Collection<ProjectTemplate> templates, boolean preserveSelection) {
        ArrayList<ProjectTemplate> list = new ArrayList<ProjectTemplate>(templates);
        ModuleBuilder moduleBuilder = group.getModuleBuilder();
        if (moduleBuilder != null && !(moduleBuilder instanceof TemplateModuleBuilder)) {
            list.add(0, new BuilderBasedTemplate(moduleBuilder));
        }
        this.myTemplatesList.setTemplates(list, preserveSelection);
    }

    private boolean showCustomOptions(@NotNull ModuleBuilder builder) {
        String card = builder.getBuilderId();
        if (!this.myCustomSteps.containsKey(card)) {
            ModuleWizardStep step = builder.getCustomOptionsStep(this.myContext, (Disposable)this);
            if (step == null) {
                return false;
            }
            step.updateStep();
            this.myCustomSteps.put(card, step);
            this.myOptionsPanel.add((Component)step.getComponent(), card);
        }
        this.showCard(card);
        return true;
    }

    @Nullable
    private ModuleWizardStep getCustomStep() {
        return this.myCustomSteps.get(this.myCurrentCard);
    }

    private TemplatesGroup getSelectedGroup() {
        return (TemplatesGroup)this.myProjectTypeList.getSelectedValue();
    }

    @Nullable
    public ProjectTemplate getSelectedTemplate() {
        return this.myCurrentCard == TEMPLATES_CARD ? this.myTemplatesList.getSelectedTemplate() : null;
    }

    private ModuleBuilder getSelectedBuilder() {
        ProjectTemplate template = this.getSelectedTemplate();
        if (template != null) {
            return (ModuleBuilder)this.myBuilders.get((Object)template);
        }
        return this.getSelectedGroup().getModuleBuilder();
    }

    public Collection<ProjectTemplate> getAvailableTemplates() {
        if (this.myCurrentCard != FRAMEWORKS_CARD) {
            return Collections.emptyList();
        }
        Collection templates = this.myTemplatesMap.get((Object)this.getSelectedGroup());
        List<FrameworkSupportNode> nodes = this.myFrameworksPanel.getSelectedNodes();
        if (nodes.isEmpty()) {
            return templates;
        }
        final List selectedFrameworks = ContainerUtil.map(nodes, NODE_STRING_FUNCTION);
        return ContainerUtil.filter((Collection)templates, (Condition)new Condition<ProjectTemplate>(){

            public boolean value(ProjectTemplate template) {
                if (!(template instanceof ArchivedProjectTemplate)) {
                    return true;
                }
                List<String> frameworks = ((ArchivedProjectTemplate)template).getFrameworks();
                return frameworks.containsAll(selectedFrameworks);
            }
        });
    }

    public void onWizardFinished() throws CommitStepException {
        boolean ok;
        if (this.isFrameworksMode() && !(ok = this.myFrameworksPanel.downloadLibraries(this.myWizard.getContentComponent()))) {
            throw new CommitStepException(null);
        }
    }

    public JComponent getComponent() {
        return this.myPanel;
    }

    public void updateDataModel() {
        ModuleBuilder builder = this.getSelectedBuilder();
        this.myWizard.getSequence().addStepsForBuilder((AbstractModuleBuilder)builder, this.myContext, this.myModulesProvider);
        ModuleWizardStep step = this.getCustomStep();
        if (step != null) {
            step.updateDataModel();
        }
        if (this.mySettingsStep != null) {
            this.mySettingsStep.updateDataModel();
        }
    }

    public boolean validate() throws ConfigurationException {
        if (this.mySettingsStep != null && !this.mySettingsStep.validate()) {
            return false;
        }
        ModuleWizardStep step = this.getCustomStep();
        if (step != null && !step.validate()) {
            return false;
        }
        if (this.isFrameworksMode() && !this.myFrameworksPanel.validate()) {
            return false;
        }
        return super.validate();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myProjectTypeList;
    }

    public void dispose() {
    }

    public void disposeUIResources() {
        Disposer.dispose((Disposable)this);
    }

    private MultiMap<String, ProjectTemplate> loadLocalTemplates() {
        ProjectTemplateEP[] extensions;
        ConcurrentMultiMap map = new ConcurrentMultiMap();
        for (ProjectTemplateEP ep : extensions = (ProjectTemplateEP[])ProjectTemplateEP.EP_NAME.getExtensions()) {
            ClassLoader classLoader = ep.getLoaderForClass();
            URL url = classLoader.getResource(ep.templatePath);
            if (url != null) {
                try {
                    LocalArchivedTemplate template = new LocalArchivedTemplate(url, classLoader);
                    if (ep.category) {
                        TemplateBasedCategory category = new TemplateBasedCategory(template, ep.projectType);
                        this.myTemplatesMap.putValue((Object)new TemplatesGroup(category), (Object)template);
                        continue;
                    }
                    map.putValue((Object)ep.projectType, (Object)template);
                }
                catch (Exception e) {
                    LOG.error("Error loading template from URL " + ep.templatePath, (Throwable)e);
                }
                continue;
            }
            LOG.error("Can't find resource for project template " + ep.templatePath);
        }
        return map;
    }

    void loadRemoteTemplates(final ChooseTemplateStep chooseTemplateStep) {
        this.myTemplatesList.setPaintBusy(true);
        chooseTemplateStep.getTemplateList().setPaintBusy(true);
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(this.myContext.getProject(), "Loading Templates"){

            public void run(@NotNull ProgressIndicator indicator) {
                RemoteTemplatesFactory factory = new RemoteTemplatesFactory();
                for (String group : factory.getGroups()) {
                    ProjectTemplate[] templates;
                    for (ProjectTemplate template : templates = factory.createTemplates(group, ProjectTypeStep.this.myContext)) {
                        String id = ((ArchivedProjectTemplate)template).getCategory();
                        for (TemplatesGroup templatesGroup : ProjectTypeStep.this.myTemplatesMap.keySet()) {
                            if (!Comparing.equal((String)id, (String)templatesGroup.getId()) && !Comparing.equal((String)group, (String)templatesGroup.getName())) continue;
                            ProjectTypeStep.this.myTemplatesMap.putValue((Object)templatesGroup, (Object)template);
                        }
                    }
                }
            }

            public void onSuccess() {
                super.onSuccess();
                TemplatesGroup group = ProjectTypeStep.this.getSelectedGroup();
                if (group == null) {
                    return;
                }
                Collection templates = ProjectTypeStep.this.myTemplatesMap.get((Object)group);
                ProjectTypeStep.this.setTemplatesList(group, templates, true);
                chooseTemplateStep.updateStep();
            }

            public void onFinished() {
                ProjectTypeStep.this.myTemplatesList.setPaintBusy(false);
                chooseTemplateStep.getTemplateList().setPaintBusy(false);
            }
        });
    }

    private void updateSelection() {
        ProjectTemplate template = this.getSelectedTemplate();
        if (template != null) {
            this.myContext.setProjectTemplate(template);
        }
        ModuleBuilder builder = this.getSelectedBuilder();
        this.myContext.setProjectBuilder((ProjectBuilder)builder);
        if (builder != null) {
            this.myWizard.getSequence().setType(builder.getBuilderId());
        }
        this.myWizard.setDelegate(builder instanceof WizardDelegate ? (WizardDelegate)builder : null);
    }

    public String availableTemplateGroupsToString() {
        ListModel model = this.myProjectTypeList.getModel();
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < model.getSize(); ++i) {
            if (builder.length() > 0) {
                builder.append(", ");
            }
            builder.append(((TemplatesGroup)model.getElementAt(i)).getName());
        }
        return builder.toString();
    }

    public boolean setSelectedTemplate(@NotNull String group, @Nullable String name) {
        ListModel model = this.myProjectTypeList.getModel();
        for (int i = 0; i < model.getSize(); ++i) {
            TemplatesGroup templatesGroup = (TemplatesGroup)model.getElementAt(i);
            if (!group.equals(templatesGroup.getName())) continue;
            this.myProjectTypeList.setSelectedIndex(i);
            if (name == null) {
                return this.getSelectedGroup().getName().equals(group);
            }
            this.setTemplatesList(templatesGroup, this.myTemplatesMap.get((Object)templatesGroup), false);
            return this.myTemplatesList.setSelectedTemplate(name);
        }
        return false;
    }

    public AddSupportForFrameworksPanel getFrameworksPanel() {
        return this.myFrameworksPanel;
    }

    public WizardContext getContext() {
        return this.myContext;
    }

    public void addSettingsField(@NotNull String label, @NotNull JComponent field) {
        ProjectSettingsStep.addField(label, field, this.myHeaderPanel);
    }

    public void addSettingsComponent(@NotNull JComponent component) {
    }

    public void addExpertPanel(@NotNull JComponent panel) {
    }

    public void addExpertField(@NotNull String label, @NotNull JComponent field) {
    }

    public JTextField getModuleNameField() {
        return null;
    }

    public String getHelpId() {
        return this.myContext.isCreatingNewProject() ? "Project_Category_and_Options" : "Module_Category_and_Options";
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBLabel jBLabel;
        JPanel jPanel;
        ProjectTemplateList projectTemplateList;
        JPanel jPanel2;
        JPanel jPanel3;
        JBList jBList;
        JPanel jPanel4;
        this.myPanel = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel4.add((Component)jPanel5, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel5.add((Component)jBScrollPane, new GridConstraints(0, 0, 1, 1, 0, 3, 0, 3, null, new Dimension(200, -1), null));
        this.myProjectTypeList = jBList = new JBList();
        jBList.setSelectionMode(0);
        jBScrollPane.setViewportView((Component)jBList);
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new BorderLayout(0, 0));
        jPanel4.add((Component)jPanel6, new GridConstraints(0, 1, 1, 1, 0, 3, 7, 7, null, null, null));
        this.myHeaderPanel = jPanel3 = new JPanel();
        jPanel3.setLayout(new GridBagLayout());
        jPanel6.add((Component)jPanel3, "North");
        jPanel3.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), null, 0, 0, null, null));
        this.myOptionsPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new CardLayout(0, 0));
        jPanel2.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel6.add((Component)jPanel2, "Center");
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel7, TEMPLATES_CARD);
        this.myTemplatesList = projectTemplateList = new ProjectTemplateList();
        JComponent jComponent = projectTemplateList.$$$getRootComponent$$$();
        jPanel7.add((Component)jComponent, "Center");
        this.myFrameworksPanelPlaceholder = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, FRAMEWORKS_CARD);
        this.myFrameworksLabel = jBLabel = new JBLabel();
        jBLabel.setText("Additional Libraries and Frameworks:");
        jBLabel.setDisplayedMnemonic('F');
        jBLabel.setDisplayedMnemonicIndex(25);
        jPanel.add((Component)jBLabel, "North");
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

